/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class OracleExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<DBSCatalog, OracleSchema> {
    private static final Log log = Log.getLog(OracleExecutionContext.class);
    private String activeSchemaName;

    OracleExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return (OracleDataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public String getActiveSchemaName() {
        return this.activeSchemaName;
    }

    public DBSCatalog getDefaultCatalog() {
        return null;
    }

    public OracleSchema getDefaultSchema() {
        return this.activeSchemaName == null ? null : (OracleSchema)this.getDataSource().schemaCache.getCachedObject(this.activeSchemaName);
    }

    public boolean supportsCatalogChange() {
        return false;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, DBSCatalog catalog, OracleSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, OracleSchema schema) throws DBCException {
        OracleSchema oldSelectedEntity = this.getDefaultSchema();
        if (schema == null || oldSelectedEntity == schema) {
            return;
        }
        this.setCurrentSchema(monitor, schema);
        this.activeSchemaName = schema.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)schema);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema");){
                this.activeSchemaName = OracleUtils.getCurrentSchema(session);
                if (this.activeSchemaName != null && this.activeSchemaName.isEmpty()) {
                    this.activeSchemaName = null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
        return true;
    }

    void setCurrentSchema(DBRProgressMonitor monitor, OracleSchema object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                OracleUtils.setCurrentSchema(session, object.getName());
                this.activeSchemaName = object.getName();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.getDataSource());
        }
    }
}

