/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime.features;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.features.DBRNotificationDescriptor;
import org.jkiss.utils.CommonUtils;

public class DBRFeatureRegistry {
    private static final Log log = Log.getLog(DBRFeatureRegistry.class);
    private static final String NOTIFICATIONS_CONFIG_FILE = "notifications-config.xml";
    private final Map<String, DBRFeature> allFeatures = new HashMap<String, DBRFeature>();
    private final Map<String, DBRFeature> commandFeatures = new HashMap<String, DBRFeature>();
    private final Map<String, DBRNotificationDescriptor> notificationSettings = new HashMap<String, DBRNotificationDescriptor>();
    private static DBRFeatureRegistry instance = null;

    public static synchronized DBRFeatureRegistry getInstance() {
        if (instance == null) {
            instance = new DBRFeatureRegistry();
        }
        return instance;
    }

    private DBRFeatureRegistry() {
        File ncFile = DBRFeatureRegistry.getNotificationsConfigFile();
        ncFile.exists();
    }

    @NotNull
    private static File getNotificationsConfigFile() {
        return new File(ModelActivator.getInstance().getStateLocation().toFile(), NOTIFICATIONS_CONFIG_FILE);
    }

    public synchronized void registerFeatures(Class<?> theClass) {
        Field[] fieldArray = theClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 8) != 0 && field.getType() == DBRFeature.class) {
                try {
                    DBRFeature feature = (DBRFeature)field.get(null);
                    if (feature != null) {
                        String id = String.valueOf(theClass.getSimpleName()) + "." + field.getName();
                        feature.setId(id);
                        this.allFeatures.put(id, feature);
                        if (!CommonUtils.isEmpty((String)feature.getCommandId())) {
                            this.commandFeatures.put(feature.getCommandId(), feature);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            ++n2;
        }
    }

    public List<DBRFeature> getAllFeatures() {
        return new ArrayList<DBRFeature>(this.allFeatures.values());
    }

    public DBRFeature findCommandFeature(String commandId) {
        return this.commandFeatures.get(commandId);
    }

    public void setNotificationSettings(DBRFeature feature, DBRNotificationDescriptor notificationDescriptor) {
        this.notificationSettings.put(feature.getId(), notificationDescriptor);
    }

    public static void useFeature(DBRFeature feature, Map<String, Object> parameters) {
        QMUtils.getDefaultHandler().handleFeatureUsage(feature, parameters);
    }
}

