/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.DBDummyNumberTransformer;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCAttribute;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCTableColumn<TABLE_TYPE extends DBSEntity>
extends JDBCAttribute
implements DBSTableColumn,
DBSEntityAttribute,
DBSAttributeEnumerable,
DBPSaveableObject {
    private final TABLE_TYPE table;
    private boolean persisted;
    private String defaultValue;

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted) {
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted, String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated, String defaultValue) {
        super(name, typeName, valueType, ordinalPosition, maxLength, scale, precision, required, autoGenerated);
        this.defaultValue = defaultValue;
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, DBSEntityAttribute source, boolean persisted) {
        super(source);
        this.table = table;
        this.persisted = persisted;
        this.defaultValue = source.getDefaultValue();
    }

    public TABLE_TYPE getTable() {
        return this.table;
    }

    @NotNull
    public TABLE_TYPE getParentObject() {
        return this.getTable();
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=10)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=true, order=20, listProvider=ColumnTypeNameListProvider.class)
    public String getTypeName() {
        return super.getTypeName();
    }

    @Override
    public void setTypeName(String typeName) {
        super.setTypeName(typeName);
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource instanceof DBPDataTypeProvider) {
            DBSDataType dataType = ((DBPDataTypeProvider)((Object)dataSource)).getLocalDataType(typeName);
            if (dataType != null) {
                this.updateColumnDataType(dataType);
            } else {
                this.updateColumnDataType(null);
            }
        }
    }

    protected void updateColumnDataType(@Nullable DBSDataType dataType) {
        if (dataType != null) {
            this.valueType = dataType.getTypeID();
        }
    }

    @Override
    @Property(viewable=true, editable=true, order=40, valueRenderer=DBDummyNumberTransformer.class)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Override
    @Property(viewable=true, editable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Override
    @Property(viewable=true, editable=true, order=70)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public List<DBDLabelValuePair> getValueEnumeration(@NotNull DBCSession session, @Nullable Object valuePattern, int maxResults) throws DBException {
        DBDValueHandler valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)this);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ").append(DBUtils.getQuotedIdentifier(this)).append(", count(*)");
        query.append("\nFROM ").append(DBUtils.getObjectFullName(this.getTable(), DBPEvaluationContext.DML));
        if (valuePattern instanceof String) {
            query.append("\nWHERE ").append(DBUtils.getQuotedIdentifier(this));
            if (this.getDataKind() == DBPDataKind.STRING) {
                query.append(" LIKE ?");
            } else {
                query.append(" = ?");
            }
        }
        query.append("\nGROUP BY ").append(DBUtils.getQuotedIdentifier(this));
        Throwable throwable = null;
        Object var7_8 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);){
            if (valuePattern instanceof String) {
                if (this.getDataKind() == DBPDataKind.STRING) {
                    valueHandler.bindValueObject(session, dbStat, this, 0, "%" + valuePattern + "%");
                } else {
                    valueHandler.bindValueObject(session, dbStat, this, 0, valuePattern);
                }
            }
            dbStat.setLimit(0L, maxResults);
            if (dbStat.executeStatement()) {
                List<DBDLabelValuePair> list;
                DBCResultSet dbResult;
                Throwable throwable2;
                block26: {
                    throwable2 = null;
                    Object var10_13 = null;
                    dbResult = dbStat.openResultSet();
                    list = DBVUtils.readDictionaryRows(session, this, valueHandler, dbResult);
                    if (dbResult == null) break block26;
                    dbResult.close();
                }
                return list;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            return Collections.emptyList();
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static class ColumnTypeNameListProvider
    implements IPropertyValueListProvider<JDBCTableColumn> {
        @Override
        public boolean allowCustomValue() {
            return true;
        }

        @Override
        public Object[] getPossibleValues(JDBCTableColumn column) {
            TreeSet<String> typeNames = new TreeSet<String>();
            if (column.getDataSource() instanceof DBPDataTypeProvider) {
                for (DBSDataType dBSDataType : ((DBPDataTypeProvider)((Object)column.getDataSource())).getLocalDataTypes()) {
                    if (dBSDataType.getDataKind() == DBPDataKind.UNKNOWN || CommonUtils.isEmpty((String)dBSDataType.getName()) || !Character.isLetter(dBSDataType.getName().charAt(0))) continue;
                    typeNames.add(dBSDataType.getName());
                }
            }
            return typeNames.toArray(new String[typeNames.size()]);
        }
    }
}

