/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.Ref;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCReference;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCComplexValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCReferenceValueHandler
extends JDBCComplexValueHandler {
    private static final Log log = Log.getLog(JDBCReferenceValueHandler.class);
    public static final JDBCReferenceValueHandler INSTANCE = new JDBCReferenceValueHandler();

    @Override
    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        return DBValueFormatting.getDefaultValueDisplayString(value, format);
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        JDBCReference reference = (JDBCReference)value;
        statement.setRef(paramIndex, reference.getValue());
    }

    @NotNull
    public Class<Ref> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Ref.class;
    }

    @Override
    public JDBCReference getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        String typeName;
        try {
            typeName = object instanceof Ref ? ((Ref)object).getBaseTypeName() : type.getTypeName();
        }
        catch (SQLException e) {
            throw new DBCException(e, session.getDataSource());
        }
        JDBCDataType<DBPDataSourceContainer> dataType = null;
        try {
            dataType = DBUtils.resolveDataType(session.getProgressMonitor(), session.getDataSource(), typeName);
        }
        catch (DBException e) {
            log.error("Error resolving data type '" + typeName + "'", e);
        }
        if (dataType == null) {
            dataType = new JDBCDataType<DBPDataSourceContainer>(session.getDataSource().getContainer(), 2006, typeName, "Synthetic struct type for reference '" + typeName + "'", false, false, 0, 0, 0);
        }
        if (object == null) {
            return new JDBCReference(dataType, null);
        }
        if (object instanceof JDBCReference) {
            return (JDBCReference)object;
        }
        if (object instanceof Ref) {
            return new JDBCReference(dataType, (Ref)object);
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }
}

