/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.data.wkb;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import org.jkiss.dbeaver.ext.hana.model.data.wkb.GeometryType;
import org.jkiss.dbeaver.ext.hana.model.data.wkb.HANAWKBParserException;
import org.jkiss.dbeaver.ext.hana.model.data.wkb.XyzmMode;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class HANAWKBParser {
    private static final byte XDR = 0;
    private static final byte NDR = 1;
    private static final int TYPE_MASK = 1048575;
    private static final int XYZM_MODE_DIV = 1000;
    private static final int XYZM_MODE_XY = 0;
    private static final int XYZM_MODE_XYZ = 1;
    private static final int XYZM_MODE_XYM = 2;
    private static final int XYZM_MODE_XYZM = 3;
    private static final int EWKB_FLAG = 0x20000000;
    private GeometryFactory factory;
    private ByteBuffer data;
    private XyzmMode xyzmMode;
    private int dimension;

    public Geometry parse(byte[] wkb) throws HANAWKBParserException {
        this.data = ByteBuffer.wrap(wkb);
        try {
            boolean isEwkb;
            this.readAndSetByteOrder();
            int typeCode = this.data.getInt();
            boolean bl = isEwkb = (typeCode & 0x20000000) != 0;
            if (isEwkb) {
                typeCode -= 0x20000000;
            }
            GeometryType type = this.getGeometryType(typeCode);
            this.xyzmMode = this.getXyzmMode(typeCode);
            this.dimension = this.xyzmMode.getCoordinatesPerPoint();
            int srid = isEwkb ? this.data.getInt() : 0;
            this.factory = new GeometryFactory(new PrecisionModel(), srid);
            Geometry geometry = this.parseGeometryOfType(type);
            if (this.data.hasRemaining()) {
                throw new HANAWKBParserException("There is unparsed WKB data left");
            }
            return geometry;
        }
        catch (BufferUnderflowException e) {
            throw new HANAWKBParserException("WKB is too short", e);
        }
    }

    private Geometry parseGeometryOfType(GeometryType type) throws HANAWKBParserException {
        switch (type) {
            case POINT: {
                return this.parsePoint();
            }
            case LINESTRING: {
                return this.parseLineString();
            }
            case POLYGON: {
                return this.parsePolygon();
            }
            case MULTIPOINT: {
                return this.parseMultiPoint();
            }
            case MULTILINESTRING: {
                return this.parseMultiLineString();
            }
            case MULTIPOLYGON: {
                return this.parseMultiPolygon();
            }
            case GEOMETRYCOLLECTION: {
                return this.parseGeometryCollection();
            }
            case CIRCULARSTRING: {
                throw new HANAWKBParserException("Circular strings are not supported by JTS");
            }
        }
        throw new AssertionError();
    }

    private Point parsePoint() {
        double x = this.data.getDouble();
        double y = this.data.getDouble();
        double z = Double.NaN;
        double m = Double.NaN;
        if (this.xyzmMode.hasZ()) {
            z = this.data.getDouble();
        }
        if (this.xyzmMode.hasM()) {
            m = this.data.getDouble();
        }
        CoordinateSequenceFactory csf = this.factory.getCoordinateSequenceFactory();
        if (Double.isNaN(x)) {
            CoordinateSequence cs = csf.create(0, this.dimension, this.xyzmMode.hasM() ? 1 : 0);
            return this.factory.createPoint(cs);
        }
        CoordinateSequence cs = csf.create(1, this.dimension, this.xyzmMode.hasM() ? 1 : 0);
        cs.getCoordinate(0).setX(x);
        cs.getCoordinate(0).setY(y);
        if (this.xyzmMode.hasZ()) {
            cs.getCoordinate(0).setZ(z);
        }
        if (this.xyzmMode.hasM()) {
            cs.getCoordinate(0).setM(m);
        }
        return this.factory.createPoint(cs);
    }

    private LineString parseLineString() {
        CoordinateSequence cs = this.readCoordinateSequence();
        return this.factory.createLineString(cs);
    }

    private Polygon parsePolygon() {
        int numRings = this.data.getInt();
        if (numRings == 0) {
            return this.factory.createPolygon(null);
        }
        LinearRing shell = this.parseLinearRing();
        if (numRings == 1) {
            return this.factory.createPolygon(shell);
        }
        LinearRing[] holes = new LinearRing[numRings - 1];
        int i = 1;
        while (i < numRings) {
            holes[i - 1] = this.parseLinearRing();
            ++i;
        }
        return this.factory.createPolygon(shell, holes);
    }

    private MultiPoint parseMultiPoint() {
        CoordinateSequence cs = this.readCoordinateSequence();
        return this.factory.createMultiPoint(cs);
    }

    private MultiLineString parseMultiLineString() throws HANAWKBParserException {
        int numLineStrings = this.data.getInt();
        LineString[] lineStrings = new LineString[numLineStrings];
        int i = 0;
        while (i < numLineStrings) {
            lineStrings[i] = (LineString)this.parseSubGeometry();
            ++i;
        }
        return this.factory.createMultiLineString(lineStrings);
    }

    private MultiPolygon parseMultiPolygon() throws HANAWKBParserException {
        int numPolygons = this.data.getInt();
        Polygon[] polygons = new Polygon[numPolygons];
        int i = 0;
        while (i < numPolygons) {
            polygons[i] = (Polygon)this.parseSubGeometry();
            ++i;
        }
        return this.factory.createMultiPolygon(polygons);
    }

    private GeometryCollection parseGeometryCollection() throws HANAWKBParserException {
        int numGeometries = this.data.getInt();
        Geometry[] geometries = new Geometry[numGeometries];
        int i = 0;
        while (i < numGeometries) {
            geometries[i] = this.parseSubGeometry();
            ++i;
        }
        return this.factory.createGeometryCollection(geometries);
    }

    private Geometry parseSubGeometry() throws HANAWKBParserException {
        this.readAndSetByteOrder();
        int typeCode = this.data.getInt();
        GeometryType type = this.getGeometryType(typeCode);
        return this.parseGeometryOfType(type);
    }

    private LinearRing parseLinearRing() {
        CoordinateSequence cs = this.readCoordinateSequence();
        return this.factory.createLinearRing(cs);
    }

    private CoordinateSequence readCoordinateSequence() {
        CoordinateSequenceFactory csf = this.factory.getCoordinateSequenceFactory();
        int numPoints = this.data.getInt();
        CoordinateSequence cs = csf.create(numPoints, this.dimension, this.xyzmMode.hasM() ? 1 : 0);
        switch (this.xyzmMode) {
            case XY: {
                int i = 0;
                while (i < numPoints) {
                    cs.getCoordinate(i).setX(this.data.getDouble());
                    cs.getCoordinate(i).setY(this.data.getDouble());
                    ++i;
                }
                break;
            }
            case XYZ: {
                int i = 0;
                while (i < numPoints) {
                    cs.getCoordinate(i).setX(this.data.getDouble());
                    cs.getCoordinate(i).setY(this.data.getDouble());
                    cs.getCoordinate(i).setZ(this.data.getDouble());
                    ++i;
                }
                break;
            }
            case XYM: {
                int i = 0;
                while (i < numPoints) {
                    cs.getCoordinate(i).setX(this.data.getDouble());
                    cs.getCoordinate(i).setY(this.data.getDouble());
                    cs.getCoordinate(i).setM(this.data.getDouble());
                    ++i;
                }
                break;
            }
            case XYZM: {
                int i = 0;
                while (i < numPoints) {
                    cs.getCoordinate(i).setX(this.data.getDouble());
                    cs.getCoordinate(i).setY(this.data.getDouble());
                    cs.getCoordinate(i).setZ(this.data.getDouble());
                    cs.getCoordinate(i).setM(this.data.getDouble());
                    ++i;
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return cs;
    }

    private GeometryType getGeometryType(int typeCode) throws HANAWKBParserException {
        int wkbType = typeCode & 0xFFFFF;
        GeometryType type = GeometryType.getFromCode(wkbType %= 1000);
        if (type == null) {
            throw new HANAWKBParserException(MessageFormat.format("Unknown WKB type {0}", wkbType));
        }
        return type;
    }

    private XyzmMode getXyzmMode(int typeCode) throws HANAWKBParserException {
        int wkbType = typeCode & 0xFFFFF;
        int xyzmFlag = wkbType / 1000;
        switch (xyzmFlag) {
            case 0: {
                return XyzmMode.XY;
            }
            case 1: {
                return XyzmMode.XYZ;
            }
            case 2: {
                return XyzmMode.XYM;
            }
            case 3: {
                return XyzmMode.XYZM;
            }
        }
        throw new HANAWKBParserException(MessageFormat.format("Invalid XYZM-mode {0}", xyzmFlag));
    }

    private void readAndSetByteOrder() throws HANAWKBParserException {
        byte order = this.data.get();
        switch (order) {
            case 0: {
                this.data.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            case 1: {
                this.data.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            default: {
                throw new HANAWKBParserException(MessageFormat.format("Invalid BOM value {0}", order));
            }
        }
    }
}

