/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ToolWizardPageLog
extends WizardPage {
    private StyledText dumpLogText;
    private String task;

    public ToolWizardPageLog(String task) {
        super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.task = task;
        this.setTitle(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.setDescription(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_progress_log, (Object)task));
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.dumpLogText = new StyledText(composite, 2826);
        GridData gd = new GridData(1808);
        this.dumpLogText.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public Writer getLogWriter() {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                ToolWizardPageLog.this.appendLog(new String(cbuf, off, len));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public void appendLog(String line) {
        this.appendLog(line, false);
    }

    public void appendLog(String line, boolean error) {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec(() -> {
            ToolWizardPageLog toolWizardPageLog = this;
            synchronized (toolWizardPageLog) {
                if (!this.dumpLogText.isDisposed()) {
                    int caretOffset = this.dumpLogText.getCaretOffset();
                    this.dumpLogText.append(line);
                    this.dumpLogText.setCaretOffset(this.dumpLogText.getCharCount());
                    this.dumpLogText.showSelection();
                    if (error) {
                        StyleRange style1Range = new StyleRange();
                        style1Range.start = caretOffset;
                        style1Range.length = line.length();
                        style1Range.foreground = this.dumpLogText.getDisplay().getSystemColor(3);
                        this.dumpLogText.setStyleRange(style1Range);
                    }
                }
            }
        });
    }

    public void clearLog() {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec(() -> {
            ToolWizardPageLog toolWizardPageLog = this;
            synchronized (toolWizardPageLog) {
                if (!this.dumpLogText.isDisposed()) {
                    this.dumpLogText.setText("");
                }
            }
        });
    }

    public void startLogReader(ProcessBuilder processBuilder, InputStream stream) {
        new LogReaderJob(processBuilder, stream).start();
    }

    public void startNullReader(InputStream stream) {
        new NullReaderJob(stream).start();
    }

    private class LogReaderJob
    extends Thread {
        private ProcessBuilder processBuilder;
        private InputStream input;

        protected LogReaderJob(ProcessBuilder processBuilder, InputStream stream) {
            super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_log_reader, (Object)ToolWizardPageLog.this.task));
            this.processBuilder = processBuilder;
            this.input = stream;
        }

        @Override
        public void run() {
            AbstractToolWizard wizard = (AbstractToolWizard)ToolWizardPageLog.this.getWizard();
            String lf = GeneralUtils.getDefaultLineSeparator();
            List<String> command = this.processBuilder.command();
            StringBuilder cmdString = new StringBuilder();
            for (String cmd : command) {
                if (wizard.isSecureString(cmd)) {
                    cmd = "******";
                }
                if (cmdString.length() > 0) {
                    cmdString.append(' ');
                }
                cmdString.append(cmd);
            }
            cmdString.append(lf);
            ToolWizardPageLog.this.appendLog(cmdString.toString());
            ToolWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_started_at, (Object)ToolWizardPageLog.this.task, (Object)new Date())) + lf);
            try {
                try {
                    InputStream in = this.input;
                    Object object = null;
                    Object var7_9 = null;
                    try (InputStreamReader reader = new InputStreamReader(in, GeneralUtils.getDefaultConsoleEncoding());){
                        int b;
                        StringBuilder buf = new StringBuilder();
                        while ((b = ((Reader)reader).read()) != -1) {
                            buf.append((char)b);
                            if (b != 10) continue;
                            ToolWizardPageLog.this.appendLog(buf.toString());
                            buf.setLength(0);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    ToolWizardPageLog.this.appendLog(String.valueOf(e.getMessage()) + lf);
                    ToolWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_finished, (Object)ToolWizardPageLog.this.task, (Object)new Date())) + lf);
                }
            }
            finally {
                ToolWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_finished, (Object)ToolWizardPageLog.this.task, (Object)new Date())) + lf);
            }
        }
    }

    private class NullReaderJob
    extends Thread {
        private InputStream input;

        protected NullReaderJob(InputStream stream) {
            super(NLS.bind((String)TaskNativeUIMessages.tools_wizard_page_log_task_log_reader, (Object)ToolWizardPageLog.this.task));
            this.input = stream;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1000];
                while ((count = this.input.read(buffer)) > 0) {
                }
            }
            catch (IOException iOException) {}
        }
    }
}

