/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ProgressStreamReader;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.ToolWizardPageLog;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public abstract class AbstractToolWizard<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends TaskConfigurationWizard {
    private static final Log log = Log.getLog(AbstractToolWizard.class);
    private final DBPPreferenceStore preferenceStore;
    private final SETTINGS settings;
    protected String taskTitle;
    protected final ToolWizardPageLog logPage;
    private boolean finished;
    protected boolean transferFinished;
    private boolean refreshObjects;
    private boolean isSuccess;
    private String errorMessage;

    protected AbstractToolWizard(@NotNull Collection<BASE_OBJECT> databaseObjects, @NotNull String taskTitle) {
        this.preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        this.settings = this.createSettings();
        this.settings.getDatabaseObjects().addAll(databaseObjects);
        this.taskTitle = taskTitle;
        this.logPage = new ToolWizardPageLog(taskTitle);
    }

    public AbstractToolWizard(@NotNull DBTTask task) {
        super(task);
        this.preferenceStore = new TaskPreferenceStore(task);
        this.settings = this.createSettings();
        this.taskTitle = task.getType().getName();
        this.logPage = new ToolWizardPageLog(this.taskTitle);
    }

    protected abstract SETTINGS createSettings();

    public SETTINGS getSettings() {
        return this.settings;
    }

    @NotNull
    protected DBPPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public DBPProject getProject() {
        if (this.settings.getDataSourceContainer() != null) {
            return this.settings.getDataSourceContainer().getProject();
        }
        return super.getProject();
    }

    protected String getDefaultWindowTitle() {
        return this.taskTitle;
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.isSingleTimeWizard()) {
            return !this.finished;
        }
        return true;
    }

    protected boolean isSingleTimeWizard() {
        return false;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    public List<BASE_OBJECT> getDatabaseObjects() {
        return this.settings.getDatabaseObjects();
    }

    public DBPConnectionConfiguration getConnectionInfo() {
        DBPDataSourceContainer ds = this.settings.getDataSourceContainer();
        if (ds != null) {
            return ds.getConnectionConfiguration();
        }
        return null;
    }

    public DBPNativeClientLocation getClientHome() {
        return this.settings.getClientHome();
    }

    public String getToolUserName() {
        return this.settings.getToolUserName();
    }

    public void setToolUserName(String toolUserName) {
        this.settings.setToolUserName(toolUserName);
    }

    public String getToolUserPassword() {
        return this.settings.getToolUserPassword();
    }

    public void setToolUserPassword(String toolUserPassword) {
        this.settings.setToolUserPassword(toolUserPassword);
    }

    public String getExtraCommandArgs() {
        return this.settings.getExtraCommandArgs();
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.settings.getDataSourceContainer();
    }

    public DBPNativeClientLocation findNativeClientHome(String clientHomeId) {
        return null;
    }

    public abstract Collection<PROCESS_ARG> getRunInfo();

    public Collection<BASE_OBJECT> getUpdatedObjects(PROCESS_ARG settings) {
        return Collections.emptyList();
    }

    public void createPageControls(Composite pageContainer) {
        this.settings.loadSettings(this.getRunnableContext(), this.getPreferenceStore());
        super.createPageControls(pageContainer);
        this.updateErrorMessage();
    }

    public void updateErrorMessage() {
        WizardPage currentPage = (WizardPage)this.getStartingPage();
        if (this.isNativeClientHomeRequired()) {
            String clientHomeId = this.getDataSourceContainer().getConnectionConfiguration().getClientHomeId();
            List nativeClientLocations = this.getDataSourceContainer().getDriver().getNativeClientLocations();
            if (clientHomeId == null) {
                if (nativeClientLocations != null && !nativeClientLocations.isEmpty()) {
                    this.settings.setClientHome((DBPNativeClientLocation)nativeClientLocations.get(0));
                } else {
                    this.settings.setClientHome(null);
                }
                if (this.settings.getClientHome() == null) {
                    currentPage.setErrorMessage(TaskNativeUIMessages.tools_wizard_message_no_client_home);
                    this.getContainer().updateMessage();
                    return;
                }
            } else {
                DBPNativeClientLocation clientHome = (DBPNativeClientLocation)DBUtils.findObject((Collection)nativeClientLocations, (String)clientHomeId);
                if (clientHome == null) {
                    clientHome = this.findNativeClientHome(clientHomeId);
                }
                this.settings.setClientHome(clientHome);
            }
            if (this.settings.getClientHome() == null) {
                currentPage.setErrorMessage(NLS.bind((String)TaskNativeUIMessages.tools_wizard_message_client_home_not_found, (Object)clientHomeId));
            } else {
                currentPage.setErrorMessage(null);
            }
            this.getContainer().updateMessage();
        }
    }

    private boolean validateClientFiles() {
        if (!this.isNativeClientHomeRequired() || this.settings.getClientHome() == null) {
            return true;
        }
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                try {
                    this.settings.getClientHome().validateFilesPresence(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Download native client file(s)", "Error downloading client file(s)", e.getTargetException());
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("Error downloading native client file(s)");
            this.getContainer().updateMessage();
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        this.settings.saveSettings(this.getRunnableContext(), this.getPreferenceStore());
        if (!this.validateClientFiles()) {
            return false;
        }
        if (this.isRunTaskOnFinish()) {
            return super.performFinish();
        }
        if (this.getContainer().getCurrentPage() != this.logPage) {
            this.getContainer().showPage((IWizardPage)this.logPage);
        }
        if (this.getCurrentTask() == null) {
            try {
                DBTTaskHandler handler = null;
                try {
                    handler = this.getTaskType().createHandler();
                }
                catch (Throwable throwable) {}
                if (handler != null) {
                    DBTTask temporaryTask = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getTaskType().getName());
                    this.saveConfigurationToTask(temporaryTask);
                    TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), temporaryTask, log, this.logPage.getLogWriter());
                    executor.executeTask();
                    return false;
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(e.getMessage(), "Error running task", (Throwable)e);
                return false;
            }
        }
        long startTime = System.currentTimeMillis();
        try {
            try {
                UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)new ToolRunner());
            }
            catch (InterruptedException interruptedException) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)this.taskTitle, (String)NLS.bind((String)TaskNativeUIMessages.tools_wizard_error_task_canceled, (Object)this.taskTitle, (Object)this.getObjectsName()), (int)1);
                this.getContainer().updateButtons();
                return false;
            }
            catch (InvocationTargetException ex) {
                DBWorkbench.getPlatformUI().showError(NLS.bind((String)TaskNativeUIMessages.tools_wizard_error_task_error_title, (Object)this.taskTitle), String.valueOf(TaskNativeUIMessages.tools_wizard_error_task_error_message) + this.taskTitle, ex.getTargetException());
                this.getContainer().updateButtons();
                return false;
            }
        }
        finally {
            this.getContainer().updateButtons();
        }
        long workTime = System.currentTimeMillis() - startTime;
        this.notifyToolFinish(String.valueOf(this.taskTitle) + " finished", workTime);
        if (this.isSuccess) {
            this.onSuccess(workTime);
        } else {
            this.onError();
        }
        return false;
    }

    protected void notifyToolFinish(String toolName, long workTime) {
        Display.getCurrent().beep();
        if (workTime > DBWorkbench.getPlatformUI().getLongOperationTimeout() * 1000L) {
            DBWorkbench.getPlatformUI().notifyAgent(toolName, 1);
        }
    }

    public String getObjectsName() {
        StringBuilder str = new StringBuilder();
        for (DBSObject object : this.settings.getDatabaseObjects()) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(object.getName());
        }
        return str.toString();
    }

    public boolean executeProcess(DBRProgressMonitor monitor, PROCESS_ARG arg) throws IOException, CoreException, InterruptedException {
        monitor.beginTask(this.getWindowTitle(), 1);
        List<String> commandLine = this.getCommandLine(arg);
        File execPath = new File(commandLine.get(0));
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.directory(execPath.getParentFile());
        if (this.isMergeProcessStreams()) {
            processBuilder.redirectErrorStream(true);
        }
        this.setupProcessParameters(processBuilder);
        Process process = processBuilder.start();
        this.startProcessHandler(monitor, arg, processBuilder, process);
        Thread.sleep(100L);
        while (true) {
            Thread.sleep(100L);
            if (monitor.isCanceled()) {
                process.destroy();
            }
            try {
                int exitCode = process.exitValue();
                if (exitCode != 0) {
                    this.errorMessage = NLS.bind((String)TaskNativeUIMessages.tools_wizard_log_process_exit_code, (Object)exitCode);
                    this.logPage.appendLog(String.valueOf(this.errorMessage) + "\n", true);
                    return false;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    continue;
                }
                catch (IOException e) {
                    monitor.done();
                    log.error((Object)e);
                    this.logPage.appendLog(String.valueOf(NLS.bind((String)TaskNativeUIMessages.tools_wizard_log_io_error, (Object)e.getMessage())) + "\n", true);
                    return false;
                }
            }
            break;
        }
        return true;
    }

    protected boolean isNativeClientHomeRequired() {
        return true;
    }

    protected boolean isMergeProcessStreams() {
        return false;
    }

    public boolean isVerbose() {
        return false;
    }

    protected void onSuccess(long workTime) {
    }

    protected void onError() {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)this.taskTitle, (String)(this.errorMessage == null ? "Internal error" : this.errorMessage), (int)1);
    }

    protected abstract List<String> getCommandLine(PROCESS_ARG var1) throws IOException;

    public abstract void fillProcessParameters(List<String> var1, PROCESS_ARG var2) throws IOException;

    protected void setupProcessParameters(ProcessBuilder process) {
    }

    protected abstract void startProcessHandler(DBRProgressMonitor var1, PROCESS_ARG var2, ProcessBuilder var3, Process var4);

    public boolean isSecureString(String string) {
        String password = this.getToolUserPassword();
        return !CommonUtils.isEmpty((String)password) && string.contains(password);
    }

    public class BinaryFileTransformerJob
    extends Thread {
        private DBRProgressMonitor monitor;
        private OutputStream output;
        private File inputFile;

        public BinaryFileTransformerJob(DBRProgressMonitor monitor, File inputFile, OutputStream stream) {
            super(AbstractToolWizard.this.taskTitle);
            this.monitor = monitor;
            this.output = stream;
            this.inputFile = inputFile;
        }

        @Override
        public void run() {
            try {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, AbstractToolWizard.this.taskTitle, (InputStream)new FileInputStream(this.inputFile), this.inputFile.length());){
                        byte[] buffer = new byte[100000];
                        while (!this.monitor.isCanceled()) {
                            int readSize = scriptStream.read(buffer);
                            if (readSize < 0) break;
                            this.output.write(buffer, 0, readSize);
                            this.output.flush();
                        }
                        this.output.flush();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    log.debug((Object)e);
                    AbstractToolWizard.this.logPage.appendLog(String.valueOf(e.getMessage()) + "\n");
                    try {
                        this.output.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)e2);
                    }
                    this.monitor.done();
                    AbstractToolWizard.this.transferFinished = true;
                }
            }
            finally {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
                this.monitor.done();
                AbstractToolWizard.this.transferFinished = true;
            }
        }
    }

    public class DumpCopierJob
    extends DumpJob {
        public DumpCopierJob(DBRProgressMonitor monitor, String name, InputStream stream, File outFile) {
            super(name, monitor, stream, outFile);
        }

        @Override
        public void runDump() throws IOException {
            this.monitor.beginTask(this.getName(), 100);
            long totalBytesDumped = 0L;
            long prevStatusUpdateTime = 0L;
            byte[] buffer = new byte[10000];
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Throwable throwable = null;
                Object var8_7 = null;
                try (FileOutputStream output = new FileOutputStream(this.outFile);){
                    int count;
                    while ((count = this.input.read(buffer)) > 0) {
                        totalBytesDumped += (long)count;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - prevStatusUpdateTime > 300L) {
                            this.monitor.subTask(String.valueOf(numberFormat.format(totalBytesDumped)) + " bytes");
                            prevStatusUpdateTime = currentTime;
                        }
                        ((OutputStream)output).write(buffer, 0, count);
                    }
                    output.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    public abstract class DumpJob
    extends Thread {
        protected DBRProgressMonitor monitor;
        protected InputStream input;
        protected File outFile;

        protected DumpJob(String name, DBRProgressMonitor monitor, InputStream stream, File outFile) {
            super(name);
            this.monitor = monitor;
            this.input = stream;
            this.outFile = outFile;
        }

        @Override
        public final void run() {
            try {
                this.runDump();
            }
            catch (IOException e) {
                AbstractToolWizard.this.logPage.appendLog(e.getMessage());
            }
        }

        protected abstract void runDump() throws IOException;
    }

    public class TextFileTransformerJob
    extends Thread {
        private DBRProgressMonitor monitor;
        private OutputStream output;
        private File inputFile;
        private String inputCharset;
        private String outputCharset;

        public TextFileTransformerJob(DBRProgressMonitor monitor, File inputFile, OutputStream stream, String inputCharset, String outputCharset) {
            super(AbstractToolWizard.this.taskTitle);
            this.monitor = monitor;
            this.output = stream;
            this.inputFile = inputFile;
            this.inputCharset = inputCharset;
            this.outputCharset = outputCharset;
        }

        @Override
        public void run() {
            try {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, AbstractToolWizard.this.taskTitle, (InputStream)new FileInputStream(this.inputFile), this.inputFile.length());){
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptStream, this.inputCharset));
                            PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.output, this.outputCharset));
                            while (!this.monitor.isCanceled()) {
                                String line = reader.readLine();
                                if (line == null) break;
                                writer.println(line);
                                writer.flush();
                            }
                            this.output.flush();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        IOUtils.close((Closeable)this.output);
                    }
                }
                catch (IOException e) {
                    log.debug((Object)e);
                    AbstractToolWizard.this.logPage.appendLog(e.getMessage());
                    this.monitor.done();
                    AbstractToolWizard.this.transferFinished = true;
                }
            }
            finally {
                this.monitor.done();
                AbstractToolWizard.this.transferFinished = true;
            }
        }
    }

    private class ToolRunner
    implements DBRRunnableWithProgress {
        private ToolRunner() {
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                try {
                    AbstractToolWizard.this.isSuccess = true;
                    for (Object arg : AbstractToolWizard.this.getRunInfo()) {
                        if (monitor.isCanceled()) break;
                        if (AbstractToolWizard.this.executeProcess(monitor, arg)) continue;
                        AbstractToolWizard.this.isSuccess = false;
                    }
                    AbstractToolWizard.this.refreshObjects = AbstractToolWizard.this.isSuccess && !monitor.isCanceled();
                    if (AbstractToolWizard.this.refreshObjects && AbstractToolWizard.this.needsModelRefresh()) {
                        for (DBSObject object : AbstractToolWizard.this.settings.getDatabaseObjects()) {
                            DBNDatabaseNode node = AbstractToolWizard.this.settings.getDataSourceContainer().getPlatform().getNavigatorModel().findNode(object);
                            if (node == null) continue;
                            node.refreshNode(monitor, (Object)AbstractToolWizard.this);
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                AbstractToolWizard.this.finished = true;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
    }
}

