/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.File;
import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;

public abstract class AbstractImportExportWizard<SETTINGS extends AbstractImportExportSettings<DBSObject>, PROCESS_ARG>
extends AbstractToolWizard<SETTINGS, DBSObject, PROCESS_ARG>
implements IExportWizard {
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_TIMESTAMP = "timestamp";

    protected AbstractImportExportWizard(Collection<DBSObject> objects, String title) {
        super(objects, title);
    }

    protected AbstractImportExportWizard(DBTTask task) {
        super(task);
    }

    @Override
    protected boolean isSingleTimeWizard() {
        return false;
    }

    public boolean isRunTaskOnFinish() {
        return true;
    }

    public File getOutputFolder() {
        return ((AbstractImportExportSettings)this.getSettings()).getOutputFolder();
    }

    public void setOutputFolder(File outputFolder) {
        if (outputFolder != null) {
            DialogUtils.setCurDialogFolder((String)outputFolder.getAbsolutePath());
        }
        ((AbstractImportExportSettings)this.getSettings()).setOutputFolder(outputFolder);
    }

    public String getOutputFilePattern() {
        return ((AbstractImportExportSettings)this.getSettings()).getOutputFilePattern();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.taskTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.logPage);
    }

    @Override
    public boolean performFinish() {
        File dir;
        if (this.isExportWizard() && !(dir = ((AbstractImportExportSettings)this.getSettings()).getOutputFolder()).exists() && !dir.mkdirs()) {
            this.logPage.setMessage("Can't create directory '" + dir.getAbsolutePath() + "'", 3);
            this.getContainer().updateMessage();
            return false;
        }
        return super.performFinish();
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    public boolean isExportWizard() {
        return true;
    }

    @Override
    protected void startProcessHandler(DBRProgressMonitor monitor, PROCESS_ARG arg, ProcessBuilder processBuilder, Process process) {
        this.logPage.startLogReader(processBuilder, process.getErrorStream());
    }
}

