/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHTunnelImpl;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.net.ssh.SSHUIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SSHTunnelConfiguratorUI
implements IObjectPropertyConfigurator<DBWHandlerConfiguration> {
    private DBWHandlerConfiguration savedConfiguration;
    private Text hostText;
    private Spinner portText;
    private Text userNameText;
    private Combo authMethodCombo;
    private TextWithOpen privateKeyText;
    private Label pwdLabel;
    private Text passwordText;
    private Button savePasswordCheckbox;
    private Label privateKeyLabel;
    private Combo tunnelImplCombo;
    private Text localHostText;
    private Spinner localPortSpinner;
    private Text remoteHostText;
    private Spinner remotePortSpinner;
    private Spinner keepAliveText;
    private Spinner tunnelTimeout;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)SSHUIMessages.model_ssh_configurator_group_settings, (int)2, (int)770, (int)-1);
        UIUtils.createControlLabel((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_host_ip);
        Composite hostPortComp = UIUtils.createComposite((Composite)settingsGroup, (int)3);
        hostPortComp.setLayoutData((Object)new GridData(768));
        this.hostText = new Text(hostPortComp, 2048);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.portText = UIUtils.createLabelSpinner((Composite)hostPortComp, (String)SSHUIMessages.model_ssh_configurator_label_port, (int)22, (int)0, (int)65535);
        this.userNameText = UIUtils.createLabelText((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_user_name, null, (int)2048, (Object)new GridData(768));
        this.authMethodCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_combo_auth_method, (int)12);
        this.authMethodCombo.setLayoutData((Object)new GridData(32));
        this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_password);
        this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_pub_key);
        this.authMethodCombo.add(SSHUIMessages.model_ssh_configurator_combo_agent);
        this.privateKeyLabel = UIUtils.createControlLabel((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_private_key);
        this.privateKeyLabel.setLayoutData((Object)new GridData(32));
        this.privateKeyText = new TextWithOpenFile((Composite)settingsGroup, SSHUIMessages.model_ssh_configurator_dialog_choose_private_key, new String[]{"*", "*.ssh", "*.pem", "*.*"});
        this.privateKeyText.setLayoutData((Object)new GridData(768));
        this.pwdLabel = UIUtils.createControlLabel((Composite)settingsGroup, (String)SSHUIMessages.model_ssh_configurator_label_password);
        Composite passComp = UIUtils.createComposite((Composite)settingsGroup, (int)2);
        passComp.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(passComp, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        this.savePasswordCheckbox = UIUtils.createCheckbox((Composite)passComp, (String)SSHUIMessages.model_ssh_configurator_checkbox_save_pass, (boolean)false);
        this.savePasswordCheckbox.setLayoutData((Object)new GridData(32));
        Group advancedGroup = UIUtils.createControlGroup((Composite)composite, (String)SSHUIMessages.model_ssh_configurator_group_advanced, (int)4, (int)770, (int)-1);
        this.tunnelImplCombo = UIUtils.createLabelCombo((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_implementation, (int)12);
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.tunnelImplCombo.setLayoutData((Object)gd);
        for (SSHImplementationDescriptor it : SSHImplementationRegistry.getInstance().getDescriptors()) {
            this.tunnelImplCombo.add(it.getLabel());
        }
        this.localHostText = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_local_host, null, (int)2048, (Object)new GridData(768));
        this.localHostText.setToolTipText(SSHUIMessages.model_ssh_configurator_label_local_host_description);
        this.remoteHostText = UIUtils.createLabelText((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_remote_host, null, (int)2048, (Object)new GridData(768));
        this.remoteHostText.setToolTipText(SSHUIMessages.model_ssh_configurator_label_remote_host_description);
        this.localPortSpinner = UIUtils.createLabelSpinner((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_local_port, (int)0, (int)0, (int)65535);
        this.localPortSpinner.setToolTipText(SSHUIMessages.model_ssh_configurator_label_local_port_description);
        this.remotePortSpinner = UIUtils.createLabelSpinner((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_remote_port, (int)0, (int)0, (int)65535);
        this.remotePortSpinner.setToolTipText(SSHUIMessages.model_ssh_configurator_label_remote_port_description);
        UIUtils.createHorizontalLine((Composite)advancedGroup, (int)4, (int)0);
        gd = new GridData(32);
        this.keepAliveText = UIUtils.createLabelSpinner((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_keep_alive, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.keepAliveText.setLayoutData((Object)gd);
        this.tunnelTimeout = UIUtils.createLabelSpinner((Composite)advancedGroup, (String)SSHUIMessages.model_ssh_configurator_label_tunnel_timeout, (int)10000, (int)0, (int)300000);
        this.tunnelTimeout.setLayoutData((Object)gd);
        Composite controlGroup = UIUtils.createPlaceholder((Composite)composite, (int)1);
        gd = new GridData(768);
        controlGroup.setLayoutData((Object)gd);
        UIUtils.createPushButton((Composite)controlGroup, (String)SSHUIMessages.model_ssh_configurator_button_test_tunnel, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.testTunnelConnection();
            }
        });
        this.authMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHTunnelConfiguratorUI.this.updateAuthMethodVisibility();
            }
        });
    }

    private void testTunnelConnection() {
        DBWHandlerConfiguration configuration = new DBWHandlerConfiguration(this.savedConfiguration);
        configuration.setProperties(Collections.emptyMap());
        this.saveSettings(configuration);
        try {
            String[] tunnelVersions = new String[2];
            UIUtils.runInProgressDialog(monitor -> {
                monitor.beginTask("Instantiate SSH tunnel", 2);
                SSHTunnelImpl tunnel = new SSHTunnelImpl();
                DBPConnectionConfiguration connectionConfig = new DBPConnectionConfiguration();
                connectionConfig.setHostName("localhost");
                connectionConfig.setHostPort(configuration.getStringProperty("port"));
                try {
                    monitor.subTask("Initialize tunnel");
                    tunnel.initializeHandler(monitor, (DBPPlatform)DBeaverCore.getInstance(), configuration, connectionConfig);
                    monitor.worked(1);
                    stringArray[0] = tunnel.getImplementation().getClientVersion();
                    stringArray[1] = tunnel.getImplementation().getServerVersion();
                    monitor.subTask("Close tunnel");
                    tunnel.closeTunnel(monitor);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            });
            MessageDialog.openInformation((Shell)this.hostText.getShell(), (String)CoreMessages.dialog_connection_wizard_start_connection_monitor_success, (String)("Connected!\n\nClient version: " + tunnelVersions[0] + "\nServer version: " + tunnelVersions[1]));
        }
        catch (InvocationTargetException ex) {
            DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, null, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
        }
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        int timeoutValue;
        int kaValue;
        this.hostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("host")));
        int portString = configuration.getIntProperty("port");
        if (portString != 0) {
            this.portText.setSelection(portString);
        } else {
            this.portText.setSelection(22);
        }
        this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        String authTypeName = configuration.getStringProperty("authType");
        if (!CommonUtils.isEmpty((String)authTypeName)) {
            authType = SSHConstants.AuthType.valueOf((String)authTypeName);
        }
        if (SSHConstants.AuthType.PASSWORD.equals((Object)authType)) {
            this.authMethodCombo.select(0);
        } else if (SSHConstants.AuthType.PUBLIC_KEY.equals((Object)authType)) {
            this.authMethodCombo.select(1);
        } else {
            this.authMethodCombo.select(2);
        }
        this.privateKeyText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("keyPath")));
        this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
        String implType = configuration.getStringProperty("implementation");
        if (CommonUtils.isEmpty((String)implType)) {
            this.tunnelImplCombo.select(0);
        } else {
            SSHImplementationDescriptor desc = SSHImplementationRegistry.getInstance().getDescriptor(implType);
            if (desc != null) {
                this.tunnelImplCombo.setText(desc.getLabel());
            } else {
                this.tunnelImplCombo.select(0);
            }
        }
        this.localHostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("localHost")));
        int lpValue = configuration.getIntProperty("localPort");
        if (lpValue != 0) {
            this.localPortSpinner.setSelection(lpValue);
        }
        this.remoteHostText.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("remoteHost")));
        int rpValue = configuration.getIntProperty("remotePort");
        if (rpValue != 0) {
            this.remotePortSpinner.setSelection(rpValue);
        }
        if ((kaValue = configuration.getIntProperty("aliveInterval")) != 0) {
            this.keepAliveText.setSelection(kaValue);
        }
        if ((timeoutValue = configuration.getIntProperty("sshConnectTimeout")) != 0) {
            this.tunnelTimeout.setSelection(timeoutValue);
        }
        this.updateAuthMethodVisibility();
        this.savedConfiguration = new DBWHandlerConfiguration(configuration);
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.setProperty("host", (Object)this.hostText.getText());
        configuration.setProperty("port", (Object)this.portText.getSelection());
        switch (this.authMethodCombo.getSelectionIndex()) {
            case 0: {
                configuration.setProperty("authType", (Object)SSHConstants.AuthType.PASSWORD.name());
                break;
            }
            case 1: {
                configuration.setProperty("authType", (Object)SSHConstants.AuthType.PUBLIC_KEY.name());
                break;
            }
            case 2: {
                configuration.setProperty("authType", (Object)SSHConstants.AuthType.AGENT.name());
            }
        }
        configuration.setProperty("keyPath", (Object)this.privateKeyText.getText());
        configuration.setUserName(this.userNameText.getText());
        configuration.setPassword(this.passwordText.getText());
        configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
        String implLabel = this.tunnelImplCombo.getText();
        for (SSHImplementationDescriptor it : SSHImplementationRegistry.getInstance().getDescriptors()) {
            if (!it.getLabel().equals(implLabel)) continue;
            configuration.setProperty("implementation", (Object)it.getId());
            break;
        }
        configuration.setProperty("localHost", (Object)this.localHostText.getText());
        int localPort = this.localPortSpinner.getSelection();
        if (localPort <= 0) {
            configuration.setProperty("localPort", null);
        } else {
            configuration.setProperty("localPort", (Object)localPort);
        }
        configuration.setProperty("remoteHost", (Object)this.remoteHostText.getText());
        int remotePort = this.remotePortSpinner.getSelection();
        if (remotePort <= 0) {
            configuration.setProperty("remotePort", null);
        } else {
            configuration.setProperty("remotePort", (Object)remotePort);
        }
        int kaInterval = this.keepAliveText.getSelection();
        if (kaInterval <= 0) {
            configuration.setProperty("aliveInterval", null);
        } else {
            configuration.setProperty("aliveInterval", (Object)kaInterval);
        }
        int conTimeout = this.tunnelTimeout.getSelection();
        if (conTimeout != 0 && conTimeout != 10000) {
            configuration.setProperty("sshConnectTimeout", (Object)conTimeout);
        }
    }

    public void resetSettings(DBWHandlerConfiguration configuration) {
    }

    private void updateAuthMethodVisibility() {
        boolean isAgent;
        boolean isPassword = this.authMethodCombo.getSelectionIndex() == 0;
        boolean isPublicKey = this.authMethodCombo.getSelectionIndex() == 1;
        boolean bl = isAgent = this.authMethodCombo.getSelectionIndex() == 2;
        if (isPublicKey) {
            this.showPrivateKeyField(true);
            this.showPasswordField(true, SSHUIMessages.model_ssh_configurator_label_passphrase);
            this.showSavePasswordCheckbox(true);
        } else if (isAgent) {
            this.showPrivateKeyField(false);
            this.showPasswordField(false, null);
            this.showSavePasswordCheckbox(false);
        } else if (isPassword) {
            this.showPrivateKeyField(false);
            this.showPasswordField(true, SSHUIMessages.model_ssh_configurator_label_password);
            this.showSavePasswordCheckbox(true);
        }
        UIUtils.asyncExec(() -> this.hostText.getParent().getParent().layout(true, true));
    }

    private void showSavePasswordCheckbox(boolean show) {
        ((GridData)this.savePasswordCheckbox.getLayoutData()).exclude = !show;
        this.savePasswordCheckbox.setVisible(show);
    }

    private void showPasswordField(boolean show, String pwdLabelText) {
        ((GridData)this.pwdLabel.getLayoutData()).exclude = !show;
        this.pwdLabel.setVisible(show);
        ((GridData)this.passwordText.getLayoutData()).exclude = !show;
        this.passwordText.setVisible(show);
        if (show) {
            this.pwdLabel.setText(pwdLabelText);
        }
    }

    private void showPrivateKeyField(boolean show) {
        ((GridData)this.privateKeyLabel.getLayoutData()).exclude = !show;
        this.privateKeyLabel.setVisible(show);
        ((GridData)this.privateKeyText.getLayoutData()).exclude = !show;
        this.privateKeyText.setVisible(show);
    }

    public boolean isComplete() {
        return false;
    }
}

