/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.internal;

import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.runtime.sql.SQLRuleProvider;
import org.jkiss.dbeaver.ui.UIUtils;

class OracleDialectRules
implements SQLRuleProvider {
    OracleDialectRules() {
    }

    public void extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull List<IRule> rules, @NotNull SQLRuleProvider.RulePosition position) {
        if (position == SQLRuleProvider.RulePosition.INITIAL || position == SQLRuleProvider.RulePosition.PARTITION) {
            rules.add((IRule)new QStringRule(position == SQLRuleProvider.RulePosition.PARTITION));
        }
    }

    private static class QStringRule
    implements IPredicateRule {
        private final IToken stringToken;
        private char quoteStartChar = (char)65535;

        public QStringRule(boolean isPartitionRule) {
            this.stringToken = isPartitionRule ? new Token((Object)"sql_character") : new Token((Object)new TextAttribute(UIUtils.getGlobalColor((String)"org.jkiss.dbeaver.sql.editor.color.string.foreground"), null, 0));
        }

        private IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
            int c;
            int n = c = resume ? 113 : scanner.read();
            if (c == 81 || c == 113) {
                int n2 = c = resume ? 39 : scanner.read();
                if (c == 39) {
                    boolean quoteCharRead = false;
                    if (resume && this.quoteStartChar != '\uffffffff') {
                        quoteCharRead = true;
                    }
                    if (!quoteCharRead) {
                        this.quoteStartChar = (char)scanner.read();
                    }
                    if (!Character.isLetterOrDigit(this.quoteStartChar)) {
                        boolean isQuote;
                        int charsRead;
                        block13: {
                            int quoteEndChar = QStringRule.getQuoteEndChar(this.quoteStartChar);
                            charsRead = 0;
                            isQuote = true;
                            while (true) {
                                c = scanner.read();
                                ++charsRead;
                                if (c == quoteEndChar) {
                                    c = scanner.read();
                                    ++charsRead;
                                    if (c != 39) continue;
                                    break block13;
                                }
                                if (c == -1) break;
                            }
                            isQuote = false;
                        }
                        if (isQuote) {
                            return this.stringToken;
                        }
                        int i = 0;
                        while (i < charsRead) {
                            scanner.unread();
                            ++i;
                        }
                    } else {
                        this.quoteStartChar = (char)65535;
                        if (quoteCharRead) {
                            scanner.unread();
                        }
                    }
                } else {
                    scanner.unread();
                }
            } else {
                scanner.unread();
            }
            return Token.UNDEFINED;
        }

        private static char getQuoteEndChar(char startChar) {
            switch (startChar) {
                case '<': {
                    return '>';
                }
                case '(': {
                    return ')';
                }
                case '[': {
                    return ']';
                }
                case '{': {
                    return '}';
                }
            }
            return startChar;
        }

        public IToken getSuccessToken() {
            return this.stringToken;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return this.doEvaluate(scanner, false);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.doEvaluate(scanner, resume);
        }
    }
}

