/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTablePartitionColumn;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTablePartitionColumnCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolTablePartitionColumnManager
extends SQLObjectEditor<ExasolTablePartitionColumn, ExasolTable>
implements DBEObjectEditor<ExasolTablePartitionColumn>,
DBEObjectMaker<ExasolTablePartitionColumn, ExasolTable> {
    private static final Log LOG = Log.getLog(ExasolTablePartitionColumnManager.class);

    public ExasolTablePartitionColumnCache getObjectsCache(ExasolTablePartitionColumn object) {
        return object.getTable().getPartitionCache();
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        ExasolTable table = ((ExasolTablePartitionColumn)command.getObject()).getTable();
        try {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(this.generateAction(table)));
        }
        catch (DBException e) {
            LOG.error((Object)"Failed to create Partition Action", (Throwable)e);
        }
    }

    protected ExasolTablePartitionColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new ExasolTablePartitionColumn((ExasolTable)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolTable table = ((ExasolTablePartitionColumn)command.getObject()).getTable();
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction(this.generateAction(table)));
        }
        catch (DBException e) {
            LOG.error((Object)"Failed to create Partition Action", (Throwable)e);
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolTablePartitionColumn col = (ExasolTablePartitionColumn)command.getObject();
        ExasolTablePartitionColumnCache cache = this.getObjectsCache(col);
        cache.removeObject((DBSObject)col, false);
        ExasolTable table = ((ExasolTablePartitionColumn)command.getObject()).getTable();
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction(this.generateAction(table)));
        }
        catch (DBException e) {
            LOG.error((Object)"Failed to create Partition Action", (Throwable)e);
        }
    }

    private String generateAction(ExasolTable table) throws DBException {
        if (table.getHasDistKey((DBRProgressMonitor)new VoidProgressMonitor()) & table.getPartitions().size() == 0) {
            return "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP PARTITION KEYS";
        }
        if (table.getPartitions().size() > 0) {
            if (!table.getHasPartitionKey((DBRProgressMonitor)new VoidProgressMonitor()).booleanValue()) {
                table.setHasPartitionKey(true, true);
            }
            return ExasolUtils.getPartitionDdl(table, (DBRProgressMonitor)new VoidProgressMonitor());
        }
        return null;
    }
}

