/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDPseudoReferrer;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.utils.CommonUtils;

public class ResultSetUtils {
    private static final Log log = Log.getLog(ResultSetUtils.class);
    private static final boolean BROWSE_LAZY_ASSOCIATIONS = false;
    private static volatile IDialogSettings viewerSettings;

    @NotNull
    public static IDialogSettings getViewerSettings(String section) {
        if (viewerSettings == null) {
            viewerSettings = UIUtils.getDialogSettings((String)ResultSetViewer.class.getSimpleName());
        }
        return UIUtils.getSettingsSection((IDialogSettings)viewerSettings, (String)section);
    }

    public static void bindAttributes(@NotNull DBCSession session, @Nullable DBSEntity sourceEntity, @Nullable DBCResultSet resultSet, @NotNull DBDAttributeBinding[] bindings, @Nullable List<Object[]> rows) throws DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        DBPDataSource dataSource = session.getDataSource();
        boolean readMetaData = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.read.metadata");
        if (!readMetaData && sourceEntity == null) {
            return;
        }
        boolean readReferences = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.read.references");
        IdentityHashMap<DBCEntityMetaData, DBSEntity> entityBindingMap = new IdentityHashMap<DBCEntityMetaData, DBSEntity>();
        monitor.beginTask("Discover resultset metadata", 3);
        try {
            DBSEntity attrEntity;
            DBDAttributeBinding binding;
            DBCStatement sourceStatement;
            SQLQuery sqlQuery = null;
            DBSEntity entity = null;
            if (sourceEntity != null) {
                entity = sourceEntity;
            } else if (resultSet != null && (sourceStatement = resultSet.getSourceStatement()) != null && sourceStatement.getStatementSource() != null) {
                DBCExecutionSource executionSource = sourceStatement.getStatementSource();
                monitor.subTask("Discover owner entity");
                DBSDataContainer dataContainer = executionSource.getDataContainer();
                if (dataContainer instanceof DBSEntity) {
                    entity = (DBSEntity)dataContainer;
                }
                DBCEntityMetaData entityMeta = null;
                if (entity == null) {
                    Object sourceDescriptor = executionSource.getSourceDescriptor();
                    if (sourceDescriptor instanceof SQLQuery) {
                        sqlQuery = (SQLQuery)sourceDescriptor;
                        entityMeta = sqlQuery.getSingleSource();
                    }
                    if (entityMeta != null && (entity = DBUtils.getEntityFromMetaData((DBRProgressMonitor)monitor, (DBCExecutionContext)session.getExecutionContext(), (DBCEntityMetaData)entityMeta)) != null) {
                        entityBindingMap.put(entityMeta, entity);
                    }
                }
            }
            IdentityHashMap<DBSEntity, DBDRowIdentifier> locatorMap = new IdentityHashMap<DBSEntity, DBDRowIdentifier>();
            monitor.subTask("Discover attributes");
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                binding = dBDAttributeBindingArray[n2];
                monitor.subTask("Discover attribute '" + binding.getName() + "'");
                DBCAttributeMetaData attrMeta = binding.getMetaAttribute();
                if (attrMeta != null) {
                    attrEntity = null;
                    DBCEntityMetaData attrEntityMeta = attrMeta.getEntityMetaData();
                    if (attrEntityMeta != null) {
                        attrEntity = (DBSEntity)entityBindingMap.get(attrEntityMeta);
                        if (attrEntity == null) {
                            attrEntity = entity != null && entity instanceof DBSTable && ((DBSTable)entity).isView() ? entity : DBUtils.getEntityFromMetaData((DBRProgressMonitor)monitor, (DBCExecutionContext)session.getExecutionContext(), (DBCEntityMetaData)attrEntityMeta);
                        }
                        if (attrEntity != null) {
                            entityBindingMap.put(attrEntityMeta, attrEntity);
                        }
                    }
                    if (attrEntity == null) {
                        attrEntity = entity;
                    }
                    if (attrEntity == null) {
                        if (attrEntityMeta != null) {
                            log.debug((Object)("Table '" + DBUtils.getSimpleQualifiedName((Object[])new Object[]{attrEntityMeta.getCatalogName(), attrEntityMeta.getSchemaName(), attrEntityMeta.getEntityName()}) + "' not found in metadata catalog"));
                        }
                    } else if (binding instanceof DBDAttributeBindingMeta) {
                        DBDAttributeBindingMeta bindingMeta = (DBDAttributeBindingMeta)binding;
                        DBDPseudoAttribute pseudoAttribute = DBUtils.getPseudoAttribute((DBSEntity)attrEntity, (String)attrMeta.getName());
                        if (pseudoAttribute != null) {
                            bindingMeta.setPseudoAttribute(pseudoAttribute);
                        }
                        DBSEntityAttribute tableColumn = bindingMeta.getPseudoAttribute() != null ? bindingMeta.getPseudoAttribute().createFakeAttribute(attrEntity, attrMeta) : attrEntity.getAttribute(monitor, attrMeta.getName());
                        if (sqlQuery != null && tableColumn != null && tableColumn.getTypeID() != attrMeta.getTypeID()) {
                            bindingMeta.setEntityAttribute(tableColumn, false);
                        } else if (tableColumn != null && bindingMeta.setEntityAttribute(tableColumn, true) && rows != null) {
                            try {
                                int pos = attrMeta.getOrdinalPosition();
                                for (Object[] row : rows) {
                                    row[pos] = binding.getValueHandler().getValueFromObject(session, (DBSTypedObject)tableColumn, row[pos], false);
                                }
                            }
                            catch (DBCException e) {
                                log.warn((Object)("Error resolving attribute '" + binding.getName() + "' values"), (Throwable)e);
                            }
                        }
                    }
                }
                ++n2;
            }
            monitor.worked(1);
            monitor.subTask("Detect unique identifiers");
            dBDAttributeBindingArray = bindings;
            n = bindings.length;
            n2 = 0;
            while (n2 < n) {
                DBSEntityAttribute attr;
                binding = dBDAttributeBindingArray[n2];
                if (binding instanceof DBDAttributeBindingMeta && (attr = binding.getEntityAttribute()) != null && (attrEntity = attr.getParentObject()) != null) {
                    DBSEntityConstraint entityIdentifier;
                    DBDRowIdentifier rowIdentifier = (DBDRowIdentifier)locatorMap.get(attrEntity);
                    if (rowIdentifier == null && (entityIdentifier = ResultSetUtils.getBestIdentifier(monitor, attrEntity, bindings, readMetaData)) != null) {
                        rowIdentifier = new DBDRowIdentifier(attrEntity, entityIdentifier);
                        locatorMap.put(attrEntity, rowIdentifier);
                    }
                    ((DBDAttributeBindingMeta)binding).setRowIdentifier(rowIdentifier);
                }
                ++n2;
            }
            monitor.worked(1);
            if (readMetaData && readReferences && rows != null) {
                monitor.subTask("Read results metadata");
                dBDAttributeBindingArray = bindings;
                n = bindings.length;
                n2 = 0;
                while (n2 < n) {
                    binding = dBDAttributeBindingArray[n2];
                    binding.lateBinding(session, rows);
                    ++n2;
                }
            }
            monitor.subTask("Complete metadata load");
            for (DBDRowIdentifier rowIdentifier : locatorMap.values()) {
                rowIdentifier.reloadAttributes(monitor, bindings);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static DBSEntityAssociation getAssociationByAttribute(DBDAttributeBinding attr) throws DBException {
        List referrers = attr.getReferrers();
        if (referrers != null) {
            for (DBSEntityReferrer referrer : referrers) {
                if (!(referrer instanceof DBSEntityAssociation)) continue;
                return (DBSEntityAssociation)referrer;
            }
        }
        throw new DBException("Association not found in attribute [" + attr.getName() + "]");
    }

    /*
     * WARNING - void declaration
     */
    private static DBSEntityConstraint getBestIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, DBDAttributeBinding[] bindings, boolean readMetaData) throws DBException {
        ArrayList<Object> identifiers = new ArrayList<Object>(2);
        ArrayList<DBSEntityConstraint> nonIdentifyingConstraints = null;
        if (!(!readMetaData || table instanceof DBSTable && ((DBSTable)table).isView())) {
            Collection constraints;
            block19: {
                if (table instanceof DBSTable) {
                    try {
                        Collection indexes = ((DBSTable)table).getIndexes(monitor);
                        if (CommonUtils.isEmpty((Collection)indexes)) break block19;
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!dBSTableIndex.isPrimary() || !DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!DBUtils.isIdentifierIndex((DBRProgressMonitor)monitor, (DBSTableIndex)dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
            }
            if ((constraints = table.getConstraints(monitor)) != null) {
                for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                    if (DBUtils.isIdentifierConstraint((DBRProgressMonitor)monitor, (DBSEntityConstraint)dBSEntityConstraint)) {
                        identifiers.add(dBSEntityConstraint);
                        continue;
                    }
                    if (nonIdentifyingConstraints == null) {
                        nonIdentifyingConstraints = new ArrayList<DBSEntityConstraint>();
                    }
                    nonIdentifyingConstraints.add(dBSEntityConstraint);
                }
            }
        }
        if (CommonUtils.isEmpty(identifiers)) {
            void var7_17;
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            boolean bl = false;
            while (var7_17 < n) {
                DBDPseudoAttribute pseudoAttribute;
                DBDAttributeBinding column = dBDAttributeBindingArray[var7_17];
                DBDPseudoAttribute dBDPseudoAttribute = pseudoAttribute = column instanceof DBDAttributeBindingMeta ? ((DBDAttributeBindingMeta)column).getPseudoAttribute() : null;
                if (pseudoAttribute != null && pseudoAttribute.getType() == DBDPseudoAttributeType.ROWID) {
                    identifiers.add(new DBDPseudoReferrer(table, column));
                    break;
                }
                ++var7_17;
            }
        }
        if (CommonUtils.isEmpty(identifiers) && nonIdentifyingConstraints != null) {
            identifiers.addAll(nonIdentifyingConstraints);
        }
        if (CommonUtils.isEmpty(identifiers)) {
            DBVEntity virtualEntity = DBVUtils.getVirtualEntity((DBSEntity)table, (boolean)true);
            identifiers.add(virtualEntity.getBestIdentifier());
        }
        if (!CommonUtils.isEmpty(identifiers)) {
            DBSEntityConstraint uniqueId = null;
            for (DBSEntityConstraint dBSEntityConstraint : identifiers) {
                if (dBSEntityConstraint instanceof DBSEntityReferrer) {
                    DBSEntityReferrer referrer = (DBSEntityReferrer)dBSEntityConstraint;
                    if (!ResultSetUtils.isGoodReferrer(monitor, bindings, referrer)) continue;
                    if (referrer.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                        return referrer;
                    }
                    if (uniqueId != null || !referrer.getConstraintType().isUnique() && (!(referrer instanceof DBSTableIndex) || !((DBSTableIndex)referrer).isUnique())) continue;
                    uniqueId = referrer;
                    continue;
                }
                uniqueId = dBSEntityConstraint;
            }
            return uniqueId;
        }
        return null;
    }

    private static boolean isGoodReferrer(DBRProgressMonitor monitor, DBDAttributeBinding[] bindings, DBSEntityReferrer referrer) throws DBException {
        if (referrer instanceof DBDPseudoReferrer) {
            return true;
        }
        List references = referrer.getAttributeReferences(monitor);
        if (references == null || references.isEmpty()) {
            return referrer instanceof DBVEntityConstraint;
        }
        for (DBSEntityAttributeRef ref : references) {
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
                if (binding.matches((DBSAttributeBase)ref.getAttribute(), false)) {
                    return true;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean equalAttributes(DBCAttributeMetaData attr1, DBCAttributeMetaData attr2) {
        return attr1 != null && attr2 != null && SQLUtils.compareAliases((String)attr1.getLabel(), (String)attr2.getLabel()) && SQLUtils.compareAliases((String)attr1.getName(), (String)attr2.getName()) && CommonUtils.equalObjects((Object)attr1.getEntityMetaData(), (Object)attr2.getEntityMetaData()) && attr1.getOrdinalPosition() == attr2.getOrdinalPosition() && attr1.isRequired() == attr2.isRequired() && attr1.getMaxLength() == attr2.getMaxLength() && CommonUtils.equalObjects((Object)attr1.getPrecision(), (Object)attr2.getPrecision()) && CommonUtils.equalObjects((Object)attr1.getScale(), (Object)attr2.getScale()) && attr1.getTypeID() == attr2.getTypeID() && CommonUtils.equalObjects((Object)attr1.getTypeName(), (Object)attr2.getTypeName());
    }

    @Nullable
    public static Object getAttributeValueFromClipboard(DBDAttributeBinding attribute) throws DBCException {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            Object object;
            block13: {
                Throwable throwable = null;
                Object var3_4 = null;
                DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)attribute, (String)"Copy from clipboard");
                try {
                    String strValue = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    object = attribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute.getAttribute(), (Object)strValue, true);
                    if (session == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                session.close();
            }
            return object;
        }
        finally {
            clipboard.dispose();
        }
    }

    public static void copyToClipboard(String string) {
        if (string != null && string.length() > 0) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{string}, new Transfer[]{textTransfer});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    public static boolean isServerSideFiltering(IResultSetController controller) {
        return controller.getPreferenceStore().getBoolean("resultset.order.serverSide") && (controller.isHasMoreData() || !CommonUtils.isEmpty((String)controller.getModel().getDataFilter().getOrder()));
    }

    public static double makeNumericValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static RGB makeGradientValue(RGB c1, RGB c2, double minValue, double maxValue, double value) {
        if (value <= minValue) {
            return c1;
        }
        if (value >= maxValue) {
            return c2;
        }
        double range = maxValue - minValue;
        double p = (value - minValue) / range;
        return new RGB((int)((double)c2.red * p + (double)c1.red * (1.0 - p)), (int)((double)c2.green * p + (double)c1.green * (1.0 - p)), (int)((double)c2.blue * p + (double)c1.blue * (1.0 - p)));
    }

    public static DBSEntityReferrer getEnumerableConstraint(DBDAttributeBinding binding) {
        try {
            DBSDictionary dictionary;
            List refs;
            DBSEntityReferrer constraint;
            DBSEntity associatedEntity;
            DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
            if (entityAttribute != null && (associatedEntity = ResultSetUtils.getAssociatedEntity((DBSEntityConstraint)(constraint = (refs = DBUtils.getAttributeReferrers((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAttribute)entityAttribute, (boolean)true)).isEmpty() ? null : (DBSEntityReferrer)refs.get(0)))) instanceof DBSDictionary && (dictionary = (DBSDictionary)associatedEntity).supportsDictionaryEnumeration()) {
                return constraint;
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return null;
    }

    public static DBSEntity getAssociatedEntity(DBSEntityConstraint constraint) {
        DBSEntity[] associatedEntity = new DBSEntity[1];
        if (constraint instanceof DBSEntityAssociation) {
            associatedEntity[0] = ((DBSEntityAssociation)constraint).getAssociatedEntity();
        }
        return associatedEntity[0];
    }
}

