/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelDescriptor;

public class ResultSetPresentationRegistry {
    private static final String TAG_PRESENTATION = "presentation";
    private static final String TAG_PANEL = "panel";
    private static final String TAG_OPEN_WITH = "openWith";
    private static ResultSetPresentationRegistry instance;
    private List<ResultSetPresentationDescriptor> presentations = new ArrayList<ResultSetPresentationDescriptor>();
    private List<ResultSetPanelDescriptor> panels = new ArrayList<ResultSetPanelDescriptor>();

    public static synchronized ResultSetPresentationRegistry getInstance() {
        if (instance == null) {
            instance = new ResultSetPresentationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ResultSetPresentationRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] panelElements;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resultset.presentation");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_PRESENTATION.equals(ext.getName())) {
                ResultSetPresentationDescriptor descriptor = new ResultSetPresentationDescriptor(ext);
                this.presentations.add(descriptor);
            }
            ++n2;
        }
        this.presentations.sort(Comparator.comparingInt(ResultSetPresentationDescriptor::getOrder));
        IConfigurationElement[] iConfigurationElementArray2 = panelElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resultset.panel");
        int n3 = panelElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement ext = iConfigurationElementArray2[n];
            if (TAG_PANEL.equals(ext.getName())) {
                ResultSetPanelDescriptor descriptor = new ResultSetPanelDescriptor(ext);
                this.panels.add(descriptor);
            }
            ++n;
        }
    }

    public ResultSetPresentationDescriptor getPresentation(String id) {
        for (ResultSetPresentationDescriptor descriptor : this.presentations) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public ResultSetPresentationDescriptor getPresentation(Class<? extends IResultSetPresentation> implType) {
        for (ResultSetPresentationDescriptor descriptor : this.presentations) {
            if (!descriptor.matches(implType)) continue;
            return descriptor;
        }
        return null;
    }

    public List<ResultSetPresentationDescriptor> getAllPresentations() {
        return this.presentations;
    }

    public List<ResultSetPresentationDescriptor> getAvailablePresentations(DBCResultSet resultSet, IResultSetContext context) {
        ArrayList<ResultSetPresentationDescriptor> result = new ArrayList<ResultSetPresentationDescriptor>();
        for (ResultSetPresentationDescriptor descriptor : this.presentations) {
            if (!descriptor.supportedBy(resultSet, context)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public List<ResultSetPanelDescriptor> getAllPanels() {
        return this.panels;
    }

    public ResultSetPanelDescriptor getPanel(String panelId) {
        for (ResultSetPanelDescriptor panel : this.panels) {
            if (!panel.getId().equals(panelId)) continue;
            return panel;
        }
        return null;
    }

    public List<ResultSetPanelDescriptor> getSupportedPanels(DBPDataSource dataSource, String presentationId, IResultSetPresentation.PresentationType presentationType) {
        ArrayList<ResultSetPanelDescriptor> result = new ArrayList<ResultSetPanelDescriptor>();
        for (ResultSetPanelDescriptor panel : this.panels) {
            if (!panel.supportedBy(dataSource, presentationId, presentationType)) continue;
            result.add(panel);
        }
        result.sort(Comparator.comparing(ResultSetPanelDescriptor::getLabel));
        return result;
    }
}

