/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<PostgreDatabase, PostgreSchema> {
    private static final Log log = Log.getLog(PostgreExecutionContext.class);
    private PostgreSchema activeSchema;
    private final List<String> searchPath = new ArrayList<String>();
    private List<String> defaultSearchPath = new ArrayList<String>();
    private String activeUser;

    public PostgreExecutionContext(@NotNull PostgreDatabase database, String purpose) {
        super((JDBCRemoteInstance)database, purpose);
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public PostgreDatabase getDefaultCatalog() {
        return (PostgreDatabase)this.getOwnerInstance();
    }

    public PostgreSchema getDefaultSchema() {
        return this.activeSchema;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    void setDefaultsFrom(@NotNull PostgreExecutionContext initFrom) {
        this.activeUser = initFrom.activeUser;
        this.searchPath.clear();
        this.defaultSearchPath = new ArrayList<String>(initFrom.defaultSearchPath);
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, PostgreDatabase catalog, PostgreSchema schema) throws DBCException {
        PostgreDataSource dataSource = this.getDefaultCatalog().getDataSource();
        PostgreDatabase defaultInstance = dataSource.getDefaultInstance();
        try {
            if (defaultInstance.getDefaultContext() == this) {
                dataSource.setDefaultInstance(monitor, catalog, schema);
            } else {
                this.disconnect();
                this.setOwnerInstance(catalog);
                this.connect(monitor, null, null, null, false);
                if (schema != null) {
                    this.setDefaultSchema(monitor, schema);
                }
            }
        }
        catch (DBException e) {
            throw new DBCException("Error changing default database", (Throwable)e);
        }
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, PostgreSchema schema) throws DBCException {
        this.setDefaultSchema(monitor, schema, true);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, PostgreSchema schema, boolean reflect) throws DBCException {
        PostgreSchema oldActiveSchema = this.activeSchema;
        if (oldActiveSchema == schema) {
            return;
        }
        this.setSearchPath(monitor, schema);
        this.activeSchema = schema;
        this.setSearchPath(schema.getName());
        if (reflect) {
            DBUtils.fireObjectSelectionChange((DBSObject)oldActiveSchema, (DBSObject)this.activeSchema);
        }
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Get context active schema");){
                String[] stringArray;
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement stat = session.prepareStatement("SELECT current_schema(),session_user");){
                    Throwable throwable3 = null;
                    stringArray = null;
                    try (JDBCResultSet rs = stat.executeQuery();){
                        if (rs.nextRow()) {
                            String activeSchemaName = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                            if (!CommonUtils.isEmpty((String)activeSchemaName)) {
                                this.activeSchema = this.getDefaultCatalog().getSchema(monitor, activeSchemaName);
                            }
                            this.activeUser = JDBCUtils.safeGetString((ResultSet)rs, (int)2);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                String searchPathStr = JDBCUtils.queryString((JDBCSession)session, (String)"SHOW search_path", (Object[])new Object[0]);
                this.searchPath.clear();
                if (searchPathStr != null) {
                    stringArray = searchPathStr.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        str = str.trim();
                        this.searchPath.add(DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)str));
                        ++n2;
                    }
                } else {
                    this.searchPath.add("public");
                }
                this.defaultSearchPath = new ArrayList<String>(this.searchPath);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.getDataSource());
        }
        return true;
    }

    public String getActiveUser() {
        return this.activeUser;
    }

    public List<String> getSearchPath() {
        return this.searchPath;
    }

    List<String> getDefaultSearchPath() {
        return this.defaultSearchPath;
    }

    private void setSearchPath(DBRProgressMonitor monitor, PostgreSchema schema) throws DBCException {
        String defSchemaName;
        ArrayList<String> newSearchPath = new ArrayList<String>(this.getDefaultSearchPath());
        int schemaIndex = newSearchPath.indexOf(defSchemaName = schema.getName());
        if (schemaIndex != 0) {
            if (schemaIndex > 0) {
                newSearchPath.remove(schemaIndex);
            }
            newSearchPath.add(0, defSchemaName);
        }
        StringBuilder spString = new StringBuilder();
        for (String sp : newSearchPath) {
            if (spString.length() > 0) {
                spString.append(",");
            }
            spString.append(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)sp));
        }
        try {
            Throwable sp = null;
            Iterator iterator = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Change search path");){
                JDBCUtils.executeSQL((Connection)session, (String)("SET search_path = " + spString), (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                if (sp == null) {
                    sp = throwable;
                } else if (sp != throwable) {
                    sp.addSuppressed(throwable);
                }
                throw sp;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error setting search path", (Throwable)e, this.dataSource);
        }
    }

    private void setSearchPath(String path) {
        this.searchPath.clear();
        this.searchPath.add(path);
        if (!path.equals(this.activeUser)) {
            this.searchPath.add(this.activeUser);
        }
    }
}

