/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class MySQLStructureAssistant
extends JDBCStructureAssistant {
    private final MySQLDataSource dataSource;

    public MySQLStructureAssistant(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    protected void findObjectsByMask(JDBCSession session, DBSObjectType objectType, DBSObject parentObject, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults, List<DBSObjectReference> references) throws DBException, SQLException {
        MySQLCatalog catalog;
        MySQLCatalog mySQLCatalog = catalog = parentObject instanceof MySQLCatalog ? (MySQLCatalog)parentObject : null;
        if (catalog == null && !globalSearch) {
            catalog = this.dataSource.getDefaultDatabase();
        }
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, catalog, objectNameMask, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            this.findConstraintsByMask(session, catalog, objectNameMask, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, catalog, objectNameMask, maxResults, references);
        } else if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, catalog, objectNameMask, maxResults, references);
        }
    }

    private void findTablesByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, String tableNameMask, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABLE_SCHEMA,TABLE_NAME FROM information_schema.TABLES WHERE TABLE_NAME LIKE ? " + (catalog == null ? "" : " AND TABLE_SCHEMA=?") + " ORDER BY " + "TABLE_NAME" + " LIMIT " + maxResults);){
            dbStat.setString(1, tableNameMask.toLowerCase(Locale.ENGLISH));
            if (catalog != null) {
                dbStat.setString(2, catalog.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference(tableName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLTableBase.class, RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Table catalog '" + catalogName + "' not found");
                            }
                            MySQLTableBase table = (MySQLTableBase)tableCatalog.getTableCache().getObject(monitor, (DBSObject)tableCatalog, tableName);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in catalog '" + catalogName + "'");
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, String procNameMask, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT ROUTINE_SCHEMA,ROUTINE_NAME FROM information_schema.ROUTINES WHERE ROUTINE_NAME LIKE ? " + (catalog == null ? "" : " AND ROUTINE_SCHEMA=?") + " ORDER BY " + "ROUTINE_NAME" + " LIMIT " + maxResults);){
            dbStat.setString(1, procNameMask.toLowerCase(Locale.ENGLISH));
            if (catalog != null) {
                dbStat.setString(2, catalog.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_SCHEMA");
                    final String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference(procName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog procCatalog;
                            MySQLCatalog mySQLCatalog = procCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (procCatalog == null) {
                                throw new DBException("Procedure catalog '" + catalogName + "' not found");
                            }
                            MySQLProcedure procedure = procCatalog.getProcedure(monitor, procName);
                            if (procedure == null) {
                                throw new DBException("Procedure '" + procName + "' not found in catalog '" + procCatalog.getName() + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, String constrNameMask, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABLE_SCHEMA,TABLE_NAME,CONSTRAINT_NAME,CONSTRAINT_TYPE FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_NAME LIKE ? " + (catalog == null ? "" : " AND TABLE_SCHEMA=?") + " ORDER BY " + "CONSTRAINT_NAME" + " LIMIT " + maxResults);){
            dbStat.setString(1, constrNameMask.toLowerCase(Locale.ENGLISH));
            if (catalog != null) {
                dbStat.setString(2, catalog.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    String constrType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
                    final boolean isFK = "FOREIGN KEY".equals(constrType);
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, (DBSObject)this.dataSource.getCatalog(catalogName), null, isFK ? MySQLTableForeignKey.class : MySQLTableConstraint.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Constraint catalog '" + catalogName + "' not found");
                            }
                            MySQLTable table = tableCatalog.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Constraint table '" + tableName + "' not found in catalog '" + tableCatalog.getName() + "'");
                            }
                            Object constraint = isFK ? table.getAssociation(monitor, constrName) : table.getConstraint(monitor, constrName);
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, String constrNameMask, int maxResults, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME FROM information_schema.COLUMNS WHERE COLUMN_NAME LIKE ? " + (catalog == null ? "" : " AND TABLE_SCHEMA=?") + " ORDER BY " + "COLUMN_NAME" + " LIMIT " + maxResults);){
            dbStat.setString(1, constrNameMask.toLowerCase(Locale.ENGLISH));
            if (catalog != null) {
                dbStat.setString(2, catalog.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int tableNum = maxResults;
                while (dbResult.next() && tableNum-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference(columnName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        @NotNull
                        public String getFullyQualifiedName(DBPEvaluationContext context) {
                            return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)catalogName)) + '.' + DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)tableName) + '.' + DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)columnName);
                        }

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Column catalog '" + catalogName + "' not found");
                            }
                            MySQLTableBase table = (MySQLTableBase)tableCatalog.getTableCache().getObject(monitor, (DBSObject)tableCatalog, tableName);
                            if (table == null) {
                                throw new DBException("Column table '" + tableName + "' not found in catalog '" + tableCatalog.getName() + "'");
                            }
                            MySQLTableColumn column = table.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

