/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEvent;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class MySQLEventManager
extends SQLObjectEditor<MySQLEvent, MySQLCatalog> {
    public DBSObjectCache<MySQLCatalog, MySQLEvent> getObjectsCache(MySQLEvent object) {
        return object.getCatalog().getEventCache();
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    protected MySQLEvent createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new MySQLEvent((MySQLCatalog)container, "NewEvent");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        MySQLEvent event = (MySQLEvent)command.getObject();
        StringBuilder script = new StringBuilder();
        try {
            script.append(event.getObjectDefinitionText(monitor, options));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        this.makeEventActions(actions, event, false, script.toString());
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        MySQLEvent event = (MySQLEvent)command.getObject();
        StringBuilder script = new StringBuilder();
        options = new LinkedHashMap<String, Object>(options);
        options.put("object.alter", true);
        try {
            script.append(event.getObjectDefinitionText(monitor, options));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        String ddlText = script.toString();
        if (ddlText.startsWith("CREATE ") || ddlText.startsWith("create ")) {
            ddlText = "ALTER " + ddlText.substring(7);
        }
        this.makeEventActions(actionList, event, true, ddlText);
    }

    private void makeEventActions(List<DBEPersistAction> actionList, MySQLEvent event, boolean alter, String ddlText) {
        MySQLCatalog curCatalog = event.getCatalog().getDataSource().getDefaultDatabase();
        if (curCatalog != event.getCatalog()) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)event.getCatalog()), false));
        }
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alter ? "Alter event" : "Create event", ddlText));
        if (curCatalog != null && curCatalog != event.getCatalog()) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)curCatalog), false));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop event", "DROP EVENT " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }
}

