/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.finder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedListItem;
import org.jkiss.dbeaver.ui.css.CSSUtils;

public class AdvancedList
extends ScrolledComposite {
    private static final Log log = Log.getLog(AdvancedList.class);
    public static final int ITEM_SPACING = 5;
    private Point itemSize = new Point(64, 64);
    private Canvas container;
    private List<AdvancedListItem> items = new ArrayList<AdvancedListItem>();
    private AdvancedListItem selectedItem;
    private Color backgroundColor;
    private Color selectionBackgroundColor;
    private Color foregroundColor;
    private Color selectionForegroundColor;
    private Color hoverBackgroundColor;
    private final Point textSize;

    public AdvancedList(Composite parent, int style) {
        super(parent, 0x200 | style);
        CSSUtils.setCSSClass((Widget)this, "List");
        this.backgroundColor = UIStyles.getDefaultTextBackground();
        this.foregroundColor = UIStyles.getDefaultTextForeground();
        this.selectionBackgroundColor = UIStyles.getDefaultTextSelectionBackground();
        this.selectionForegroundColor = UIStyles.getDefaultTextSelectionForeground();
        this.hoverBackgroundColor = UIUtils.getSharedTextColors().getColor(UIUtils.blend(this.selectionBackgroundColor.getRGB(), new RGB(255, 255, 255), 70));
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(1808));
        }
        this.container = new Canvas((Composite)this, 0);
        this.setContent((Control)this.container);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setMinSize(10, 10);
        this.addListener(11, event -> this.updateSize(false));
        this.setBackground(this.backgroundColor);
        this.container.setBackground(this.getBackground());
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.fill = true;
        layout.marginHeight = 0;
        layout.spacing = 5;
        this.container.setLayout((Layout)layout);
        GC gc = new GC((Drawable)this.getDisplay());
        this.textSize = gc.stringExtent("X");
        gc.dispose();
        this.container.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
            }
        });
    }

    void navigateByKey(KeyEvent e) {
        if (this.selectedItem == null) {
            return;
        }
        int itemIndex = this.items.indexOf((Object)this.selectedItem);
        int itemsPerRow = this.getItemsPerRow();
        switch (e.keyCode) {
            case 0x1000003: {
                if (itemIndex <= 0) break;
                this.setSelection(this.items.get(itemIndex - 1));
                break;
            }
            case 0x1000004: {
                if (itemIndex >= this.items.size() - 1) break;
                this.setSelection(this.items.get(itemIndex + 1));
                break;
            }
            case 0x1000001: {
                if (itemIndex < itemsPerRow) break;
                this.setSelection(this.items.get(itemIndex - itemsPerRow));
                break;
            }
            case 0x1000002: {
                if (itemIndex >= this.items.size() - 1) break;
                int nextIndex = itemIndex + itemsPerRow;
                if (nextIndex >= this.items.size() - 1) {
                    nextIndex = this.items.size() - 1;
                }
                this.setSelection(this.items.get(nextIndex));
                break;
            }
            case 13: {
                this.notifyDefaultSelection();
            }
        }
        this.showItem(this.selectedItem);
    }

    private int getItemsPerRow() {
        Point itemSize = this.selectedItem.getSize();
        Point containerSize = this.container.getSize();
        return Math.floorDiv(containerSize.x, itemSize.x);
    }

    public void updateSize(boolean layout) {
        this.setMinHeight(10);
        int width = this.getClientArea().width;
        this.setMinHeight(this.getParent().computeSize((int)width, (int)-1).y);
        if (layout) {
            this.layout(true, true);
        }
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    Color getForegroundColor() {
        return this.foregroundColor;
    }

    Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    Color getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    Point getTextSize() {
        return this.textSize;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, false);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint == -1 && hHint == -1) {
            return new Point(100, 100);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public Canvas getContainer() {
        return this.container;
    }

    public Point getImageSize() {
        return this.itemSize;
    }

    public void setItemSize(Point itemSize) {
        this.itemSize = itemSize;
    }

    void addItem(AdvancedListItem item) {
        this.items.add(item);
    }

    void removeItem(AdvancedListItem item) {
        this.items.remove((Object)item);
    }

    public AdvancedListItem[] getItems() {
        return this.items.toArray(new AdvancedListItem[0]);
    }

    public AdvancedListItem getSelectedItem() {
        return this.selectedItem;
    }

    void setSelection(AdvancedListItem item) {
        if (this.selectedItem == item) {
            return;
        }
        AdvancedListItem oldSelection = this.selectedItem;
        this.selectedItem = item;
        if (oldSelection != null) {
            oldSelection.redraw();
        }
        if (item != null) {
            item.redraw();
        }
        Event event = new Event();
        event.widget = item;
        this.notifyListeners(13, event);
    }

    void notifyDefaultSelection() {
        Event event = new Event();
        event.widget = this.selectedItem;
        this.notifyListeners(14, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeAll() {
        this.checkWidget();
        this.setSelection(null);
        AdvancedListItem[] advancedListItemArray = this.items.toArray(new AdvancedListItem[0]);
        int n = advancedListItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            AdvancedListItem item = advancedListItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.items.clear();
        this.setMinSize(10, 10);
    }

    private void showItem(AdvancedListItem item) {
        this.showControl((Control)item);
    }
}

