/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLScriptPosition;
import org.jkiss.utils.CommonUtils;

public class SQLReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    protected static final Log log = Log.getLog(SQLReconcilingStrategy.class);
    private SQLEditorBase editor;
    private IDocument document;
    private int regionOffset;
    private int regionLength;
    private List<SQLScriptPosition> parsedPositions = new ArrayList<SQLScriptPosition>();

    public SQLEditorBase getEditor() {
        return this.editor;
    }

    public void setEditor(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.calculatePositions((IRegion)dirtyRegion);
    }

    public void reconcile(IRegion partition) {
        this.calculatePositions(partition);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.calculatePositions(null);
    }

    protected void calculatePositions(IRegion partition) {
        List<SQLScriptElement> queries;
        if (!this.editor.isFoldingEnabled()) {
            return;
        }
        ArrayList<ProjectionAnnotation> removedAnnotations = null;
        HashMap<ProjectionAnnotation, SQLScriptPosition> addedAnnotations = null;
        if (partition == null) {
            this.regionOffset = 0;
            this.regionLength = this.document.getLength();
        } else {
            this.regionOffset = partition.getOffset();
            this.regionLength = partition.getLength();
            int i = 0;
            while (i < this.parsedPositions.size()) {
                SQLScriptPosition sp = this.parsedPositions.get(i);
                if (sp.getOffset() <= this.regionOffset + this.regionLength && sp.getOffset() + sp.getLength() >= this.regionOffset + this.regionLength) {
                    SQLScriptPosition startPos = i > 0 ? this.parsedPositions.get(i - 1) : sp;
                    SQLScriptPosition endPos = i < this.parsedPositions.size() - 1 ? this.parsedPositions.get(i + 1) : sp;
                    this.regionOffset = i == 0 ? 0 : startPos.getOffset();
                    this.regionLength = endPos.getOffset() + endPos.getLength() + this.regionLength;
                    break;
                }
                ++i;
            }
        }
        ProjectionAnnotationModel annotationModel = this.editor.getAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        try {
            queries = this.editor.extractScriptQueries(this.regionOffset, this.document.getLength() - this.regionOffset, false, true, false);
        }
        catch (Exception e) {
            log.error((Object)"Error parsing script queries", (Throwable)e);
            return;
        }
        ArrayList<SQLScriptPosition> removedPositions = new ArrayList<SQLScriptPosition>();
        for (SQLScriptPosition sp : this.parsedPositions) {
            if (sp.getOffset() < this.regionOffset) continue;
            removedPositions.add(sp);
        }
        if (!removedPositions.isEmpty()) {
            this.parsedPositions.removeAll(removedPositions);
            removedAnnotations = new ArrayList<ProjectionAnnotation>();
            for (SQLScriptPosition removedPosition : removedPositions) {
                if (!removedPosition.isMultiline()) continue;
                removedAnnotations.add(removedPosition.getFoldingAnnotation());
            }
        }
        try {
            ArrayList<SQLScriptPosition> addedPositions = new ArrayList<SQLScriptPosition>();
            int documentLength = this.document.getLength();
            for (SQLScriptElement se : queries) {
                int queryOffset = se.getOffset();
                int queryLength = se.getLength();
                boolean isMultiline = this.document.getLineOfOffset(queryOffset) != this.document.getLineOfOffset(queryOffset + queryLength);
                int i = queryOffset + queryLength;
                while (i < documentLength) {
                    char ch = this.document.getChar(i);
                    if (Character.isWhitespace(ch)) {
                        ++queryLength;
                    }
                    if (ch == '\n') break;
                    ++i;
                }
                addedPositions.add(new SQLScriptPosition(queryOffset, queryLength, isMultiline, new ProjectionAnnotation()));
            }
            if (!addedPositions.isEmpty()) {
                int firstQueryPos = ((SQLScriptPosition)addedPositions.get(0)).getOffset();
                int posBeforeFirst = 0;
                int i = 0;
                while (i < this.parsedPositions.size()) {
                    SQLScriptPosition sp = this.parsedPositions.get(i);
                    if (sp.getOffset() >= firstQueryPos) break;
                    posBeforeFirst = i++;
                }
                this.parsedPositions.addAll(posBeforeFirst, addedPositions);
                addedAnnotations = new HashMap<ProjectionAnnotation, SQLScriptPosition>();
                for (SQLScriptPosition pos : addedPositions) {
                    if (!pos.isMultiline()) continue;
                    addedAnnotations.put(pos.getFoldingAnnotation(), pos);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (removedAnnotations != null || !CommonUtils.isEmpty(addedAnnotations)) {
            annotationModel.modifyAnnotations(removedAnnotations == null ? null : removedAnnotations.toArray(new Annotation[removedAnnotations.size()]), addedAnnotations, null);
        }
    }
}

