/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.editors.entity.EntityHyperlink;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;

public class SQLHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected static final Log log = Log.getLog(SQLHyperlinkDetector.class);
    private SQLContextInformer contextInformer;

    public SQLHyperlinkDetector(SQLEditorBase editor, SQLSyntaxManager syntaxManager) {
        this.contextInformer = new SQLContextInformer(editor, syntaxManager);
    }

    @Nullable
    public synchronized IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        this.contextInformer.searchInformation(region);
        if (!this.contextInformer.hasObjects()) {
            return null;
        }
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        Region hlRegion = new Region(wordRegion.identStart, wordRegion.identEnd - wordRegion.identStart);
        List<DBSObjectReference> references = this.contextInformer.getObjectReferences();
        IHyperlink[] links = new IHyperlink[references.size()];
        int i = 0;
        int objectsSize = references.size();
        while (i < objectsSize) {
            links[i] = new EntityHyperlink((IWorkbenchSite)this.contextInformer.getEditor().getSite(), references.get(i), (IRegion)hlRegion);
            ++i;
        }
        return links;
    }

    public String getLastKeyword() {
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        if (wordRegion != null) {
            Region hlRegion = new Region(wordRegion.identStart, wordRegion.identEnd - wordRegion.identStart);
            try {
                return this.contextInformer.getEditor().getDocument().get(hlRegion.getOffset(), hlRegion.getLength());
            }
            catch (BadLocationException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

