/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreScriptExecuteWizard;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.ToolWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class PostgreToolScript
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        for (DBSObject object : objects) {
            if (!(object instanceof PostgreDatabase)) continue;
            ToolWizardDialog dialog = new ToolWizardDialog(window, (TaskConfigurationWizard)new PostgreScriptExecuteWizard((PostgreDatabase)object, false));
            dialog.open();
        }
    }

    public static <SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG> List<String> getPostgreToolCommandLine(AbstractToolWizard<SETTINGS, BASE_OBJECT, PROCESS_ARG> toolWizard, PROCESS_ARG arg) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        toolWizard.fillProcessParameters(cmd, arg);
        if (toolWizard.isVerbose()) {
            cmd.add("--verbose");
        }
        DBPConnectionConfiguration connectionInfo = toolWizard.getConnectionInfo();
        cmd.add("--host=" + connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            cmd.add("--port=" + connectionInfo.getHostPort());
        }
        cmd.add("--username=" + toolWizard.getToolUserName());
        return cmd;
    }
}

