/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreDatabaseRestoreInfo;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreRestoreWizardPageSettings;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.ui.UIUtils;

class PostgreRestoreWizard
extends PostgreBackupRestoreWizard<PostgreRestoreSettings, PostgreDatabaseRestoreInfo>
implements IExportWizard {
    private PostgreRestoreWizardPageSettings settingsPage;
    private PostgreDatabaseRestoreInfo restoreInfo;

    PostgreRestoreWizard(PostgreDatabase database) {
        super(Collections.singletonList(database), PostgreMessages.wizard_restore_title);
        this.restoreInfo = new PostgreDatabaseRestoreInfo(database);
    }

    public String getTaskTypeId() {
        return "postgresDatabaseRestore";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, Map<String, Object> state) {
    }

    public boolean isExportWizard() {
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.settingsPage = new PostgreRestoreWizardPageSettings(this);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)"Database restore", (String)("Restore '" + this.getObjectsName() + "'"), (int)2);
    }

    @Override
    public void fillProcessParameters(List<String> cmd, PostgreDatabaseRestoreInfo arg) throws IOException {
        super.fillProcessParameters(cmd, arg);
        if (((PostgreRestoreSettings)this.getSettings()).isCleanFirst()) {
            cmd.add("-c");
        }
    }

    @Override
    protected List<String> getCommandLine(PostgreDatabaseRestoreInfo arg) throws IOException {
        List<String> cmd = super.getCommandLine(arg);
        if (this.format != PostgreBackupRestoreWizard.ExportFormat.PLAIN) {
            cmd.add("--format=" + this.format.getId());
        }
        cmd.add("--dbname=" + arg.getDatabase().getName());
        if (this.format == PostgreBackupRestoreWizard.ExportFormat.DIRECTORY) {
            cmd.add(((PostgreRestoreSettings)this.getSettings()).getInputFile());
        }
        return cmd;
    }

    protected PostgreRestoreSettings createSettings() {
        return new PostgreRestoreSettings();
    }

    public Collection<PostgreDatabaseRestoreInfo> getRunInfo() {
        return Collections.singleton(this.restoreInfo);
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, PostgreDatabaseRestoreInfo arg, ProcessBuilder processBuilder, Process process) {
        super.startProcessHandler(monitor, (Object)arg, processBuilder, process);
        if (this.format != PostgreBackupRestoreWizard.ExportFormat.DIRECTORY) {
            new AbstractToolWizard.BinaryFileTransformerJob((AbstractToolWizard)this, monitor, new File(((PostgreRestoreSettings)this.getSettings()).getInputFile()), process.getOutputStream()).start();
        }
    }
}

