/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.ui.IExportWizard;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.PostgreServerHome;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreDatabaseBackupRestoreInfo;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolScript;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractImportExportWizard;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

abstract class PostgreBackupRestoreWizard<SETTINGS extends AbstractImportExportSettings<DBSObject>, PROCESS_ARG extends PostgreDatabaseBackupRestoreInfo>
extends AbstractImportExportWizard<SETTINGS, PROCESS_ARG>
implements IExportWizard {
    ExportFormat format = ExportFormat.CUSTOM;

    public PostgreBackupRestoreWizard(Collection<DBSObject> objects, String title) {
        super(objects, title);
    }

    public void fillProcessParameters(List<String> cmd, PROCESS_ARG arg) throws IOException {
        File dumpBinary = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)this.getClientHome(), (String)"bin", (String)(this.isExportWizard() ? "pg_dump" : "pg_restore"));
        String dumpPath = dumpBinary.getAbsolutePath();
        cmd.add(dumpPath);
        ((AbstractImportExportSettings)this.getSettings()).addExtraCommandArgs(cmd);
    }

    protected void setupProcessParameters(ProcessBuilder process) {
        if (!CommonUtils.isEmpty((String)this.getToolUserPassword())) {
            process.environment().put("PGPASSWORD", this.getToolUserPassword());
        }
    }

    public PostgreServerHome findNativeClientHome(String clientHomeId) {
        return PostgreDataSourceProvider.getServerHome((String)clientHomeId);
    }

    protected List<String> getCommandLine(PROCESS_ARG arg) throws IOException {
        return PostgreToolScript.getPostgreToolCommandLine(this, arg);
    }

    public boolean isVerbose() {
        return true;
    }

    public static enum ExportFormat {
        PLAIN("p", "Plain"),
        CUSTOM("c", "Custom"),
        DIRECTORY("d", "Directory"),
        TAR("t", "Tar");

        private final String id;
        private String title;

        private ExportFormat(String id, String title) {
            this.id = id;
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

