/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class PostgreToolTruncate
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, PostgreTableBase.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        private Button onlyCheck;
        private Button restartIdentityCheck;
        private Button cascadeCheck;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<PostgreTableBase> selectedTables) {
            super(partSite, PostgreMessages.tool_truncate_title_table, selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, PostgreObject object) {
            if (object instanceof PostgreTableBase) {
                String sql = "TRUNCATE TABLE";
                if (this.onlyCheck.getSelection()) {
                    sql = String.valueOf(sql) + " ONLY";
                }
                sql = String.valueOf(sql) + " " + ((PostgreTableBase)object).getFullyQualifiedName(DBPEvaluationContext.DDL);
                sql = this.restartIdentityCheck.getSelection() ? String.valueOf(sql) + " RESTART IDENTITY" : String.valueOf(sql) + " CONTINUE IDENTITY";
                sql = this.cascadeCheck.getSelection() ? String.valueOf(sql) + " CASCADE" : String.valueOf(sql) + " RESTRICT";
                lines.add(sql);
            }
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)PostgreMessages.tool_truncate_group_option, (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.createTransactionCheck(optionsGroup);
            this.onlyCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)PostgreMessages.tool_truncate_checkbox_only, (String)PostgreMessages.tool_truncate_checkbox_only_tooltip, (boolean)false, (int)0);
            this.onlyCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.restartIdentityCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)PostgreMessages.tool_truncate_checkbox_restart, (String)PostgreMessages.tool_truncate_checkbox_restart_tooltip, (boolean)false, (int)0);
            this.restartIdentityCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.cascadeCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)PostgreMessages.tool_truncate_checkbox_cascade, (String)PostgreMessages.tool_truncate_checkbox_cascade_tooltip, (boolean)false, (int)0);
            this.cascadeCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }

        protected boolean needsRefreshOnFinish() {
            return true;
        }
    }
}

