/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageType;
import org.jkiss.utils.ArrayUtils;

public class DataTransferNodeConfiguratorDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataTransferNodeConfiguratorDescriptor.class);
    @NotNull
    private final String id;
    private final List<DataTransferPageDescriptor> pageTypes = new ArrayList<DataTransferPageDescriptor>();

    public DataTransferNodeConfiguratorDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("node");
        this.loadNodeConfigurations(config);
    }

    void loadNodeConfigurations(IConfigurationElement config) {
        for (IConfigurationElement pageConfig : ArrayUtils.safeArray((Object[])config.getChildren("page"))) {
            this.pageTypes.add(new DataTransferPageDescriptor(pageConfig));
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public List<DataTransferPageDescriptor> patPageDescriptors() {
        return this.pageTypes;
    }

    public DataTransferPageDescriptor getPageDescriptor(IWizardPage page) {
        for (DataTransferPageDescriptor pd : this.pageTypes) {
            if (!pd.getPageClass().getImplName().equals(page.getClass().getName())) continue;
            return pd;
        }
        return null;
    }

    public IWizardPage[] createWizardPages(boolean consumerOptional, boolean producerOptional, boolean settingsPage) {
        ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
        for (DataTransferPageDescriptor page : this.pageTypes) {
            if (page.isConsumerSelector() && !consumerOptional || page.isProducerSelector() && !producerOptional || settingsPage != (page.getPageType() == DataTransferPageType.SETTINGS)) continue;
            try {
                AbstractDescriptor.ObjectType type = page.getPageClass();
                type.checkObjectClass(IWizardPage.class);
                pages.add((IWizardPage)type.getObjectClass(IWizardPage.class).newInstance());
            }
            catch (Throwable e) {
                log.error((Object)"Can't create wizard page", e);
            }
        }
        return pages.toArray(new IWizardPage[0]);
    }

    public String toString() {
        return this.id;
    }
}

