/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.editors;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum ExasolObjectType implements DBSObjectType
{
    COLUMN((DBPImage)DBIcon.TREE_COLUMN, ExasolTableColumn.class, new ObjectFinder(){

        public ExasolTableColumn findObject(DBRProgressMonitor monitor, ExasolTable exasolTable, String objectName) throws DBException {
            return exasolTable.getAttribute(monitor, objectName);
        }
    }),
    SCHEMA((DBPImage)DBIcon.TREE_SCHEMA, ExasolSchema.class, null),
    TABLE((DBPImage)DBIcon.TREE_TABLE, ExasolTable.class, new ObjectFinder(){

        @Override
        public ExasolTable findObject(DBRProgressMonitor monitor, ExasolSchema schema, String objectname) throws DBException {
            return (ExasolTable)schema.getTableCache().getObject(monitor, schema, objectname);
        }
    }),
    VIEW((DBPImage)DBIcon.TREE_VIEW, ExasolView.class, new ObjectFinder(null, null));

    private final DBPImage image;
    private final Class<? extends DBSObject> typeClass;
    private final ObjectFinder finder;
    private static Map<String, ExasolObjectType> typeMap;

    static {
        typeMap = new HashMap<String, ExasolObjectType>();
        ExasolObjectType[] exasolObjectTypeArray = ExasolObjectType.values();
        int n = exasolObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExasolObjectType type = exasolObjectTypeArray[n2];
            typeMap.put(type.getTypeName(), type);
            ++n2;
        }
    }

    private <OBJECT_TYPE extends DBSObject> ExasolObjectType(DBPImage image, Class<OBJECT_TYPE> typeClass, ObjectFinder finder) {
        this.image = image;
        this.typeClass = typeClass;
        this.finder = finder;
    }

    public String getTypeName() {
        return this.name();
    }

    public boolean isBrowsable() {
        return this.finder != null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, ExasolDataSource exasolDataSource, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, exasolDataSource, objectName);
        }
        return null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, ExasolSchema schema, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, schema, objectName);
        }
        return null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, ExasolTable exasolTable, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, exasolTable, objectName);
        }
        return null;
    }

    public String getDescription() {
        return null;
    }

    public DBPImage getImage() {
        return this.image;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.typeClass;
    }

    public static ExasolObjectType getByType(String typename) {
        return typeMap.get(typename);
    }

    private static class ObjectFinder {
        private ObjectFinder() {
        }

        DBSObject findObject(DBRProgressMonitor monitor, ExasolDataSource exasolDataSource, String objectName) throws DBException {
            return null;
        }

        DBSObject findObject(DBRProgressMonitor monitor, ExasolSchema schema, String objectName) throws DBException {
            return null;
        }

        DBSObject findObject(DBRProgressMonitor monitor, ExasolTable exasolTable, String objectName) throws DBException {
            return null;
        }

        /* synthetic */ ObjectFinder(ObjectFinder objectFinder, ObjectFinder objectFinder2) {
            this();
        }
    }
}

