/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol;

import java.sql.SQLException;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class ExasolSQLDialect
extends JDBCSQLDialect {
    private static final Log LOG = Log.getLog(ExasolDataSource.class);
    public static final String[] EXEC_KEYWORDS = new String[0];

    public ExasolSQLDialect() {
        super("Exasol");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        try {
            String[] stringArray = metaData.getSQLKeywords().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String kw = stringArray[n2];
                this.addSQLKeyword(kw);
                ++n2;
            }
            JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBPDataSource)dataSource, (String)"");
            Throwable throwable = null;
            Object var5_5 = null;
            try (JDBCStatement stmt = session.createStatement();){
                Throwable throwable2 = null;
                Object var8_13 = null;
                try (JDBCResultSet dbResult = stmt.executeQuery("SELECT KEYWORD,RESERVED FROM  EXA_SQL_KEYWORDS");){
                    while (dbResult.next()) {
                        Boolean isReserved = dbResult.getBoolean(2);
                        String keyWord = dbResult.getString(1);
                        DBPKeywordType type = DBPKeywordType.OTHER;
                        if (isReserved.booleanValue()) {
                            type = DBPKeywordType.KEYWORD;
                        }
                        if (this.getMatchedKeywords(keyWord).stream().anyMatch(k -> k.equals(keyWord))) continue;
                        ArrayList<String> value = new ArrayList<String>(keyWord){
                            {
                                this.add(string);
                            }
                        };
                        this.addKeywords(value, type);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            LOG.warn((Object)"Could not retrieve reserved keyword list from Exasol dictionary");
        }
        ArrayList<String> value = new ArrayList<String>(){
            {
                this.add("KERBEROS");
                this.add("JDBC");
            }
        };
        this.addKeywords(value, DBPKeywordType.OTHER);
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return new String[0];
    }
}

