/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.data.IDataController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.gis.GeometryDataUtils;
import org.jkiss.dbeaver.ui.gis.IGeometryViewer;
import org.jkiss.dbeaver.ui.gis.panel.GISLeafletViewer;
import org.jkiss.utils.ArrayUtils;

public class GISBrowserViewer
extends BaseValueEditor<Browser>
implements IGeometryViewer {
    private static final Log log = Log.getLog(GISBrowserViewer.class);
    private GISLeafletViewer leafletViewer;

    public GISBrowserViewer(IValueController controller) {
        super(controller);
    }

    protected Browser createControl(Composite editPlaceholder) {
        this.leafletViewer = new GISLeafletViewer(editPlaceholder, this.valueController, GisTransformUtils.getSpatialDataProvider((DBPDataSource)this.valueController.getExecutionContext().getDataSource()));
        return this.leafletViewer.getBrowser();
    }

    public void primeEditorValue(@Nullable Object value) throws DBException {
        ArrayList<DBGeometry> geometries = new ArrayList<DBGeometry>();
        IDataController dataController = this.valueController.getDataController();
        if (dataController instanceof IResultSetController) {
            IResultSetSelection selection;
            Object[] selectedValues;
            IResultSetController resultSetController = (IResultSetController)dataController;
            DBSTypedObject valueType = this.valueController.getValueType();
            List<GeometryDataUtils.GeomAttrs> geomAttrs = null;
            if (valueType instanceof DBSAttributeBase) {
                geomAttrs = GeometryDataUtils.extractGeometryAttributes(resultSetController);
            }
            if (ArrayUtils.isEmpty((Object[])(selectedValues = (selection = resultSetController.getSelection()).toArray()))) {
                selectedValues = new Object[]{value};
            }
            Object[] objectArray = selectedValues;
            int n = selectedValues.length;
            int n2 = 0;
            while (n2 < n) {
                DBGeometry geometry;
                ResultSetRow row;
                DBDAttributeBinding attr;
                Object cell = objectArray[n2];
                if (cell instanceof DBGeometry) {
                    attr = resultSetController.getActivePresentation().getCurrentAttribute();
                    row = resultSetController.getCurrentRow();
                    geometry = (DBGeometry)cell;
                } else {
                    attr = selection.getElementAttribute(cell);
                    row = selection.getElementRow(cell);
                    Object cellValue = resultSetController.getModel().getCellValue(attr, row);
                    geometry = GisTransformUtils.getGeometryValueFromObject((DBSDataContainer)this.valueController.getDataController().getDataContainer(), (DBDValueHandler)this.valueController.getValueHandler(), (DBSTypedObject)this.valueController.getValueType(), (Object)cellValue);
                }
                if (geometry != null) {
                    geometries.add(geometry);
                    if (valueType instanceof DBSAttributeBase) {
                        for (GeometryDataUtils.GeomAttrs ga : geomAttrs) {
                            if (!ga.geomAttr.matches((DBSAttributeBase)attr, false)) continue;
                            GeometryDataUtils.setGeometryProperties(resultSetController, ga, geometry, row);
                            break;
                        }
                    }
                    if (geometry.getProperties() == null) {
                        geometry.setProperties(Collections.singletonMap("Object", geometry.getSRID()));
                    }
                }
                ++n2;
            }
        }
        this.leafletViewer.setGeometryData(geometries.toArray(new DBGeometry[0]));
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object extractEditorValue() throws DBCException {
        return this.leafletViewer.getCurrentValue();
    }
}

