/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

public enum DBPDataSourcePermission {
    PERMISSION_EDIT_DATA("edit.data", "Restrict data edit", "Restrict and direct data modifications"),
    PERMISSION_EDIT_METADATA("edit.meta", "Restrict structure edit", "Restrict structure (metadata) changes, like tables create/drop"),
    PERMISSION_EXECUTE_SCRIPTS("edit.execute", "Restrict script execute", "Restruct custom user scripts (SQL) execution"),
    PERMISSION_IMPORT_DATA("import.data", "Restrict data import", "Restrict importing data");

    private final String id;
    private final String label;
    private final String description;

    private DBPDataSourcePermission(String id, String label, String description) {
        this.id = id;
        this.label = label;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public static DBPDataSourcePermission getById(String id) {
        DBPDataSourcePermission[] dBPDataSourcePermissionArray = DBPDataSourcePermission.values();
        int n = dBPDataSourcePermissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPDataSourcePermission permission = dBPDataSourcePermissionArray[n2];
            if (permission.id.equals(id)) {
                return permission;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Wrong permission id: " + id);
    }
}

