/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.registry.StreamValueManagerDescriptor;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerDescriptor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.MimeType;

public class ValueManagerRegistry {
    private static ValueManagerRegistry instance = null;
    private List<ValueManagerDescriptor> managers = new ArrayList<ValueManagerDescriptor>();
    private List<StreamValueManagerDescriptor> streamManagers = new ArrayList<StreamValueManagerDescriptor>();

    public static synchronized ValueManagerRegistry getInstance() {
        if (instance == null) {
            instance = new ValueManagerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ValueManagerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataManager");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("manager".equals(ext.getName())) {
                this.managers.add(new ValueManagerDescriptor(ext));
            } else if ("streamManager".equals(ext.getName())) {
                this.streamManagers.add(new StreamValueManagerDescriptor(ext));
            }
            ++n2;
        }
    }

    @NotNull
    public IValueManager getManager(@Nullable DBPDataSource dataSource, @NotNull DBSTypedObject type, @NotNull Class<?> valueType) {
        IValueManager manager = this.findManager(dataSource, type, valueType, true, true);
        if (manager == null) {
            manager = this.findManager(dataSource, type, valueType, false, true);
        }
        if (manager == null) {
            manager = this.findManager(dataSource, type, valueType, true, false);
        }
        if (manager == null) {
            manager = this.findManager(dataSource, type, valueType, false, false);
        }
        if (manager == null) {
            throw new IllegalStateException("Can't find default data manager for " + type);
        }
        return manager;
    }

    private IValueManager findManager(@Nullable DBPDataSource dataSource, DBSTypedObject typedObject, Class<?> valueType, boolean checkDataSource, boolean checkType) {
        for (ValueManagerDescriptor manager : this.managers) {
            if (!manager.supportsType(dataSource, typedObject, valueType, checkDataSource, checkType)) continue;
            return manager.getInstance();
        }
        return null;
    }

    @NotNull
    public static IValueManager findValueManager(@Nullable DBPDataSource dataSource, @NotNull DBSTypedObject typedObject, @NotNull Class<?> valueType) {
        return ValueManagerRegistry.getInstance().getManager(dataSource, typedObject, valueType);
    }

    public Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> getApplicableStreamManagers(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject attribute, @Nullable DBDContent value) {
        LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType> result = new LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType>();
        for (StreamValueManagerDescriptor contentManager : this.streamManagers) {
            IStreamValueManager.MatchType matchType = contentManager.getInstance().matchesTo(monitor, attribute, value);
            switch (matchType) {
                case NONE: {
                    break;
                }
                case EXCLUSIVE: {
                    result.clear();
                    result.put(contentManager, matchType);
                    return result;
                }
                default: {
                    result.put(contentManager, matchType);
                }
            }
        }
        return result;
    }

    public Map<StreamValueManagerDescriptor, IStreamValueManager.MatchType> getStreamManagersByMimeType(@NotNull String mimeType, String primaryType) {
        MimeType mime = new MimeType(mimeType);
        MimeType primaryMime = primaryType == null ? null : new MimeType(primaryType);
        LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType> result = new LinkedHashMap<StreamValueManagerDescriptor, IStreamValueManager.MatchType>();
        block0: for (StreamValueManagerDescriptor contentManager : this.streamManagers) {
            String[] stringArray = contentManager.getSupportedMime();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sm = stringArray[n2];
                if (!CommonUtils.isEmpty((String)sm) && mime.match(sm)) {
                    if (!CommonUtils.isEmpty((String)contentManager.getPrimaryMime()) && primaryMime != null && primaryMime.match(contentManager.getPrimaryMime())) {
                        result.put(contentManager, IStreamValueManager.MatchType.PRIMARY);
                        continue block0;
                    }
                    result.put(contentManager, IStreamValueManager.MatchType.DEFAULT);
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }
}

