/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.EditVirtualColumnsPage;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class EditVirtualEntityDialog
extends BaseDialog {
    private static final Log log = Log.getLog(EditVirtualEntityDialog.class);
    private static final String DIALOG_ID = "DBeaver.EditVirtualEntityDialog";
    public static final int ID_CREATE_UNIQUE_KEY = 1000;
    public static final int ID_REMOVE_UNIQUE_KEY = 1001;
    public static final int ID_CREATE_FOREIGN_KEY = 2000;
    public static final int ID_REMOVE_FOREIGN_KEY = 2001;
    private ResultSetViewer viewer;
    private DBSEntity entity;
    private DBVEntity vEntity;
    private EditDictionaryPage editDictionaryPage;
    private EditConstraintPage editUniqueKeyPage;
    private DBVEntityConstraint uniqueConstraint;
    private InitPage initPage = InitPage.UNIQUE_KEY;
    private EditVirtualColumnsPage columnsPage;
    private boolean structChanged = false;

    public EditVirtualEntityDialog(ResultSetViewer viewer, @Nullable DBSEntity entity, @NotNull DBVEntity vEntity) {
        super(viewer.getControl().getShell(), "Edit logical structure / presentation", null);
        this.viewer = viewer;
        this.entity = entity;
        this.vEntity = vEntity;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    public InitPage getInitPage() {
        return this.initPage;
    }

    public void setInitPage(InitPage initPage) {
        this.initPage = initPage;
    }

    protected Composite createDialogArea(Composite parent) {
        try {
            UIUtils.runInProgressService(monitor -> {
                for (DBVEntityForeignKey fk : this.vEntity.getForeignKeys()) {
                    try {
                        fk.getRealReferenceConstraint(monitor);
                        fk.getAssociatedEntity(monitor);
                    }
                    catch (DBException e) {
                        log.debug((Object)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        Composite composite = super.createDialogArea(parent);
        TabFolder tabFolder = new TabFolder(composite, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createColumnsPage(tabFolder);
        this.createUniqueKeysPage(tabFolder);
        this.createForeignKeysPage(tabFolder);
        this.createDictionaryPage(tabFolder);
        TabItem[] tabItemArray = tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            if (item.getData() == this.initPage) {
                tabFolder.setSelection(item);
                break;
            }
            ++n2;
        }
        UIUtils.createInfoLabel((Composite)composite, (String)"Entity logical structure is defined on client-side.\nYou can define virtual unique/foreign keys even if physical database\ndoesn't have or doesn't support them. Also you can define how to view column values.");
        return parent;
    }

    private void createDictionaryPage(TabFolder tabFolder) {
        if (this.entity != null) {
            this.editDictionaryPage = new EditDictionaryPage(this.entity);
            this.editDictionaryPage.createControl((Composite)tabFolder);
            TabItem dictItem = new TabItem(tabFolder, 0);
            dictItem.setText("Dictionary");
            dictItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PACKAGE));
            dictItem.setControl(this.editDictionaryPage.getControl());
            dictItem.setData((Object)InitPage.DICTIONARY);
        }
    }

    private void createColumnsPage(TabFolder tabFolder) {
        TabItem attrsItem = new TabItem(tabFolder, 0);
        attrsItem.setText("Virtual Columns");
        attrsItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_COLUMN));
        attrsItem.setData((Object)InitPage.ATTRIBUTES);
        Composite panel = this.createColumnsEditPanel(tabFolder);
        attrsItem.setControl((Control)panel);
    }

    @NotNull
    private Composite createColumnsEditPanel(TabFolder tabFolder) {
        this.columnsPage = new EditVirtualColumnsPage(this.viewer, this.vEntity);
        return this.columnsPage.createPageContents((Composite)tabFolder);
    }

    private void updateColumnItem(TableItem attrItem) {
        DBVTransformSettings transformSettings;
        DBDAttributeBinding attr = (DBDAttributeBinding)attrItem.getData();
        String transformStr = "";
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(attr, false);
        if (vAttr != null && (transformSettings = vAttr.getTransformSettings()) != null) {
            DBDAttributeTransformerDescriptor td;
            if (!CommonUtils.isEmpty((Collection)transformSettings.getIncludedTransformers())) {
                transformStr = String.join((CharSequence)",", transformSettings.getIncludedTransformers());
            } else if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer()) && (td = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformSettings.getCustomTransformer())) != null) {
                transformStr = td.getName();
            }
        }
        attrItem.setText(1, transformStr);
        String colorSettings = "";
        List coList = this.vEntity.getColorOverrides(attr.getName());
        if (!coList.isEmpty()) {
            ArrayList<String> coStrings = new ArrayList<String>();
            for (DBVColorOverride co : coList) {
                if (co.getAttributeValues() == null) continue;
                Object[] objectArray = co.getAttributeValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    coStrings.add(CommonUtils.toString((Object)value));
                    ++n2;
                }
            }
            colorSettings = String.join((CharSequence)",", coStrings);
        }
        attrItem.setText(2, colorSettings);
    }

    private void createUniqueKeysPage(TabFolder tabFolder) {
        this.uniqueConstraint = this.vEntity.getBestIdentifier();
        if (this.uniqueConstraint == null) {
            return;
        }
        TabItem ukItem = new TabItem(tabFolder, 0);
        ukItem.setText("Virtual Unique Key");
        ukItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_UNIQUE_KEY));
        ukItem.setData((Object)InitPage.UNIQUE_KEY);
        this.editUniqueKeyPage = new EditConstraintPage("Define unique identifier", (DBSEntityReferrer)this.uniqueConstraint);
        this.editUniqueKeyPage.createControl((Composite)tabFolder);
        ukItem.setControl(this.editUniqueKeyPage.getControl());
    }

    private void createForeignKeysPage(TabFolder tabFolder) {
        TabItem fkItem = new TabItem(tabFolder, 0);
        fkItem.setText("Virtual Foreign Keys");
        fkItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        fkItem.setData((Object)InitPage.FOREIGN_KEYS);
        Composite panel = new Composite((Composite)tabFolder, 1);
        panel.setLayout((Layout)new GridLayout(1, false));
        fkItem.setControl((Control)panel);
        final Table fkTable = new Table(panel, 67584);
        fkTable.setLayoutData((Object)new GridData(1808));
        fkTable.setHeaderVisible(true);
        UIUtils.executeOnResize((Control)fkTable, () -> UIUtils.packColumns((Table)fkTable, (boolean)true));
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)"Ref Table");
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)"Columns");
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)"Ref Datasource");
        for (DBVEntityForeignKey fk : this.vEntity.getForeignKeys()) {
            this.createForeignKeyItem(fkTable, fk);
        }
        Composite buttonsPanel = UIUtils.createComposite((Composite)panel, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        Button btnAdd = this.createButton(buttonsPanel, 2000, "Add", false);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = EditForeignKeyPage.createVirtualForeignKey((DBVEntity)EditVirtualEntityDialog.this.vEntity);
                if (virtualFK != null) {
                    EditVirtualEntityDialog.this.createForeignKeyItem(fkTable, virtualFK);
                    EditVirtualEntityDialog.this.structChanged = true;
                }
            }
        });
        Button btnRemove = this.createButton(buttonsPanel, 2001, "Remove", false);
        btnRemove.setEnabled(false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = (DBVEntityForeignKey)fkTable.getSelection()[0].getData();
                if (!UIUtils.confirmAction((Shell)EditVirtualEntityDialog.this.getShell(), (String)"Delete virtual FK", (String)("Are you sure you want to delete virtual foreign key '" + virtualFK.getName() + "'?"))) {
                    return;
                }
                EditVirtualEntityDialog.this.vEntity.removeForeignKey(virtualFK);
                fkTable.remove(fkTable.getSelectionIndices());
                EditVirtualEntityDialog.this.structChanged = true;
            }
        });
        fkTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasSelection = fkTable.getSelectionIndex() >= 0;
                EditVirtualEntityDialog.this.getButton(2001).setEnabled(hasSelection);
            }
        });
    }

    private void createForeignKeyItem(Table fkTable, DBVEntityForeignKey fk) {
        DBSEntityConstraint referencedConstraint = fk.getReferencedConstraint();
        if (referencedConstraint == null) {
            log.debug((Object)("No reference constraint for FK " + fk.getName()));
            return;
        }
        TableItem item = new TableItem(fkTable, 0);
        DBSEntity refEntity = referencedConstraint.getParentObject();
        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        if (referencedConstraint != null) {
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)refEntity, (DBPEvaluationContext)DBPEvaluationContext.UI));
        }
        String ownAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getAttributeName).collect(Collectors.joining(","));
        String refAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getRefAttributeName).collect(Collectors.joining(","));
        item.setText(1, "(" + ownAttrNames + ") -> (" + refAttrNames + ")");
        item.setImage(2, DBeaverIcons.getImage((DBPImage)refEntity.getDataSource().getContainer().getDriver().getIcon()));
        item.setText(2, refEntity.getDataSource().getContainer().getName());
        item.setData((Object)fk);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.editUniqueKeyPage != null) {
            Collection uniqueAttrs = this.editUniqueKeyPage.getSelectedAttributes();
            this.uniqueConstraint.setName(this.editUniqueKeyPage.getConstraintName());
            this.uniqueConstraint.setAttributes(uniqueAttrs);
            DBDRowIdentifier virtualEntityIdentifier = this.viewer.getVirtualEntityIdentifier();
            if (virtualEntityIdentifier != null) {
                try {
                    virtualEntityIdentifier.reloadAttributes((DBRProgressMonitor)new VoidProgressMonitor(), this.viewer.getModel().getAttributes());
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }
        if (this.editDictionaryPage != null) {
            this.editDictionaryPage.saveDictionarySettings();
        }
        this.vEntity.persistConfiguration();
        if (this.structChanged || this.columnsPage.isStructChanged()) {
            this.viewer.refreshData(null);
        }
        super.okPressed();
    }

    public static enum InitPage {
        ATTRIBUTES,
        UNIQUE_KEY,
        FOREIGN_KEYS,
        DICTIONARY;

    }
}

