/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExpressionNode;
import org.eclipse.ui.internal.registry.KeywordRegistry;
import org.eclipse.ui.model.IComparableContribution;

public abstract class WorkbenchPreferenceExtensionNode
extends WorkbenchPreferenceExpressionNode
implements IComparableContribution {
    private Collection<String> keywordReferences;
    private IConfigurationElement configurationElement;
    private ImageDescriptor imageDescriptor;
    private Image image;
    private Collection<String> keywordLabelCache;
    private int priority;
    private String pluginId;

    public WorkbenchPreferenceExtensionNode(String id, IConfigurationElement configurationElement) {
        super(id);
        this.configurationElement = configurationElement;
        this.pluginId = configurationElement.getNamespaceIdentifier();
    }

    public Collection<String> getKeywordReferences() {
        if (this.keywordReferences == null) {
            IConfigurationElement[] references = this.getConfigurationElement().getChildren("keywordReference");
            HashSet<String> list = new HashSet<String>(references.length);
            IConfigurationElement[] iConfigurationElementArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String id = configElement.getAttribute("id");
                if (id != null) {
                    list.add(id);
                }
                ++n2;
            }
            this.keywordReferences = !list.isEmpty() ? list : Collections.EMPTY_SET;
        }
        return this.keywordReferences;
    }

    public Collection<String> getKeywordLabels() {
        if (this.keywordLabelCache != null) {
            return this.keywordLabelCache;
        }
        Collection<String> refs = this.getKeywordReferences();
        if (refs.isEmpty()) {
            this.keywordLabelCache = Collections.emptySet();
            return this.keywordLabelCache;
        }
        this.keywordLabelCache = new ArrayList<String>(refs.size());
        for (String reference : refs) {
            String label = KeywordRegistry.getInstance().getKeywordLabel(reference);
            if (label == null) continue;
            this.keywordLabelCache.add(label);
        }
        return this.keywordLabelCache;
    }

    public void clearKeywords() {
        this.keywordLabelCache = null;
    }

    public void disposeResources() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.disposeResources();
    }

    public Image getLabelImage() {
        ImageDescriptor desc;
        if (this.image == null && (desc = this.getImageDescriptor()) != null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    public String getLabelText() {
        return this.getConfigurationElement().getAttribute("name");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String imageName = this.getConfigurationElement().getAttribute("icon");
        if (imageName != null) {
            String contributingPluginId = this.pluginId;
            this.imageDescriptor = ResourceLocator.imageDescriptorFromBundle((String)contributingPluginId, (String)imageName).orElse(null);
        }
        return this.imageDescriptor;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IConfigurationElement.class) {
            return adapter.cast(this.getConfigurationElement());
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.getLabelText();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int pri) {
        this.priority = pri;
    }
}

