/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import org.eclipse.urischeme.internal.registration.FileProvider;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IRegistryWriter;
import org.eclipse.urischeme.internal.registration.IWinRegistry;
import org.eclipse.urischeme.internal.registration.Util;
import org.eclipse.urischeme.internal.registration.WinRegistry;
import org.eclipse.urischeme.internal.registration.WinRegistryException;

public class RegistryWriter
implements IRegistryWriter {
    private String key_software_classes;
    private String key_shell;
    private String key_open;
    private String key_command;
    private static final String ATTRIBUTE_DEFAULT = null;
    private static final String ATTRIBUTE_EXECUTABLE = "Executable";
    private static final String ATTRIBUTE_PROTOCOL_MARKER = "URL Protocol";
    private IWinRegistry winRegistry = null;
    private IFileProvider fileProvider = null;

    public RegistryWriter() {
        this(new WinRegistry(), new FileProvider());
    }

    public RegistryWriter(IWinRegistry winRegistry, IFileProvider fileProvider) {
        this.winRegistry = winRegistry;
        this.fileProvider = fileProvider;
    }

    @Override
    public void addScheme(String scheme, String launcherPath) throws WinRegistryException {
        Util.assertUriSchemeIsLegal(scheme);
        this.getRegisteredHandlerPath(scheme);
        this.winRegistry.setValueForKey(this.key_software_classes, ATTRIBUTE_PROTOCOL_MARKER, "");
        this.winRegistry.setValueForKey(this.key_software_classes, ATTRIBUTE_DEFAULT, "URL:" + scheme);
        this.winRegistry.setValueForKey(this.key_command, ATTRIBUTE_EXECUTABLE, launcherPath);
        String openCommand = String.valueOf(IRegistryWriter.quote(launcherPath)) + " " + IRegistryWriter.quote("%1");
        this.winRegistry.setValueForKey(this.key_command, ATTRIBUTE_DEFAULT, openCommand);
    }

    @Override
    public void removeScheme(String scheme) throws WinRegistryException {
        Util.assertUriSchemeIsLegal(scheme);
        if (this.getRegisteredHandlerPath(scheme) == null) {
            return;
        }
        this.winRegistry.deleteKey(this.key_command);
        this.winRegistry.deleteKey(this.key_open);
        this.winRegistry.deleteKey(this.key_shell);
        this.winRegistry.deleteKey(this.key_software_classes);
    }

    @Override
    public String getRegisteredHandlerPath(String scheme) throws WinRegistryException {
        this.changeKeys(scheme);
        String marker = this.winRegistry.getValueForKey(this.key_software_classes, ATTRIBUTE_PROTOCOL_MARKER);
        if (marker == null) {
            return null;
        }
        String command = this.winRegistry.getValueForKey(this.key_command, ATTRIBUTE_DEFAULT);
        if (command == null) {
            return null;
        }
        String exec = this.winRegistry.getValueForKey(this.key_command, ATTRIBUTE_EXECUTABLE);
        if (exec == null) {
            return null;
        }
        if (!this.fileProvider.fileExists(exec)) {
            return null;
        }
        return exec;
    }

    void changeKeys(String scheme) {
        this.key_software_classes = "Software\\Classes\\";
        this.key_software_classes = String.valueOf(this.key_software_classes) + scheme;
        this.key_shell = String.valueOf(this.key_software_classes) + "\\shell";
        this.key_open = String.valueOf(this.key_shell) + "\\open";
        this.key_command = String.valueOf(this.key_open) + "\\command";
    }
}

