/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.json;

import java.util.LinkedList;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.ui.UIUtils;

public class JSONScanner
extends RuleBasedScanner {
    public JSONScanner() {
        this.initScanner();
    }

    public void reinitScanner() {
        this.initScanner();
    }

    private void initScanner() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        Color colorKey = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.keyword.foreground");
        Color colorString = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.string.foreground");
        Color colorValue = colorRegistry.get("org.jkiss.dbeaver.sql.editor.color.number.foreground");
        Token string = new Token((Object)new TextAttribute(colorString));
        Token value = new Token((Object)new TextAttribute(colorValue));
        Token defaultText = new Token((Object)new TextAttribute(colorKey));
        LinkedList<Object> rules = new LinkedList<Object>();
        rules.add(new NumberRule((IToken)value));
        rules.add(new MultiLineRule(":\"", "\"", (IToken)value, '\\'));
        rules.add(new MultiLineRule(": \"", "\"", (IToken)value, '\\'));
        rules.add(new MultiLineRule("\"", "\"", (IToken)string, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)defaultText);
        wordRule.addWord("null", (IToken)value);
        wordRule.addWord("true", (IToken)value);
        wordRule.addWord("false", (IToken)value);
        rules.add(wordRule);
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public static class WhitespaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }

    public static class WordDetector
    implements IWordDetector {
        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierPart(character);
        }
    }
}

