/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class MySQLTableManager
extends SQLTableManager<MySQLTableBase, MySQLCatalog>
implements DBEObjectRenamer<MySQLTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{MySQLTableColumn.class, MySQLTableConstraint.class, MySQLTableForeignKey.class, MySQLTableIndex.class};

    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableBase> getObjectsCache(MySQLTableBase object) {
        return ((MySQLCatalog)object.getContainer()).getTableCache();
    }

    protected MySQLTableBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        MySQLTable table;
        MySQLCatalog catalog = (MySQLCatalog)container;
        if (copyFrom instanceof DBSEntity) {
            table = new MySQLTable(monitor, catalog, (DBSEntity)copyFrom);
            table.setName(this.getNewChildName(monitor, (DBSObjectContainer)catalog, ((DBSEntity)copyFrom).getName()));
        } else if (copyFrom == null) {
            table = new MySQLTable(catalog);
            this.setTableName(monitor, (DBSObjectContainer)catalog, (DBSEntity)table);
            MySQLTable.AdditionalInfo additionalInfo = table.getAdditionalInfo(monitor);
            additionalInfo.setEngine(catalog.getDataSource().getDefaultEngine());
            additionalInfo.setCharset(catalog.getAdditionalInfo(monitor).getDefaultCharset());
            additionalInfo.setCollation(catalog.getAdditionalInfo(monitor).getDefaultCollation());
        } else {
            throw new DBException("Can't create MySQL table from '" + copyFrom + "'");
        }
        return table;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        StringBuilder query = new StringBuilder("ALTER TABLE ");
        query.append(((MySQLTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        this.appendTableModifiers(monitor, (MySQLTableBase)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, query, true);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"script.includeDrop")) {
            MySQLTableBase table = (MySQLTableBase)command.getObject();
            if (CommonUtils.getOption(options, (String)"useFQN", (boolean)true)) {
                table.getFullyQualifiedName(DBPEvaluationContext.DDL);
            } else {
                DBUtils.getQuotedIdentifier((DBSObject)table);
            }
            actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, "DROP TABLE IF EXISTS " + table));
        }
        super.addStructObjectCreateActions(monitor, actions, command, options);
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, MySQLTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        if (tableBase instanceof MySQLTable) {
            MySQLTable table = (MySQLTable)tableBase;
            try {
                MySQLTable.AdditionalInfo additionalInfo = table.getAdditionalInfo(monitor);
                if (!(table.isPersisted() && tableProps.getProperty((Object)"engine") == null || additionalInfo.getEngine() == null)) {
                    ddl.append("\nENGINE=").append(additionalInfo.getEngine().getName());
                }
                if (!(table.isPersisted() && tableProps.getProperty((Object)"charset") == null || additionalInfo.getCharset() == null)) {
                    ddl.append("\nDEFAULT CHARSET=").append(additionalInfo.getCharset().getName());
                }
                if (!(table.isPersisted() && tableProps.getProperty((Object)"collation") == null || additionalInfo.getCollation() == null)) {
                    ddl.append("\nCOLLATE=").append(additionalInfo.getCollation().getName());
                }
                if (!(table.isPersisted() && tableProps.getProperty((Object)"description") == null || table.getDescription() == null)) {
                    ddl.append("\nCOMMENT=").append(SQLUtils.quoteString((DBSObject)table, (String)table.getDescription()));
                }
                if (!(table.isPersisted() && tableProps.getProperty((Object)"autoIncrement") == null || additionalInfo.getAutoIncrement() <= 0L)) {
                    ddl.append("\nAUTO_INCREMENT=").append(additionalInfo.getAutoIncrement());
                }
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        MySQLDataSource dataSource = (MySQLDataSource)((MySQLTableBase)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "RENAME TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((MySQLTableBase)command.getObject()).getContainer()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBSObject)((MySQLTableBase)command.getObject()).getContainer()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, MySQLTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == MySQLTableColumn.class) {
            return object.getAttributes(monitor);
        }
        if (childType == MySQLTableConstraint.class) {
            return object.getConstraints(monitor);
        }
        if (childType == MySQLTableForeignKey.class) {
            return object.getAssociations(monitor);
        }
        if (childType == MySQLTableIndex.class) {
            return object.getIndexes(monitor);
        }
        return null;
    }

    public void renameObject(DBECommandContext commandContext, MySQLTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }
}

