/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class DB2UniqueKeyManager
extends SQLConstraintManager<DB2TableUniqueKey, DB2Table> {
    private static final String SQL_DROP_PK = "ALTER TABLE %s DROP PRIMARY KEY ";
    private static final String SQL_DROP_UK = "ALTER TABLE %s DROP UNIQUE %s";
    private static final DBSEntityConstraintType[] CONS_TYPES = new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY, DBSEntityConstraintType.UNIQUE_KEY};

    public boolean canEditObject(DB2TableUniqueKey object) {
        return false;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2TableUniqueKey> getObjectsCache(DB2TableUniqueKey object) {
        return ((DB2Table)object.getParentObject()).getSchema().getConstraintCache();
    }

    public DB2TableUniqueKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object table, Object from, Map<String, Object> options) {
        final DB2TableUniqueKey constraint = new DB2TableUniqueKey((DB2Table)table, DBSEntityConstraintType.UNIQUE_KEY);
        return (DB2TableUniqueKey)((Object)new UITask<DB2TableUniqueKey>(){

            protected DB2TableUniqueKey runTask() {
                EditConstraintPage editPage = new EditConstraintPage(DB2Messages.edit_db2_constraint_manager_dialog_title, (DBSEntityConstraint)constraint, CONS_TYPES);
                if (!editPage.edit()) {
                    return null;
                }
                constraint.setConstraintType(editPage.getConstraintType());
                constraint.setName(editPage.getConstraintName());
                ArrayList<DB2TableKeyColumn> columns = new ArrayList<DB2TableKeyColumn>(editPage.getSelectedAttributes().size());
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    DB2TableKeyColumn column = new DB2TableKeyColumn((AbstractTableConstraint<DB2Table>)constraint, (DB2TableColumn)tableColumn, colIndex++);
                    columns.add(column);
                }
                constraint.setColumns(columns);
                return constraint;
            }
        }.execute());
    }

    public String getDropConstraintPattern(DB2TableUniqueKey constraint) {
        String tablename = constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL);
        if (constraint.getConstraintType().equals(DBSEntityConstraintType.PRIMARY_KEY)) {
            return String.format(SQL_DROP_PK, tablename);
        }
        return String.format(SQL_DROP_UK, tablename, constraint.getName());
    }

    @NotNull
    protected String getAddConstraintTypeClause(DB2TableUniqueKey constraint) {
        if (constraint.getConstraintType() == DBSEntityConstraintType.UNIQUE_KEY) {
            return "UNIQUE";
        }
        return super.getAddConstraintTypeClause((JDBCTableConstraint)constraint);
    }
}

