/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.SimpleCatalog;
import com.sleepycat.client.persist.raw.RawObject;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class ReadOnlyCatalog
implements Catalog {
    private final ClassLoader classLoader;
    private List<Format> formatList;
    private Map<String, Format> formatMap;

    ReadOnlyCatalog(ClassLoader classLoader, List<Format> list, Map<String, Format> map) {
        this.classLoader = classLoader;
        this.formatList = list;
        this.formatMap = map;
    }

    @Override
    public int getInitVersion(Format format, boolean bl) {
        return 1;
    }

    @Override
    public Format getFormat(int n, boolean bl) {
        try {
            Format format = this.formatList.get(n);
            if (format == null) {
                throw DbCompat.unexpectedState("Format does not exist: " + n);
            }
            return format;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw DbCompat.unexpectedState("Format does not exist: " + n);
        }
    }

    @Override
    public Format getFormat(Class clazz, boolean bl) {
        Format format = this.formatMap.get(clazz.getName());
        if (format == null) {
            throw new IllegalArgumentException("Class is not persistent: " + clazz.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String string) {
        return this.formatMap.get(string);
    }

    @Override
    public Format createFormat(String string, Map<String, Format> map) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject rawObject, IdentityHashMap identityHashMap) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Class resolveClass(String string) throws ClassNotFoundException {
        return SimpleCatalog.resolveClass(string, this.classLoader);
    }

    @Override
    public Class resolveKeyClass(String string) {
        return SimpleCatalog.resolveKeyClass(string, this.classLoader);
    }
}

