/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.evolve.Converter;
import com.sleepycat.client.persist.evolve.Deleter;
import com.sleepycat.client.persist.evolve.Mutation;
import com.sleepycat.client.persist.evolve.Mutations;
import com.sleepycat.client.persist.evolve.Renamer;
import com.sleepycat.client.persist.impl.ComplexFormat;
import com.sleepycat.client.persist.impl.ConverterReader;
import com.sleepycat.client.persist.impl.FieldInfo;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.PersistCatalog;
import com.sleepycat.client.persist.impl.Reader;
import com.sleepycat.client.persist.impl.Store;
import com.sleepycat.client.persist.model.SecondaryKeyMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Evolver {
    static final int EVOLVE_NONE = 0;
    static final int EVOLVE_NEEDED = 1;
    static final int EVOLVE_FAILURE = 2;
    private PersistCatalog catalog;
    private String storePrefix;
    private Mutations mutations;
    private Map<String, Format> newFormats;
    private boolean forceEvolution;
    private boolean disallowClassChanges;
    private boolean nestedFormatsChanged;
    private Map<Format, Format> changedFormats;
    private StringBuilder errors;
    private Set<String> deleteDbs;
    private Map<String, String> renameDbs;
    private Map<Format, Format> renameFormats;
    private Map<Integer, Boolean> evolvedFormats;
    private List<Format> unprocessedFormats;
    private Map<Format, Set<Format>> subclassMap;

    Evolver(PersistCatalog persistCatalog, String string, Mutations mutations, Map<String, Format> map, boolean bl, boolean bl2) {
        this.catalog = persistCatalog;
        this.storePrefix = string;
        this.mutations = mutations;
        this.newFormats = map;
        this.forceEvolution = bl;
        this.disallowClassChanges = bl2;
        this.changedFormats = new IdentityHashMap<Format, Format>();
        this.errors = new StringBuilder();
        this.deleteDbs = new HashSet<String>();
        this.renameDbs = new HashMap<String, String>();
        this.renameFormats = new IdentityHashMap<Format, Format>();
        this.evolvedFormats = new HashMap<Integer, Boolean>();
        this.unprocessedFormats = new ArrayList<Format>();
        this.subclassMap = persistCatalog.getSubclassMap();
    }

    final Mutations getMutations() {
        return this.mutations;
    }

    boolean areFormatsChanged() {
        return !this.changedFormats.isEmpty();
    }

    boolean isFormatChanged(Format format) {
        return this.changedFormats.containsKey(format);
    }

    private void setFormatsChanged(Format format) {
        this.checkClassChangesAllowed(format);
        this.changedFormats.put(format, format);
        this.nestedFormatsChanged = true;
        if (PersistCatalog.expectNoClassChanges) {
            throw new IllegalStateException("expectNoClassChanges");
        }
    }

    private void checkClassChangesAllowed(Format format) {
        if (this.disallowClassChanges) {
            throw new IllegalStateException("When performing an upgrade changes are not allowed but were made to: " + format.getClassName());
        }
    }

    Set<Format> getSubclassFormats(Format format) {
        return this.subclassMap.get(format);
    }

    String getErrors() {
        if (this.errors.length() > 0) {
            return this.errors.toString() + "\n---\n" + "(Note that when upgrading an application in a replicated " + "environment, this exception may indicate that the Master " + "was mistakenly upgraded before this Replica could be " + "upgraded, and the solution is to upgrade this Replica.)";
        }
        return null;
    }

    private void addError(String string) {
        if (this.errors.length() > 0) {
            this.errors.append("\n---\n");
        }
        this.errors.append(string);
    }

    private String getClassVersionLabel(Format format, String string) {
        if (format != null) {
            return string + " class: " + format.getClassName() + " version: " + format.getVersion();
        }
        return "";
    }

    void addEvolveError(Format format, Format format2, String string, String string2) {
        this.checkClassChangesAllowed(format);
        if (string == null) {
            string = "Error";
        }
        this.addError(string + " when evolving" + this.getClassVersionLabel(format, "") + this.getClassVersionLabel(format2, " to") + " Error: " + string2);
    }

    void addInvalidMutation(Format format, Format format2, Mutation mutation, String string) {
        this.checkClassChangesAllowed(format);
        this.addError("Invalid mutation: " + mutation + this.getClassVersionLabel(format, " For") + this.getClassVersionLabel(format2, " New") + " Error: " + string);
    }

    void addMissingMutation(Format format, Format format2, String string) {
        this.checkClassChangesAllowed(format);
        this.addError("Mutation is missing to evolve" + this.getClassVersionLabel(format, "") + this.getClassVersionLabel(format2, " to") + " Error: " + string);
    }

    void addNonEntityFormat(Format format) {
        this.unprocessedFormats.add(format);
    }

    void finishEvolution() {
        for (Format format : this.unprocessedFormats) {
            format.setUnused(true);
            this.evolveFormat(format);
        }
    }

    boolean evolveFormat(Format format) {
        boolean bl;
        Integer n;
        if (format.isNew()) {
            return true;
        }
        ComplexFormat complexFormat = format.getEntityFormat();
        boolean bl2 = complexFormat != null;
        boolean bl3 = this.nestedFormatsChanged;
        if (bl2) {
            this.nestedFormatsChanged = false;
        }
        if (this.evolvedFormats.containsKey(n = Integer.valueOf(format.getId()))) {
            bl = this.evolvedFormats.get(n);
        } else {
            this.evolvedFormats.put(n, true);
            bl = this.evolveFormatInternal(format);
            this.evolvedFormats.put(n, bl);
        }
        if (format.getLatestVersion().isNew()) {
            this.nestedFormatsChanged = true;
        }
        if (bl2) {
            Format format2;
            if (this.nestedFormatsChanged && (format2 = complexFormat.getLatestVersion()) != null) {
                format2.setEvolveNeeded(true);
            }
            this.nestedFormatsChanged = bl3;
        }
        return bl;
    }

    private boolean evolveFormatInternal(Format format) {
        boolean bl;
        Serializable serializable;
        String string;
        Object object;
        Serializable serializable2;
        if (Format.isPredefined(format) || format.isDeleted()) {
            return true;
        }
        String string2 = format.getClassName();
        int n = format.getVersion();
        Renamer renamer = this.mutations.getRenamer(string2, n, null);
        Deleter deleter = this.mutations.getDeleter(string2, n, null);
        Converter converter = this.mutations.getConverter(string2, n, null);
        if (deleter != null && (converter != null || renamer != null)) {
            this.addInvalidMutation(format, null, deleter, "Class Deleter not allowed along with a Renamer or Converter for the same class");
            return false;
        }
        if (format.isArray()) {
            if (deleter != null || converter != null || renamer != null) {
                Deleter deleter2 = deleter != null ? deleter : (converter != null ? converter : renamer);
                this.addInvalidMutation(format, null, deleter2, "Mutations not allowed for an array");
                return false;
            }
            serializable2 = format.getComponentType();
            if (!this.evolveFormat((Format)serializable2)) {
                return false;
            }
            object = serializable2.getLatestVersion();
            string = object != serializable2 ? (((Format)object).isArray() ? "[" : "[L") + ((Format)object).getClassName() + ';' : string2;
        } else {
            string = renamer != null ? renamer.getNewName() : string2;
        }
        try {
            serializable = this.catalog.resolveClass(string);
            try {
                serializable2 = this.catalog.createFormat((Class)serializable, this.newFormats);
                assert (serializable2 != format) : serializable2.getClassName();
                object = null;
            }
            catch (Exception exception) {
                serializable2 = null;
                object = exception.toString();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            serializable2 = null;
            object = classNotFoundException.toString();
        }
        if (serializable2 != null) {
            if (format != format.getLatestVersion() && serializable2.getPreviousVersion() == null) {
                assert (this.newFormats.containsValue(serializable2));
                serializable = format.getLatestVersion();
                if (!this.evolveFormat((Format)serializable)) {
                    return false;
                }
                if (serializable == ((Format)serializable).getLatestVersion()) {
                    this.newFormats.remove(serializable2.getClassName());
                    serializable2 = serializable;
                }
            }
            if (!this.forceEvolution && serializable2 == format.getLatestVersion()) {
                return true;
            }
        }
        if (renamer != null && !this.applyClassRenamer(renamer, format, (Format)serializable2)) {
            return false;
        }
        if (converter != null) {
            if (format.isEntity()) {
                if (serializable2 == null || !serializable2.isEntity()) {
                    this.addInvalidMutation(format, (Format)serializable2, converter, "Class converter not allowed for an entity class that is no longer present or not having an @Entity annotation");
                    return false;
                }
                if (!format.evolveMetadata((Format)serializable2, converter, this)) {
                    return false;
                }
            }
            return this.applyConverter(converter, format, (Format)serializable2);
        }
        boolean bl2 = bl = serializable2 == null || serializable2.isEntity() != format.isEntity();
        if (deleter != null) {
            if (!bl) {
                this.addInvalidMutation(format, (Format)serializable2, deleter, "Class deleter not allowed when the class and its @Entity or @Persistent annotation is still present");
                return false;
            }
            return this.applyClassDeleter(deleter, format, (Format)serializable2);
        }
        if (bl) {
            if (serializable2 == null) {
                assert (object != null);
                this.addMissingMutation(format, (Format)serializable2, (String)object);
            } else {
                this.addMissingMutation(format, (Format)serializable2, "@Entity switched to/from @Persistent");
            }
            return false;
        }
        return format.evolve((Format)serializable2, this);
    }

    void useOldFormat(Format format, Format format2) {
        Format format3 = this.renameFormats.get(format);
        if (format3 != null) {
            assert (format3 == format2);
            this.useEvolvedFormat(format, format3, format3);
        } else if (!(format2 == null || format.getVersion() == format2.getVersion() && format.isCurrentVersion())) {
            this.useEvolvedFormat(format, format2, format2);
        } else {
            this.catalog.useExistingFormat(format);
            if (format2 != null) {
                this.newFormats.remove(format2.getClassName());
            }
        }
    }

    void useEvolvedFormat(Format format, Reader reader, Format format2) {
        format.setReader(reader);
        if (format2 != null) {
            format.setLatestVersion(format2);
        }
        this.setFormatsChanged(format);
    }

    private boolean applyClassRenamer(Renamer renamer, Format format, Format format2) {
        if (!this.checkUpdatedVersion(renamer, format, format2)) {
            return false;
        }
        if (format.isEntity() && format.isCurrentVersion()) {
            String string = format2.getClassName();
            String string2 = format.getClassName();
            this.renameDbs.put(Store.makePriDbName(this.storePrefix, string2), Store.makePriDbName(this.storePrefix, string));
            for (SecondaryKeyMetadata secondaryKeyMetadata : format.getEntityMetadata().getSecondaryKeys().values()) {
                String string3 = secondaryKeyMetadata.getKeyName();
                this.renameDbs.put(Store.makeSecDbName(this.storePrefix, string2, string3), Store.makeSecDbName(this.storePrefix, string, string3));
            }
        }
        this.renameFormats.put(format, format2);
        this.setFormatsChanged(format);
        return true;
    }

    void renameSecondaryDatabase(String string, String string2, String string3, String string4) {
        this.renameDbs.put(Store.makeSecDbName(this.storePrefix, string, string3), Store.makeSecDbName(this.storePrefix, string2, string4));
    }

    private boolean applyClassDeleter(Deleter deleter, Format format, Format format2) {
        if (!this.checkUpdatedVersion(deleter, format, format2)) {
            return false;
        }
        if (format.isEntity() && format.isCurrentVersion()) {
            String string = format.getClassName();
            this.deleteDbs.add(Store.makePriDbName(this.storePrefix, string));
            for (SecondaryKeyMetadata secondaryKeyMetadata : format.getEntityMetadata().getSecondaryKeys().values()) {
                this.deleteDbs.add(Store.makeSecDbName(this.storePrefix, string, secondaryKeyMetadata.getKeyName()));
            }
        }
        format.setDeleted(true);
        if (format2 != null) {
            format.setLatestVersion(format2);
        }
        this.setFormatsChanged(format);
        return true;
    }

    void deleteSecondaryDatabase(String string, String string2) {
        this.deleteDbs.add(Store.makeSecDbName(this.storePrefix, string, string2));
    }

    private boolean applyConverter(Converter converter, Format format, Format format2) {
        if (!this.checkUpdatedVersion(converter, format, format2)) {
            return false;
        }
        ConverterReader converterReader = new ConverterReader(converter);
        this.useEvolvedFormat(format, converterReader, format2);
        return true;
    }

    boolean isClassConverted(Format format) {
        return format.getReader() instanceof ConverterReader;
    }

    private boolean checkUpdatedVersion(Mutation mutation, Format format, Format format2) {
        if (format2 != null && !format.isEnum() && format2.getVersion() <= format.getVersion()) {
            this.addInvalidMutation(format, format2, mutation, "A new higher version number must be assigned");
            return false;
        }
        return true;
    }

    boolean checkUpdatedVersion(String string, Format format, Format format2) {
        if (format2 != null && !format.isEnum() && format2.getVersion() <= format.getVersion()) {
            this.addEvolveError(format, format2, string, "A new higher version number must be assigned");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameAndRemoveDatabases(Store store, STransaction sTransaction) throws SDatabaseException {
        for (String object : this.deleteDbs) {
            String[] stringArray = store.parseDbName(object);
            DbCompat.removeDatabase(store.getEnvironment(), sTransaction, stringArray[0], stringArray[1]);
        }
        boolean bl = false;
        if (sTransaction != null) {
            bl = DbCompat.setImportunate(sTransaction, true);
        }
        try {
            for (Map.Entry<String, String> entry : this.renameDbs.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                String[] stringArray = store.parseDbName(string);
                String[] stringArray2 = store.parseDbName(string2);
                DbCompat.renameDatabase(store.getEnvironment(), sTransaction, stringArray[0], stringArray[1], stringArray2[0], stringArray2[1]);
            }
        }
        finally {
            if (sTransaction != null) {
                DbCompat.setImportunate(sTransaction, bl);
            }
        }
    }

    int evolveRequiredKeyField(Format format, Format format2, FieldInfo fieldInfo, FieldInfo fieldInfo2) {
        int n = 0;
        String string = fieldInfo.getName();
        String string2 = "primary key field or composite key class field: " + string;
        if (fieldInfo2 == null) {
            this.addMissingMutation(format, format2, "Field is missing and deletion is not allowed for a " + string2);
            return 2;
        }
        Deleter deleter = this.mutations.getDeleter(format.getClassName(), format.getVersion(), string);
        if (deleter != null) {
            this.addInvalidMutation(format, format2, deleter, "Deleter is not allowed for a " + string2);
            return 2;
        }
        Converter converter = this.mutations.getConverter(format.getClassName(), format.getVersion(), string);
        if (converter != null) {
            this.addInvalidMutation(format, format2, converter, "Converter is not allowed for a " + string2);
            return 2;
        }
        Renamer renamer = this.mutations.getRenamer(format.getClassName(), format.getVersion(), string);
        String string3 = fieldInfo2.getName();
        if (renamer != null) {
            if (!renamer.getNewName().equals(string3)) {
                this.addInvalidMutation(format, format2, converter, "Converter is not allowed for a " + string2);
                return 2;
            }
            n = 1;
        } else if (!string.equals(string3)) {
            this.addMissingMutation(format, format2, "Renamer is required when field name is changed from: " + string + " to: " + string3);
            return 2;
        }
        Format format3 = fieldInfo.getType();
        if (!this.evolveFormat(format3)) {
            return 2;
        }
        Format format4 = format3.getLatestVersion();
        if (format3 != format4) {
            n = 1;
        }
        Format format5 = fieldInfo2.getType();
        if (format4.getClassName().equals(format5.getClassName())) {
            return n;
        }
        if (format4.getWrapperFormat() != null && format4.getWrapperFormat().getId() == format5.getId() || format5.getWrapperFormat() != null && format5.getWrapperFormat().getId() == format4.getId()) {
            return 1;
        }
        this.addEvolveError(format, format2, "Type may not be changed for a primary key field or composite key class field", "Old field type: " + format4.getClassName() + " is not compatible with the new type: " + format5.getClassName() + " for field: " + string);
        return 2;
    }
}

