/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class LongBinding
extends TupleBinding<Long> {
    private static final int LONG_SIZE = 8;

    @Override
    public Long entryToObject(TupleInput tupleInput) {
        return tupleInput.readLong();
    }

    @Override
    public void objectToEntry(Long l, TupleOutput tupleOutput) {
        tupleOutput.writeLong(l);
    }

    @Override
    protected TupleOutput getTupleOutput(Long l) {
        return LongBinding.sizedOutput();
    }

    public static long entryToLong(SDatabaseEntry sDatabaseEntry) {
        return LongBinding.entryToInput(sDatabaseEntry).readLong();
    }

    public static void longToEntry(long l, SDatabaseEntry sDatabaseEntry) {
        LongBinding.outputToEntry(LongBinding.sizedOutput().writeLong(l), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

