/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;
import java.math.BigDecimal;

public class BigDecimalBinding
extends TupleBinding<BigDecimal> {
    @Override
    public BigDecimal entryToObject(TupleInput tupleInput) {
        return tupleInput.readBigDecimal();
    }

    @Override
    public void objectToEntry(BigDecimal bigDecimal, TupleOutput tupleOutput) {
        tupleOutput.writeBigDecimal(bigDecimal);
    }

    @Override
    protected TupleOutput getTupleOutput(BigDecimal bigDecimal) {
        return BigDecimalBinding.sizedOutput(bigDecimal);
    }

    public static BigDecimal entryToBigDecimal(SDatabaseEntry sDatabaseEntry) {
        return BigDecimalBinding.entryToInput(sDatabaseEntry).readBigDecimal();
    }

    public static void bigDecimalToEntry(BigDecimal bigDecimal, SDatabaseEntry sDatabaseEntry) {
        BigDecimalBinding.outputToEntry(BigDecimalBinding.sizedOutput(bigDecimal).writeBigDecimal(bigDecimal), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput(BigDecimal bigDecimal) {
        int n = TupleOutput.getBigDecimalMaxByteLength(bigDecimal);
        return new TupleOutput(new byte[n]);
    }
}

