#! /bin/sh
#
# Build the configuration file for test 3 --
#	We do this work in the shell script because we have to fill in
#	lots of shell variables.

        if [ $1 == 1 ]; then 
	    IPCKEY=200104
	else
	    IPCKEY=200105
	fi
	MACHINE_NAME=`uname -n`
	cat > $RUN/config/ubb.cfg << END_OF_UBB_FILE
*RESOURCES
IPCKEY		$IPCKEY
DOMAINID	domain3
MASTER		cluster3
MAXACCESSERS	16
MAXSERVERS	6
MAXSERVICES	16
MODEL		SHM
LDBAL		N

*MACHINES
DEFAULT:
		APPDIR="$APPDIR"
		TUXCONFIG="$TUXCONFIG"
		TLOGDEVICE="$TLOGDEVICE"
		TUXDIR="$TUXDIR"
# Machine name is 30 characters max
"$MACHINE_NAME"	LMID=cluster3

*GROUPS
# Group name is 30 characters max
group_tm	LMID=cluster3 GRPNO=1 TMSNAME=DBRM TMSCOUNT=2 OPENINFO="BERKELEY-DB:$RUN/data"

*SERVERS
DEFAULT:
		CLOPT="-A"
		MINDISPATCHTHREADS=1
		MAXDISPATCHTHREADS=8

# Server name is 78 characters max (same for any pathname)
server1		SRVGRP=group_tm SRVID=1 MAXGEN=4 RESTART=Y
server2		SRVGRP=group_tm SRVID=2 MAXGEN=4 RESTART=Y

*SERVICES
DEFAULT:
		SVCTIMEOUT=20
# Service name is 15 characters max
# server1
TestThread1
# server2
TestThread2
END_OF_UBB_FILE
	tmloadcf -y $RUN/config/ubb.cfg
