We're proud to announce the new feature release of darktable, 3.8.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-3.8.0](https://github.com/darktable-org/darktable/releases/tag/release-3.8.0).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. the checksums are:

```
$ sha256sum darktable-3.8.0.tar.xz
??? darktable-3.8.0.tar.xz
$ sha256sum darktable-3.8.0.dmg
??? darktable-3.8.0.dmg
$ sha256sum darktable-3.8.0.exe
??? darktable-3.8.0.exe
```

When updating from the currently stable 3.6.x series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will not be usable with 3.6.x any more.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

- Almost 3915 commits to darktable+rawspeed since 3.6
- 571 pull requests handled
- 265 issues closed

## The Big Ones

- The keyboard shortcut system has been entirely reworked and extended to allow you
  to control darktable with other devices, for example, MIDI devices
  and game controllers. Standard keyboard/mouse shortcuts can now make use
  of mouse movements (horizontal, vertical, diagonal) as well as multiple
  button/key presses and short or long presses/clicks.

  Please note that any shortcuts you have previously created are not transferred
  to the new functionality and will need to be redefined in darktable 3.8.

- New diffuse and sharpen module, allowing to simulate or to revert
  diffusion processes to reconstruct images from lens blur, hazing,
  sensor low-pass filter, or noise. It can also be used to simulate
  watercolor smudges, increase local contrast, simulate blooming or
  apply surface blur. Special rules can be defined to specifically
  diffuse across or along edges, as well as to avoid sharpening or
  blurring them.

- New scene-referred blurs module, to synthesize motion and lens blurs in a parametric
  and physically-accurate way. It lets you define the motion path or the lens
  diaphragm and then generates the corresponding blur.

- Perspective correction module has been renamed to rotate and perspective
  and now allows you to manually define correction settings by drawing lines
  or rectangles on the image (replicating keystone correction functionality
  from the deprecated crop and rotate module)

- Added support for multiple images in the print view. The page can be
  filled with multiple areas, each of which can be moved around and placed on
  the page with the ability to snap to a grid for precision.

- A new LMMSE demosaic algorithm has been introduced. This algorithm is particularly
  suited to high ISO and/or noisy images.

- The composition guides from the crop module are now available globally and do
  not require the crop module to be activated.

- The Canon raw CR3 format is now supported (see list of supported cameras in the
  section below). This support is done by LibRaw and requires at least exiv2 version
  0.27.4 with BMFF support activated.

- The color checker profiling tool, introduced in darktable 3.4 as part of the
  color calibration module, is now normalized patch-wise in exposure to discard the effect
  of uneven lighting and fall-off when shooting color checkers hand-held and on-location.
  This robustly decreases the residual average dE after calibration and noticeably
  helps to recover natural dark blues while preventing yellow shifts in highlights.

## Other New Features And Changes

- The denoise (profiled) module now uses wavelets mode by default and its default
  settings in Y0U0V0 mode have been improved.

- Flip buttons have been added to the orientation module (functionality moved
  from crop and rotate).

- Background jobs handling has been removed from preferences.

- Much of the SSE-specific code has been removed, since compiler-generated code
  is usually faster.

- The darktable-generate-cache script now displays filenames and image ids.

- File name matches in the collections module are now faster.

- Mask handling is faster.

- Processing module order can now be automatically applied based on the image
  properties.

- Folder status is properly refreshed when a mount is changed.

- An area color picker is selectable by using a <kbd>Right-Click</kbd> in
  addition to the existing <kbd>Ctrl+click</kbd> action.

- Substitution variables have been added for image dimensions as follows:
  $(SENSOR_HEIGHT) and $(SENSOR_WIDTH) for the absolute pixel
  dimensions of the sensor; $(MAX_HEIGHT) and $(MAX_WIDTH) for the raw
  image size; and $(EXPORT_HEIGHT) and $(EXPORT_WIDTH) for the
  post-cropping final image size.

- More work on code speed-up in many different routines ensuring
  better vectorization and/or OpenMP definition. Notably, the
  split-toning, haze removal and soften modules have been improved.

- The beginner preset in module groups now takes the chosen workflow
  (display or scene referred) into account.

- The quick access panel now takes the chosen workflow
  (display or scene referred) into account.

- New sorting options based on capture, import, modification,
  last export and last print times.

- Tooltip for raster mask now includes source module information.

- The following modules have been deprecated:

  - Crop & rotate - the features of this module are now shared between the crop,
    orientation, and rotate and perspective modules.

    Note that the new crop module is now placed after the retouch module
    to ensure that the full image can be used as a source area.

- A new option has been added to allow you to choose when to start writing
  changes to the XMP sidecar files. Choose to (a) never write XMP,
  (b) write XMP as soon as the image is imported; or
  (c) write XMP only after the user has edited the image in the darkroom view.

- Timezone entry has been improved in the geotagging module.

- A new preference has been added to choose the number of recent collections to display.

- Rating support has been added to the collections module making possible to create
  presets, for example, to select the best images of 2021.

- PNG files are now supported in the watermark module.

- Minor usability improvements have been made to the tone equalizer,
  ensuring that the cursor is shown on focus and the module is activated on scroll.

- The values in the global color picker module are now selectable.

- HSV has been added as an option in the global color picker module.

- the color scheme of the timeline is improved.

- The scopes module (previously named histogram) can be moved to the
  left panel.

- Improved color rendering for waveform and parade scopes.

- A new vertical waveform scope option has been added.

- Live samples can now be displayed in the vectorscope.

- An RYB option has been added to the vectorscope.

- The lut3d module has been moved after filmic.

- The automatic mask tuning has been improved in the tone equalizer module.

- Tiling has been enabled in the color balance rgb, diffuse and filmic rgb modules
  to allow very large images to be processed.

- When scanning for updated XMP files, the synchronization window has been improved
  to offer more choices as to how the database/XMP files should be updated.

- Added read support for HEIF/HEIC file format.

- Added support for ARM64/Apple M1 as a build target.

- Added a preference to invert the behavior of mouse scroll up/down on drawn
  mask attributes. At the same time, and for consistency, the scroll-up action has been
  set to increase all mask attributes by default.

- Added timestamp in camera import dialog for consistency with other
  import dialog.

- The current module order is now shown in the module order module header to
  save space in the GUI.

- The split toning module now displays the hue in degree for consistency
  with other modules.

- Rejected images in the lighttable view are now dimmed for clarity.

- The last selected Piwigo album is now remembered in the export module.

- New "magic wand" icons are now used for the auto-tune actions in
  the tone equalizer module.

- For advanced users and developers, OpenCL build options are now exposed in
  darktablerc.

- The "module order" entry is now moved to the end of the copy/paste dialog
  for better usability, as this option is rarely used.

- The collections module now offers some new presets based on image time to
  complement the existing presets based on the import time.

- Add a borderless requirement indicator in the print module when the user's
  selected margins are below the hardware margins.

- Add an option to show all modules in the history into the active
  module group regardeless of whether or not they are currently
  enabled.

- Add a search box in preset preferences and shortcuts.

- Improved curve handling in filmic. Curve should be easier to control, as
  some side-effects of some parameters on others have been eliminated.

## Bug Fixes

- Multiple memory leaks have been fixed.

- Fixed green equilibration in RCD CPU code path.

- Select the best illuminant for DNG images.

- When trying to enter a view that cannot be used (like the tethering view
  where no camera is attached), make sure to reset the combobox back to
  the previous view.

- Fix calibration optimizations for delta E in Channel Mixer RGB module.

- Fix focus peaking, which was in some cases displaying some wrong
  random pixels on the borders.

- Fix refresh when pasting the whole or part of history.

- Fix possible uninitialized-data access in RCD demosaic.

- Update metadata fields when applying a preset.

- Fix creation of liquify interpolated path to be closer to what the user
  would expect.

- Multiple Windows PATH specific issues have been fixed. Also, UNC
  path-names are now supported.

- Make sure RAW+Jpeg files keep the same filename during copy & import.

- Add some consistency to the drawn shape opacity increase/decrease, which was
  working in the opposite way to the other mask controls.

- Invert liquify strength vector rotation for consistency.

- Make metadata and tagging consistent regarding the current selection.

- Fix some rounding errors in masks with sharp corners, which were creating
  discontinuities in the mask area.

- Fix the image loader flag, which was not properly set at import time.

- Fix possible wrong setting in Color Calibration when switching from
  Jpeg to RAW files.

- Fix a rare but possible wrong White Balance just after importing a
  picture or while resetting the development history.

## Lua

- Moved from Lua 5.3 to Lua 5.4

- Lua API is now 8.0.0

- Added darktable.print_toast() and darktable.print_hinter() functions
  to print toast and hinter messages respectively

- Added is_altered() field to dt_lua_image data type to determine if
  and image has been altered since being imported

- Added generate_cache() function to the dt_lua_image data type so
  that a mipmap cache image can be generated without having to run
  darktable-generate-cache

- Added function darktable.gui.libs.snapshots.clear_snapshots() to delete any snapshots.

- Added event darkroom-image-loaded that is triggered when an image is
  loaded into darkroom view.  The image is returned.

- Added event darkroom-image-history-changed that is triggered when an
  the image history is changed in darkroom view.  The image is
  returned.

## Notes

- The 3.8.x series of darktable releases will be the last which
  supports macOS 10.7 and building with Xcode 11.

  The next major release will require at least macOS 10.14 to run and
  Xcode 12 to build.

- The module deprecated in 3.4 have now been removed from the
  deprecated module group. The modules are: Zone System, Invert,
  Channel Mixer, Global Tonemap, Relight, Tonemap, Vibrance and Basic
  Adjustements.

## Changed Dependencies

- Move from Lua 5.3 to 5.4.

## RawSpeed changes


## Camera support, compared to 3.6

### Base Support

- Canon EOS R
- Canon EOS RP
- Canon EOS R5
- Canon EOS R6
- Canon EOS 250D
- Canon EOS 850D
- Canon EOS 90D
- Canon EOS 1D X Mark III
- Canon EOS M6 Mark II
- Canon EOS M50
- Canon EOS M50 Mark II
- Canon EOS M200
- Canon PowerShot G5 X Mark II
- Canon PowerShot G7 X Mark III
- Fujifilm GFX50S II (compressed)
- Leica C (Typ 112) (3:2)
- Leica Digilux 3 (4:3)
- Leica M10 (dng)
- Ricoh GR II
- Sony DSC-HX95
- Sony ILCE-7M4
- Sony ZV-E10

### White Balance Presets

- Canon EOS R (with fine-tuning)
- Canon EOS RP (with fine-tuning)
- Canon EOS R5 (with fine-tuning)
- Canon EOS R6
- Canon EOS M50 (with fine-tuning)
- Ricoh GR II

### Noise Profiles

- Canon EOS R
- Canon EOS RP
- Canon EOS R5
- Canon EOS R6
- Fujifilm X100V
- Leica D-Lux 7
- Leica M10
- Leica SL (Typ 601)
- Panasonic DC-S5
- Panasonic DC-FZ91
- Panasonic DC-FZ92
- Panasonic DC-FZ93
- Panasonic DC-TZ90
- Panasonic DC-TZ91
- Panasonic DC-ZS70

### Custom Color Matrices

### Suspended Support

No samples on raw.pixls.us

- Canon EOS M2
- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm FinePix HS50EXR
- Fujifilm FinePix S6000fd
- Fujifilm FinePix S9600fd
- Fujifilm IS-1
- GoPro FUSION
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Leica D-LUX 6
- Minolta DiMAGE 5
- Nikon 1 J4
- Nikon 1 S1
- Nikon Coolpix P7700
- Nikon D1H
- Nikon D2H
- Nikon D3S
- Olympus E-10
- Olympus SP320
- Olympus SP570UZ
- Panasonic DMC-FX150
- Panasonic DMC-G2
- Pentax K200D
- Pentax K2000
- Pentax Q10
- Phase One IQ250
- Samsung GX10
- Samsung GX20
- Samsung NX5
- Samsung NX10
- Samsung NX11
- Samsung NX20
- Samsung NX2000
- Samsung EK-GN120
- Samsung SM-G920F
- Samsung SM-G935F
- Sinar Hy6/ Sinarback eXact
- Sony DSLR-A380
- Sony DSLR-A560
- ST Micro STV680

## Translations

- German
- Esperanto
- European Spanish
- Finnish
- French
- Hebrew
- Hungarian
- Italian
- Japanese
- Polish
- Brazilian Portuguese
- Slovenian
- Ukrainian
- Chinese - China
