/*
	daapd 0.2.4, a server for the DAA protocol
	(c) deleet 2003, Alexander Oberdoerster

	database output (songs, containers, container items)
	

	daapd is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	daapd is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with daapd; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "types.h"
#include "dboutput.h"
#include <daap/tagoutput.h>

using namespace std;

// song output

TagOutput& operator << ( TagOutput& out, const Song& song ) {
	out << Filtered( song, ITEMID | ITEMNAME | ITEMKIND | PERSISTENTID |
		SONGALBUM | SONGARTIST	| SONGBITRATE | SONGBEATSPERMINUTE |
		SONGCOMMENT | SONGCOMPILATION | SONGCOMPOSER | SONGDATEADDED |
		SONGDATEMODIFIED | SONGDISCCOUNT | SONGDISCNUMBER | SONGDISABLED |
		SONGEQPRESET | SONGFORMAT | SONGGENRE | SONGDESCRIPTION |
		SONGRELATIVEVOLUME | SONGSAMPLERATE | SONGSIZE | SONGSTARTTIME |
		SONGSTOPTIME | SONGTIME | SONGTRACKCOUNT | SONGTRACKNUMBER |
		SONGUSERRATING | SONGYEAR | SONGDATAKIND | SONGDATAURL |
		NORMVOLUME );

	return( out );
}

TagOutput& operator << ( TagOutput& out, const Filter<Song>& f ) {
	out << 
	Tag('mlit');
	if( f.fields & ITEMKIND ) {
		out <<
		Tag('mikd') <<
			f.var.kind <<
		end;
	}
	if( f.fields & SONGDATAKIND ) {
		out <<
		Tag('asdk') <<
			f.var.datakind <<
		end;
	}
	if( f.fields & ITEMNAME ) {
		out <<
		Tag('minm') <<
			f.var.name <<
		end;
	}
	if( f.fields & ITEMID ) {
		out <<
		Tag('miid') <<
			f.var.id <<
		end;
	}
	if( f.fields & PERSISTENTID ) {
		//
	}
	if( f.fields & SONGALBUM ) {
		out <<
		Tag('asal') <<
			f.var.album <<
		end;
	}
	if( f.fields & SONGARTIST ) {
		out <<
		Tag('asar') <<
			f.var.artist <<
		end;
	}
	if( f.fields & SONGBITRATE ) {
		out <<
		Tag('asbr') <<
			f.var.bitrate <<
		end;
	}
	if( f.fields & SONGBEATSPERMINUTE ) {
		out <<
		Tag('asbt') <<
			f.var.bpm <<
		end;
	}
	if( f.fields & SONGCOMMENT ) {
		out <<
		Tag('ascm') <<
			f.var.comment <<
		end;
	}
	if( f.fields & SONGCOMPILATION ) {
		out <<
		Tag('asco') <<
			f.var.compilation <<
		end;
	}
	if( f.fields & SONGCOMPOSER ) {
		out <<
		Tag('ascp') <<
			f.var.composer <<
		end;
	}
	if( f.fields & SONGDATEADDED ) {
		out <<
		Tag('asda') <<
			(u32) f.var.dateadded <<
		end;
	}
	if( f.fields & SONGDATEMODIFIED ) {
		out <<
		Tag('asdm') <<
			(u32) f.var.datemodified <<
		end;
	}
	if( f.fields & SONGDISCCOUNT ) {
		out <<
		Tag('asdc') <<
			f.var.disccount <<
		end;
	}
	if( f.fields & SONGDISCNUMBER ) {
		out <<
		Tag('asdn') <<
			f.var.discnumber <<
		end;
	}
	if( f.fields & SONGDISABLED ) {
		out <<
		Tag('asdb') <<
			f.var.disabled <<
		end;
	}
	if( f.fields & SONGEQPRESET ) {
		//
	}
	if( f.fields & SONGFORMAT ) {
		out <<
		Tag('asfm') <<
			f.var.format <<
		end;
	}
	if( f.fields & SONGGENRE ) {
		out <<
		Tag('asgn') <<
			f.var.genre <<
		end;
	}
	if( f.fields & SONGDESCRIPTION ) {
		out <<
		Tag('asdt') <<
			f.var.description <<
		end;
	}
	if( f.fields & SONGRELATIVEVOLUME ) {
		out <<
		Tag('asrv') <<
			f.var.relativevolume <<
		end;
	}
	if( f.fields & SONGSAMPLERATE ) {
		out <<
		Tag('assr') <<
			f.var.samplerate <<
		end;
	}
	if( f.fields & SONGSIZE ) {
		out <<
		Tag('assz') <<
			f.var.size <<
		end;
	}
	if( f.fields & SONGSTARTTIME ) {
		out <<
		Tag('asst') <<
			f.var.starttime <<
		end;
	}
	if( f.fields & SONGSTOPTIME ) {
		out <<
		Tag('assp') <<
			f.var.stoptime <<
		end;
	}
	if( f.fields & SONGTIME ) {
		out <<
		Tag('astm') <<
			f.var.time <<
		end;
	}
	if( f.fields & SONGTRACKCOUNT ) {
		out <<
		Tag('astc') <<
			f.var.trackcount <<
		end;
	}
	if( f.fields & SONGTRACKNUMBER ) {
		out <<
		Tag('astn') <<
			f.var.tracknumber <<
		end;
	}
	if( f.fields & SONGUSERRATING ) {
		out <<
		Tag('asur') <<
			f.var.userrating <<
		end;
	}
	if( f.fields & SONGYEAR ) {
		out <<
		Tag('asyr') <<
			f.var.year <<
		end;
	}
	if( f.fields & SONGDATAURL ) {
		out <<
		Tag('asul') <<
			f.var.dataurl <<
		end;
	}
	if( f.fields & NORMVOLUME ) {
		//
	}
	out <<
	end;
	return( out );
}


// container output

TagOutput& operator << ( TagOutput& out, const Filter<Container>& f ) {
	out <<
	Tag('mlit');
		if ( f.fields & ITEMID ) {
			out <<
			Tag('miid') <<
				f.var.id <<
			end;
		}
		if ( f.fields & PERSISTENTID ) {
			//
		}
		if ( f.fields & ITEMNAME ) {
			out <<
			Tag('minm') <<
				f.var.name <<
			end;
		}
		out <<
		Tag('mimc') <<
			(u32) f.var.items.size() <<
		end <<
	end;
	return( out );
}

TagOutput& operator << ( TagOutput& out, const Container& cont ) {
	out << Filtered( cont, ITEMID | ITEMKIND | ITEMNAME | SMARTPLAYLIST );
	return( out );
}


// container output (list items)

TagOutput& operator << ( TagOutput& out, const Filter< std::map<u32, u32> >& f ) {
	map<u32, u32>::const_iterator iter = f.var.begin();
	while( iter != f.var.end() ) {
		out <<
		Tag('mlit') <<
			Tag('mikd') <<
				( (u8) 2 ) <<
			end <<
			Tag('miid') <<
				( (u32) iter->second ) <<
			end <<
			Tag('mcti') <<
				( (u32) iter->first ) <<
			end <<
		end;
		++iter;
	}
	
	return out;
}

TagOutput& operator << ( TagOutput& out, const std::map<u32, u32> items ) {
	out << Filtered( items, ITEMID || ITEMKIND || CONTAINERITEMID );
	return( out );
}
