/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicLineFormatter
implements LineFormatter {
    @Deprecated
    public static final BasicLineFormatter DEFAULT = new BasicLineFormatter();
    public static final BasicLineFormatter INSTANCE = new BasicLineFormatter();

    protected CharArrayBuffer initBuffer(CharArrayBuffer charBuffer) {
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 != null) {
            buffer2.clear();
        } else {
            buffer2 = new CharArrayBuffer(64);
        }
        return buffer2;
    }

    public static String formatProtocolVersion(ProtocolVersion version, LineFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).appendProtocolVersion(null, version).toString();
    }

    @Override
    public CharArrayBuffer appendProtocolVersion(CharArrayBuffer buffer2, ProtocolVersion version) {
        Args.notNull(version, "Protocol version");
        CharArrayBuffer result = buffer2;
        int len = this.estimateProtocolVersionLen(version);
        if (result == null) {
            result = new CharArrayBuffer(len);
        } else {
            result.ensureCapacity(len);
        }
        result.append(version.getProtocol());
        result.append('/');
        result.append(Integer.toString(version.getMajor()));
        result.append('.');
        result.append(Integer.toString(version.getMinor()));
        return result;
    }

    protected int estimateProtocolVersionLen(ProtocolVersion version) {
        return version.getProtocol().length() + 4;
    }

    public static String formatRequestLine(RequestLine reqline, LineFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatRequestLine(null, reqline).toString();
    }

    @Override
    public CharArrayBuffer formatRequestLine(CharArrayBuffer buffer2, RequestLine reqline) {
        Args.notNull(reqline, "Request line");
        CharArrayBuffer result = this.initBuffer(buffer2);
        this.doFormatRequestLine(result, reqline);
        return result;
    }

    protected void doFormatRequestLine(CharArrayBuffer buffer2, RequestLine reqline) {
        String method = reqline.getMethod();
        String uri = reqline.getUri();
        int len = method.length() + 1 + uri.length() + 1 + this.estimateProtocolVersionLen(reqline.getProtocolVersion());
        buffer2.ensureCapacity(len);
        buffer2.append(method);
        buffer2.append(' ');
        buffer2.append(uri);
        buffer2.append(' ');
        this.appendProtocolVersion(buffer2, reqline.getProtocolVersion());
    }

    public static String formatStatusLine(StatusLine statline, LineFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatStatusLine(null, statline).toString();
    }

    @Override
    public CharArrayBuffer formatStatusLine(CharArrayBuffer buffer2, StatusLine statline) {
        Args.notNull(statline, "Status line");
        CharArrayBuffer result = this.initBuffer(buffer2);
        this.doFormatStatusLine(result, statline);
        return result;
    }

    protected void doFormatStatusLine(CharArrayBuffer buffer2, StatusLine statline) {
        int len = this.estimateProtocolVersionLen(statline.getProtocolVersion()) + 1 + 3 + 1;
        String reason = statline.getReasonPhrase();
        if (reason != null) {
            len += reason.length();
        }
        buffer2.ensureCapacity(len);
        this.appendProtocolVersion(buffer2, statline.getProtocolVersion());
        buffer2.append(' ');
        buffer2.append(Integer.toString(statline.getStatusCode()));
        buffer2.append(' ');
        if (reason != null) {
            buffer2.append(reason);
        }
    }

    public static String formatHeader(Header header, LineFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatHeader(null, header).toString();
    }

    @Override
    public CharArrayBuffer formatHeader(CharArrayBuffer buffer2, Header header) {
        CharArrayBuffer result;
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            result = ((FormattedHeader)header).getBuffer();
        } else {
            result = this.initBuffer(buffer2);
            this.doFormatHeader(result, header);
        }
        return result;
    }

    protected void doFormatHeader(CharArrayBuffer buffer2, Header header) {
        String name2 = header.getName();
        String value = header.getValue();
        int len = name2.length() + 2;
        if (value != null) {
            len += value.length();
        }
        buffer2.ensureCapacity(len);
        buffer2.append(name2);
        buffer2.append(": ");
        if (value != null) {
            buffer2.ensureCapacity(buffer2.length() + value.length());
            for (int valueIndex = 0; valueIndex < value.length(); ++valueIndex) {
                char valueChar = value.charAt(valueIndex);
                if (valueChar == '\r' || valueChar == '\n' || valueChar == '\f' || valueChar == '\u000b') {
                    valueChar = ' ';
                }
                buffer2.append(valueChar);
            }
        }
    }
}

