/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import org.codehaus.plexus.util.MatchPattern;

public class MatchPatterns {
    private final MatchPattern[] patterns;

    private MatchPatterns(MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public boolean matches(String name2, boolean isCaseSensitive) {
        String[] tokenized = MatchPattern.tokenizePathToString(name2, File.separator);
        return this.matches(name2, tokenized, isCaseSensitive);
    }

    public boolean matches(String name2, String[] tokenizedName, boolean isCaseSensitive) {
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i = 0; i < tokenizedName.length; ++i) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
        }
        return this.matches(name2, tokenizedNameChar, isCaseSensitive);
    }

    public boolean matches(String name2, char[][] tokenizedNameChar, boolean isCaseSensitive) {
        for (MatchPattern pattern : this.patterns) {
            if (!pattern.matchPath(name2, tokenizedNameChar, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPatternStart(String name2, boolean isCaseSensitive) {
        for (MatchPattern includesPattern : this.patterns) {
            if (!includesPattern.matchPatternStart(name2, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static MatchPatterns from(String ... sources) {
        int length = sources.length;
        MatchPattern[] result = new MatchPattern[length];
        for (int i = 0; i < length; ++i) {
            result[i] = MatchPattern.fromString(sources[i]);
        }
        return new MatchPatterns(result);
    }

    public static MatchPatterns from(Iterable<String> strings) {
        return new MatchPatterns(MatchPatterns.getMatchPatterns(strings));
    }

    private static MatchPattern[] getMatchPatterns(Iterable<String> items) {
        ArrayList<MatchPattern> result = new ArrayList<MatchPattern>();
        for (String string2 : items) {
            result.add(MatchPattern.fromString(string2));
        }
        return result.toArray(new MatchPattern[0]);
    }
}

