/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.sec.dispatcher;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.model.Config;
import org.sonatype.plexus.components.sec.dispatcher.model.ConfigProperty;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;
import org.sonatype.plexus.components.sec.dispatcher.model.io.xpp3.SecurityConfigurationXpp3Reader;

public class SecUtil {
    public static final String PROTOCOL_DELIM = "://";
    public static final int PROTOCOL_DELIM_LEN = "://".length();
    public static final String[] URL_PROTOCOLS = new String[]{"http", "https", "dav", "file", "davs", "webdav", "webdavs", "dav+http", "dav+https"};

    public static SettingsSecurity read(String location, boolean cycle2) throws SecDispatcherException {
        if (location == null) {
            throw new SecDispatcherException("location to read from is null");
        }
        InputStream in = null;
        try {
            in = SecUtil.toStream(location);
            SettingsSecurity sec = new SecurityConfigurationXpp3Reader().read(in);
            in.close();
            if (cycle2 && sec.getRelocation() != null) {
                SettingsSecurity settingsSecurity = SecUtil.read(sec.getRelocation(), true);
                return settingsSecurity;
            }
            SettingsSecurity settingsSecurity = sec;
            return settingsSecurity;
        }
        catch (Exception e2) {
            throw new SecDispatcherException(e2);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InputStream toStream(String resource2) throws IOException {
        if (resource2 == null) {
            return null;
        }
        int ind = resource2.indexOf(PROTOCOL_DELIM);
        if (ind > 1) {
            String protocol = resource2.substring(0, ind);
            resource2 = resource2.substring(ind + PROTOCOL_DELIM_LEN);
            for (String p : URL_PROTOCOLS) {
                if (!protocol.regionMatches(true, 0, p, 0, p.length())) continue;
                return new URL(p + PROTOCOL_DELIM + resource2).openStream();
            }
        }
        return new FileInputStream(resource2);
    }

    public static Map<String, String> getConfig(SettingsSecurity sec, String name2) {
        if (name2 == null) {
            return null;
        }
        List<Config> cl = sec.getConfigurations();
        if (cl == null || cl.isEmpty()) {
            return null;
        }
        for (Config cf : cl) {
            if (!name2.equals(cf.getName())) continue;
            List<ConfigProperty> pl = cf.getProperties();
            if (pl == null || pl.isEmpty()) {
                return null;
            }
            HashMap<String, String> res2 = new HashMap<String, String>(pl.size());
            for (ConfigProperty p : pl) {
                res2.put(p.getName(), p.getValue());
            }
            return res2;
        }
        return null;
    }
}

