/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicLineParser
implements LineParser {
    @Deprecated
    public static final BasicLineParser DEFAULT = new BasicLineParser();
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    protected final ProtocolVersion protocol;

    public BasicLineParser(ProtocolVersion proto) {
        this.protocol = proto != null ? proto : HttpVersion.HTTP_1_1;
    }

    public BasicLineParser() {
        this(null);
    }

    public static ProtocolVersion parseProtocolVersion(String value, LineParser parser) throws ParseException {
        Args.notNull(value, "Value");
        CharArrayBuffer buffer2 = new CharArrayBuffer(value.length());
        buffer2.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? parser : INSTANCE).parseProtocolVersion(buffer2, cursor);
    }

    @Override
    public ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer2, ParserCursor cursor) throws ParseException {
        int minor;
        int major;
        Args.notNull(buffer2, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        this.skipWhitespace(buffer2, cursor);
        int i = cursor.getPos();
        if (i + protolength + 4 > indexTo) {
            throw new ParseException("Not a valid protocol version: " + buffer2.substring(indexFrom, indexTo));
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer2.charAt(i + j) == protoname.charAt(j);
        }
        if (ok) {
            boolean bl = ok = buffer2.charAt(i + protolength) == '/';
        }
        if (!ok) {
            throw new ParseException("Not a valid protocol version: " + buffer2.substring(indexFrom, indexTo));
        }
        int period = buffer2.indexOf(46, i += protolength + 1, indexTo);
        if (period == -1) {
            throw new ParseException("Invalid protocol version number: " + buffer2.substring(indexFrom, indexTo));
        }
        try {
            major = Integer.parseInt(buffer2.substringTrimmed(i, period));
        }
        catch (NumberFormatException e2) {
            throw new ParseException("Invalid protocol major version number: " + buffer2.substring(indexFrom, indexTo));
        }
        i = period + 1;
        int blank = buffer2.indexOf(32, i, indexTo);
        if (blank == -1) {
            blank = indexTo;
        }
        try {
            minor = Integer.parseInt(buffer2.substringTrimmed(i, blank));
        }
        catch (NumberFormatException e3) {
            throw new ParseException("Invalid protocol minor version number: " + buffer2.substring(indexFrom, indexTo));
        }
        cursor.updatePos(blank);
        return this.createProtocolVersion(major, minor);
    }

    protected ProtocolVersion createProtocolVersion(int major, int minor) {
        return this.protocol.forVersion(major, minor);
    }

    @Override
    public boolean hasProtocolVersion(CharArrayBuffer buffer2, ParserCursor cursor) {
        int index2;
        Args.notNull(buffer2, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        String protoname = this.protocol.getProtocol();
        int protolength = protoname.length();
        if (buffer2.length() < protolength + 4) {
            return false;
        }
        if (index2 < 0) {
            index2 = buffer2.length() - 4 - protolength;
        } else if (index2 == 0) {
            for (index2 = cursor.getPos(); index2 < buffer2.length() && HTTP.isWhitespace(buffer2.charAt(index2)); ++index2) {
            }
        }
        if (index2 + protolength + 4 > buffer2.length()) {
            return false;
        }
        boolean ok = true;
        for (int j = 0; ok && j < protolength; ++j) {
            ok = buffer2.charAt(index2 + j) == protoname.charAt(j);
        }
        if (ok) {
            ok = buffer2.charAt(index2 + protolength) == '/';
        }
        return ok;
    }

    public static RequestLine parseRequestLine(String value, LineParser parser) throws ParseException {
        Args.notNull(value, "Value");
        CharArrayBuffer buffer2 = new CharArrayBuffer(value.length());
        buffer2.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? parser : INSTANCE).parseRequestLine(buffer2, cursor);
    }

    @Override
    public RequestLine parseRequestLine(CharArrayBuffer buffer2, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer2, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            this.skipWhitespace(buffer2, cursor);
            int i = cursor.getPos();
            int blank = buffer2.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ParseException("Invalid request line: " + buffer2.substring(indexFrom, indexTo));
            }
            String method = buffer2.substringTrimmed(i, blank);
            cursor.updatePos(blank);
            this.skipWhitespace(buffer2, cursor);
            i = cursor.getPos();
            blank = buffer2.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ParseException("Invalid request line: " + buffer2.substring(indexFrom, indexTo));
            }
            String uri = buffer2.substringTrimmed(i, blank);
            cursor.updatePos(blank);
            ProtocolVersion ver = this.parseProtocolVersion(buffer2, cursor);
            this.skipWhitespace(buffer2, cursor);
            if (!cursor.atEnd()) {
                throw new ParseException("Invalid request line: " + buffer2.substring(indexFrom, indexTo));
            }
            return this.createRequestLine(method, uri, ver);
        }
        catch (IndexOutOfBoundsException e2) {
            throw new ParseException("Invalid request line: " + buffer2.substring(indexFrom, indexTo));
        }
    }

    protected RequestLine createRequestLine(String method, String uri, ProtocolVersion ver) {
        return new BasicRequestLine(method, uri, ver);
    }

    public static StatusLine parseStatusLine(String value, LineParser parser) throws ParseException {
        Args.notNull(value, "Value");
        CharArrayBuffer buffer2 = new CharArrayBuffer(value.length());
        buffer2.append(value);
        ParserCursor cursor = new ParserCursor(0, value.length());
        return (parser != null ? parser : INSTANCE).parseStatusLine(buffer2, cursor);
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer buffer2, ParserCursor cursor) throws ParseException {
        Args.notNull(buffer2, "Char array buffer");
        Args.notNull(cursor, "Parser cursor");
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        try {
            int statusCode;
            ProtocolVersion ver = this.parseProtocolVersion(buffer2, cursor);
            this.skipWhitespace(buffer2, cursor);
            int i = cursor.getPos();
            int blank = buffer2.indexOf(32, i, indexTo);
            if (blank < 0) {
                blank = indexTo;
            }
            String s2 = buffer2.substringTrimmed(i, blank);
            for (int j = 0; j < s2.length(); ++j) {
                if (Character.isDigit(s2.charAt(j))) continue;
                throw new ParseException("Status line contains invalid status code: " + buffer2.substring(indexFrom, indexTo));
            }
            try {
                statusCode = Integer.parseInt(s2);
            }
            catch (NumberFormatException e2) {
                throw new ParseException("Status line contains invalid status code: " + buffer2.substring(indexFrom, indexTo));
            }
            i = blank;
            String reasonPhrase = i < indexTo ? buffer2.substringTrimmed(i, indexTo) : "";
            return this.createStatusLine(ver, statusCode, reasonPhrase);
        }
        catch (IndexOutOfBoundsException e3) {
            throw new ParseException("Invalid status line: " + buffer2.substring(indexFrom, indexTo));
        }
    }

    protected StatusLine createStatusLine(ProtocolVersion ver, int status, String reason) {
        return new BasicStatusLine(ver, status, reason);
    }

    public static Header parseHeader(String value, LineParser parser) throws ParseException {
        Args.notNull(value, "Value");
        CharArrayBuffer buffer2 = new CharArrayBuffer(value.length());
        buffer2.append(value);
        return (parser != null ? parser : INSTANCE).parseHeader(buffer2);
    }

    @Override
    public Header parseHeader(CharArrayBuffer buffer2) throws ParseException {
        return new BufferedHeader(buffer2);
    }

    protected void skipWhitespace(CharArrayBuffer buffer2, ParserCursor cursor) {
        int pos;
        int indexTo = cursor.getUpperBound();
        for (pos = cursor.getPos(); pos < indexTo && HTTP.isWhitespace(buffer2.charAt(pos)); ++pos) {
        }
        cursor.updatePos(pos);
    }
}

