# chgdebug.py - debug commands for cHg
#
# Copyright 2014 Yuya Nishihara <yuya@tcha.org>
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2 or any later version.

import sys

from mercurial import cmdutil, extensions

cmdtable = {}
command = cmdutil.command(cmdtable)
testedwith = '3.2'

@command('debugchguiattr', [], '', norepo=True)
def debugchguiattr(ui):
    """show ui attributes about terminal"""
    files = [
        ('stdin', sys.stdin),
        ('stdout', sys.stdout),
        ('stderr', sys.stderr),
        ('ui.fin', ui.fin),
        ('ui.fout', ui.fout),
        ('ui.ferr', ui.ferr),
        ]

    ui.write('color.mode: %s\n' % getattr(ui, '_colormode', None))
    try:
        progress = extensions.find('progress')
        ui.write('progress.shouldprint: %r\n' % progress.shouldprint(ui))
    except KeyError:
        pass
    ui.write('ui.formatted: %r\n' % ui.formatted())
    ui.write('ui.interactive: %r\n' % ui.interactive())
    ui.write('ui.isatty: %s\n'
             % ', '.join('%s=%r' % (n, ui._isatty(f)) for n, f in files))
    ui.write('ui.plain: %r, %s\n'
             % (ui.plain(), ', '.join('%s=%r' % (n, ui.plain(n))
                                      for n in ['alias', 'i18n'])))
    ui.write('ui.termwidth: %d\n' % ui.termwidth())
