;;; primdata.ss
;;; Copyright 1984-2017 Cisco Systems, Inc.
;;;
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;;
;;; http://www.apache.org/licenses/LICENSE-2.0
;;;
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

;;; r6rs features

(define-symbol-flags* ([libraries (rnrs) (rnrs arithmetic bitwise)] [flags primitive proc])
  (bitwise-not [sig [(sint) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-and [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (bitwise-ior [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (bitwise-xor [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (bitwise-if [sig [(sint sint sint) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-bit-count [sig [(sint) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-length [sig [(sint) -> (uint)]] [flags arith-op mifoldable discard])
  (bitwise-first-bit-set [sig [(sint) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-bit-set? [sig [(sint uint) -> (boolean)]] [flags pure mifoldable discard])
  (bitwise-copy-bit [sig [(sint uint bit) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-bit-field [sig [(sint sub-uint sub-uint) -> (uint)]] [flags arith-op mifoldable discard])
  (bitwise-copy-bit-field [sig [(sint sub-uint sub-uint sint) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-arithmetic-shift [sig [(sint sint) -> (sint)]] [flags arith-op mifoldable discard cp03])
  (bitwise-arithmetic-shift-left [sig [(sint uint) -> (sint)]] [flags arith-op mifoldable discard cp03])
  (bitwise-arithmetic-shift-right [sig [(sint uint) -> (sint)]] [flags arith-op mifoldable discard cp03])
  (bitwise-rotate-bit-field [sig [(sint sub-uint sub-uint sub-uint) -> (sint)]] [flags arith-op mifoldable discard])
  (bitwise-reverse-bit-field [sig [(sint sub-uint sub-uint) -> (sint)]] [flags arith-op mifoldable discard])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs arithmetic fixnums)] [flags primitive proc])
  (fixnum? [sig [(ptr) -> (boolean)]] [flags pure unrestricted cp02])
  (fixnum-width [sig [() -> (fixnum)]] [flags pure unrestricted true cp02])
  (least-fixnum [sig [() -> (fixnum)]] [flags pure unrestricted true cp02])
  (greatest-fixnum [sig [() -> (fixnum)]] [flags pure unrestricted true cp02])
  (fx<? [sig [(fixnum fixnum fixnum ...) -> (boolean)]] [flags pure cp02])    ; restricted to 2+ arguments
  (fx<=? [sig [(fixnum fixnum fixnum ...) -> (boolean)]] [flags pure cp02])   ; restricted to 2+ arguments
  (fx=? [sig [(fixnum fixnum fixnum ...) -> (boolean)]] [flags pure cp02])    ; restricted to 2+ arguments
  (fx>? [sig [(fixnum fixnum fixnum ...) -> (boolean)]] [flags pure cp02])    ; restricted to 2+ arguments
  (fx>=? [sig [(fixnum fixnum fixnum ...) -> (boolean)]] [flags pure cp02])   ; restricted to 2+ arguments
  (fxzero? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxnegative? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxpositive? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxeven? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxodd? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxmax [sig [(fixnum fixnum ...) -> (fixnum)]] [flags arith-op cp02])
  (fxmin [sig [(fixnum fixnum ...) -> (fixnum)]] [flags arith-op cp02])
  ((r6rs: fx*) [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op partial-folder])  ; restricted to 2 arguments
  ((r6rs: fx+) [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op partial-folder])  ; restricted to 2 arguments
  ((r6rs: fx-) [sig [(fixnum) (fixnum fixnum) -> (fixnum)]] [flags arith-op partial-folder])  ; restricted to 1 or 2 arguments
  (fxdiv-and-mod [sig [(fixnum fixnum) -> (fixnum fixnum)]] [flags discard cp03])
  (fxdiv [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxmod [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxdiv0-and-mod0 [sig [(fixnum fixnum) -> (fixnum fixnum)]] [flags discard])
  (fxdiv0 [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxmod0 [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fx+/carry [sig [(fixnum fixnum fixnum) -> (fixnum fixnum)]] [flags arith-op cp02])
  (fx-/carry [sig [(fixnum fixnum fixnum) -> (fixnum fixnum)]] [flags arith-op cp02])
  (fx*/carry [sig [(fixnum fixnum fixnum) -> (fixnum fixnum)]] [flags arith-op cp02])
  (fxnot [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxand [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxior [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxxor [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxif [sig [(fixnum fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxbit-count [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxlength [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxfirst-bit-set [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxbit-set? [sig [(fixnum sub-ufixnum) -> (boolean)]] [flags pure cp02])
  (fxcopy-bit [sig [(fixnum sub-ufixnum bit) -> (fixnum)]] [flags arith-op cp02])
  (fxbit-field [sig [(fixnum sub-ufixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02 cp03])
  (fxcopy-bit-field [sig [(fixnum sub-ufixnum sub-ufixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxarithmetic-shift [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxarithmetic-shift-left [sig [(fixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxarithmetic-shift-right [sig [(fixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxrotate-bit-field [sig [(fixnum sub-ufixnum sub-ufixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxreverse-bit-field [sig [(fixnum sub-ufixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs arithmetic flonums)] [flags keyword])
  (&no-infinities [flags])
  (&no-nans [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs arithmetic flonums)] [flags primitive proc])
  (flonum? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (real->flonum [sig [(real) -> (flonum)]] [flags arith-op mifoldable discard])
  (fl=? [sig [(flonum flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])             ; restricted to 2+ arguments
  (fl<? [sig [(flonum flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])             ; restricted to 2+ arguments
  (fl<=? [sig [(flonum flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])            ; restricted to 2+ arguments
  (fl>? [sig [(flonum flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])             ; restricted to 2+ arguments
  (fl>=? [sig [(flonum flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])            ; restricted to 2+ arguments
  (flinteger? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flzero? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flpositive? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flnegative? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flodd? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (fleven? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flfinite? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flinfinite? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flnan? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flmax [sig [(flonum flonum ...) -> (flonum)]] [flags arith-op mifoldable discard])
  (flmin [sig [(flonum flonum ...) -> (flonum)]] [flags arith-op mifoldable discard])
  (fl* [sig [(flonum ...) -> (flonum)]] [flags arith-op partial-folder])
  (fl+ [sig [(flonum ...) -> (flonum)]] [flags arith-op partial-folder])
  (fl- [sig [(flonum flonum ...) -> (flonum)]] [flags arith-op partial-folder])
  (fl/ [sig [(flonum flonum ...) -> (flonum)]] [flags arith-op partial-folder])
  (flabs [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (fldiv-and-mod [sig [(flonum flonum) -> (flonum flonum)]] [flags mifoldable discard])
  (fldiv [sig [(flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flmod [sig [(flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (fldiv0-and-mod0 [sig [(flonum flonum) -> (flonum flonum)]] [flags mifoldable discard])
  (fldiv0 [sig [(flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flmod0 [sig [(flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flnumerator [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (fldenominator [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flfloor [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flceiling [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (fltruncate [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flround [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flexp [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (fllog [sig [(flonum) (flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flsin [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flcos [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (fltan [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flasin [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flacos [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flatan [sig [(flonum) (flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flsqrt [sig [(flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (flexpt [sig [(flonum flonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (make-no-infinities-violation [sig [() -> (ptr)]] [flags pure unrestricted alloc])
  (no-infinities-violation? [sig [(ptr) -> (ptr)]] [flags pure unrestricted mifoldable discard])
  (make-no-nans-violation [sig [() -> (ptr)]] [flags pure unrestricted alloc])
  (no-nans-violation? [sig [(ptr) -> (ptr)]] [flags pure unrestricted mifoldable discard])
  (fixnum->flonum [sig [(fixnum) -> (flonum)]] [flags arith-op cp02])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs base) (rnrs exceptions)] [flags keyword])
  (=> [flags ieee r5rs])
  (else [flags ieee r5rs])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs base) (rnrs syntax-case)] [flags keyword])
  (_ [flags r5rs])
  (... [flags r5rs])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs base)] [flags keyword])
  (assert [flags])
  (define [flags ieee r5rs])
  (define-syntax [flags r5rs])
  (if [flags ieee r5rs])
  (quote [flags ieee r5rs])
  (lambda [flags ieee r5rs])
  (set! [flags ieee r5rs])
  (cond [flags ieee r5rs])
  ((r6rs: case) [flags ieee r5rs])
  (and [flags ieee r5rs])
  (or [flags ieee r5rs])
  (let [flags ieee r5rs])
  (let* [flags ieee r5rs])
  (letrec [flags ieee r5rs])
  (begin [flags ieee r5rs])
  (quasiquote [flags ieee r5rs])
  (unquote [flags ieee r5rs])
  (unquote-splicing [flags ieee r5rs])
  (let-syntax [flags r5rs])
  (letrec-syntax [flags r5rs])
  ((r6rs: syntax-rules) [flags r5rs])
  (identifier-syntax [flags])
  (letrec* [flags])
  (let-values [flags])
  (let*-values [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs base)] [flags primitive proc])
  (eqv? [sig [(ptr ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard cp02 ieee r5rs])
  (eq? [sig [(ptr ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard cp02 ieee r5rs])
  (equal? [sig [(ptr ptr) -> (boolean)]] [flags unrestricted mifoldable discard cp02 ieee r5rs])
  (procedure? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs cp02])
  (number? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (complex? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (real? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (rational? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (integer? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (real-valued? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (rational-valued? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (integer-valued? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (exact? [sig [(number) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (inexact? [sig [(number) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (inexact [sig [(number) -> (inexact-number)]] [flags arith-op mifoldable discard])
  (exact [sig [(number) -> (exact-number)]] [flags arith-op mifoldable discard])
  ((r6rs: <) [sig [(real real real ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  ((r6rs: <=) [sig [(real real real ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: =) [sig [(number number number ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  ((r6rs: >) [sig [(real real real ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  ((r6rs: >=) [sig [(real real real ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  (zero? [sig [(number) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (positive? [sig [(real) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (negative? [sig [(real) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (odd? [sig [(integer) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (even? [sig [(integer) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (finite? [sig [(real) -> (boolean)]] [flags pure mifoldable discard])
  (infinite? [sig [(real) -> (boolean)]] [flags pure mifoldable discard])
  (nan? [sig [(real) -> (boolean)]] [flags pure mifoldable discard])
  (max [sig [(real real ...) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (min [sig [(real real ...) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (+ [sig [(number ...) -> (number)]] [flags arith-op partial-folder ieee r5rs])
  (* [sig [(number ...) -> (number)]] [flags arith-op partial-folder ieee r5rs])
  (- [sig [(number number ...) -> (number)]] [flags arith-op partial-folder ieee r5rs])
  (/ [sig [(number number ...) -> (number)]] [flags arith-op partial-folder ieee r5rs])
  (abs [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (div-and-mod [sig [(real real) -> (real real)]] [flags mifoldable discard])
  (div [sig [(real real) -> (real)]] [flags arith-op mifoldable discard])
  (mod [sig [(real real) -> (real)]] [flags arith-op mifoldable discard])
  (div0-and-mod0 [sig [(real real) -> (real real)]] [flags mifoldable discard])
  (div0 [sig [(real real) -> (real)]] [flags arith-op mifoldable discard])
  (mod0 [sig [(real real) -> (real)]] [flags arith-op mifoldable discard])
  (gcd [sig [(integer ...) -> (integer)]] [flags arith-op mifoldable discard ieee r5rs])
  (lcm [sig [(integer ...) -> (integer)]] [flags arith-op mifoldable discard ieee r5rs])
  (numerator [sig [(rational) -> (integer)]] [flags arith-op mifoldable discard ieee r5rs])
  (denominator [sig [(rational) -> (integer)]] [flags arith-op mifoldable discard ieee r5rs])
  (floor [sig [(real) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (ceiling [sig [(real) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (truncate [sig [(real) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (round [sig [(real) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (rationalize [sig [(real real) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (exp [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (log [sig [(number) (number number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (sin [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (cos [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (tan [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (asin [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (acos [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (atan [sig [(number) (real real) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (sqrt [sig [(number) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (exact-integer-sqrt [sig [(exact-integer) -> (exact-integer exact-integer)]] [flags arith-op mifoldable discard])
  (expt [sig [(number number) -> (number)]] [flags pure discard true cp02 ieee r5rs]) ; can take too long to fold
  (make-rectangular [sig [(real real) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (make-polar [sig [(real real) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (real-part [sig [(number) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (imag-part [sig [(number) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (magnitude [sig [(number) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  (angle [sig [(number) -> (real)]] [flags arith-op mifoldable discard ieee r5rs])
  ((r6rs: number->string) [sig [(number) (number sub-ufixnum) (number sub-ufixnum sub-ufixnum) -> (string)]] [flags alloc ieee r5rs]) ; radix restricted to 2, 4, 8, 16
  ((r6rs: string->number) [sig [(string) (string sub-ufixnum) -> (maybe-number)]] [flags discard ieee r5rs]) ; radix restricted to 2, 4, 8, 16
  (not [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs cp02])
  (boolean? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (boolean=? [sig [(boolean boolean boolean ...) -> (boolean)]] [flags pure mifoldable discard cp03])
  (pair? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (cons [sig [(ptr ptr) -> (#1=(ptr . ptr))]] [flags unrestricted alloc ieee r5rs])
 ; c..r non-alphabetic so marks come before references
  (car [sig [(#1#) -> (ptr)]] [flags mifoldable discard cp02 ieee r5rs])
  (cdr [sig [(#1#) -> (ptr)]] [flags mifoldable discard cp02 ieee r5rs])
  (caar [sig [(#2=(#1# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdar [sig [(#2#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cadr [sig [(#3=(ptr . #1#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cddr [sig [(#3#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caaar [sig [(#4=(#2# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdaar [sig [(#4#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cadar [sig [(#5=(#3# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cddar [sig [(#5#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caadr [sig [(#6=(ptr . #2#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdadr [sig [(#6#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caddr [sig [(#7=(ptr . #3#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdddr [sig [(#7#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caaaar [sig [(#8=(#4# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdaaar [sig [(#8#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cadaar [sig [(#9=(#5# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cddaar [sig [(#9#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caadar [sig [(#10=(#6# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdadar [sig [(#10#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caddar [sig [(#11=(#7# . ptr)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdddar [sig [(#11#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caaadr [sig [(#12=(ptr . #4#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdaadr [sig [(#12#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cadadr [sig [(#13=(ptr . #5#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cddadr [sig [(#13#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (caaddr [sig [(#14=(ptr . #6#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cdaddr [sig [(#14#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cadddr [sig [(#15=(ptr . #7#)) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (cddddr [sig [(#15#) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (null? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (list? [sig [(ptr) -> (boolean)]] [flags unrestricted mifoldable discard ieee r5rs])
  (list [sig [(ptr ...) -> (list)]] [flags unrestricted alloc cp02 ieee r5rs])
  (length [sig [(list) -> (length)]] [flags mifoldable discard true ieee r5rs])
  (append [sig [() -> (null)] [(list ... ptr) -> (ptr)]] [flags discard ieee r5rs cp02])
  (reverse [sig [(list) -> (list)]] [flags alloc ieee r5rs])
  (list-tail [sig [(ptr sub-index) -> (ptr)]] [flags mifoldable discard ieee r5rs])
  (list-ref [sig [(pair sub-index) -> (ptr)]] [flags mifoldable discard ieee r5rs cp02])
  (map [sig [(procedure list list ...) -> (list)]] [flags cp02 cp03 ieee r5rs true])
  (for-each [sig [(procedure list list ...) -> (ptr ...)]] [flags cp02 cp03 ieee r5rs])
  (symbol? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (symbol->string [sig [(symbol) -> (string)]] [flags true mifoldable discard ieee r5rs])
  (symbol=? [sig [(symbol symbol symbol ...) -> (boolean)]] [flags pure mifoldable discard cp03])
  (string->symbol [sig [(string) -> (symbol)]] [flags true mifoldable discard ieee r5rs])
  (char? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (char->integer [sig [(char) -> (fixnum)]] [flags pure mifoldable discard true ieee r5rs])
  (integer->char [sig [(sub-ufixnum) -> (char)]] [flags pure mifoldable discard true ieee r5rs])
  ((r6rs: char<=?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs]) ; restricted to 2+ arguments
  ((r6rs: char<?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: char=?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs cp03])  ; restricted to 2+ arguments
  ((r6rs: char>=?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs]) ; restricted to 2+ arguments
  ((r6rs: char>?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  (string? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (make-string [sig [(length) (length char) -> (string)]] [flags alloc ieee r5rs])
  (string [sig [(char ...) -> (string)]] [flags alloc ieee r5rs cp02])
  (string-length [sig [(string) -> (length)]] [flags pure true ieee r5rs mifoldable discard])
  (string-ref [sig [(string sub-index) -> (ptr)]] [flags true ieee r5rs mifoldable discard cp02])
  ((r6rs: string<=?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: string<?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  ((r6rs: string=?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs cp03])   ; restricted to 2+ arguments
  ((r6rs: string>=?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: string>?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  (substring [sig [(string sub-length sub-length) -> (string)]] [flags alloc ieee r5rs])
  (string-append [sig [(string ...) -> (string)]] [flags alloc ieee r5rs])
  (string->list [sig [(string) -> (list)]] [flags alloc ieee r5rs])
  (list->string [sig [(sub-list) -> (string)]] [flags alloc ieee r5rs])
  (string-for-each [sig [(procedure string string ...) -> (void)]] [flags cp03])
  (string-copy [sig [(string) -> (string)]] [flags alloc ieee r5rs])
  (vector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (make-vector [sig [(length) (length ptr) -> (vector)]] [flags alloc ieee r5rs])
  (vector [sig [(ptr ...) -> (vector)]] [flags unrestricted alloc ieee r5rs cp02])
  (vector-length [sig [(vector) -> (length)]] [flags pure true ieee r5rs mifoldable discard])
  (vector-ref [sig [(vector sub-index) -> (ptr)]] [flags ieee r5rs mifoldable discard cp02])
  (vector-set! [sig [(vector sub-index ptr) -> (void)]] [flags true ieee r5rs])
  (vector->list [sig [(vector) -> (list)]] [flags alloc ieee r5rs])
  (list->vector [sig [(list) -> (vector)]] [flags alloc ieee r5rs])
  (vector-fill! [sig [(vector ptr) -> (void)]] [flags true ieee r5rs])
  (vector-map [sig [(procedure vector vector ...) -> (vector)]] [flags cp03])
  (vector-for-each [sig [(procedure vector vector ...) -> (void)]] [flags cp03])
  (error [sig [(who string ptr ...) -> (bottom)]] [flags abort-op])
  (assertion-violation [sig [(who string ptr ...) -> (bottom)]] [flags abort-op])
  (apply [sig [(procedure ptr ... list) -> (ptr ...)]] [flags cp02 ieee r5rs])
  (call-with-current-continuation [sig [(procedure) -> (ptr ...)]] [flags ieee r5rs])
  (call/cc [sig [(procedure) -> (ptr ...)]] [flags])
  (values [sig [(ptr ...) -> (ptr ...)]] [flags unrestricted discard cp02 ieee r5rs])
  (call-with-values [sig [(procedure procedure) -> (ptr ...)]] [flags cp02 ieee r5rs])
  ((r6rs: dynamic-wind) [sig [(procedure procedure procedure) -> (ptr ...)]] [flags ieee r5rs])      ; restricted to 3 arguments
)

(define-symbol-flags* ([libraries (rnrs) (rnrs bytevectors)] [flags keyword])
  (endianness [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs bytevectors)] [flags primitive proc])
  (native-endianness [sig [() -> (symbol)]] [flags pure unrestricted alloc cp02])
  (bytevector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-bytevector [sig [(length) (length u8/s8) -> (bytevector)]] [flags alloc])
  (bytevector-length [sig [(bytevector) -> (length)]] [flags true mifoldable discard])
  (bytevector=? [sig [(bytevector bytevector) -> (boolean)]] [flags mifoldable discard cp03])
  (bytevector-fill! [sig [(bytevector u8/s8) -> (void)]] [flags true])
  (bytevector-copy! [sig [(bytevector sub-length bytevector sub-length sub-length) -> (void)]] [flags true])
  (bytevector-copy [sig [(bytevector) -> (bytevector)]] [flags alloc])
  (bytevector-u8-ref [sig [(bytevector sub-index) -> (u8)]] [flags true mifoldable discard])
  (bytevector-s8-ref [sig [(bytevector sub-index) -> (s8)]] [flags true mifoldable discard])
  (bytevector-u8-set! [sig [(bytevector sub-index u8) -> (void)]] [flags true])
  (bytevector-s8-set! [sig [(bytevector sub-index s8) -> (void)]] [flags true])
  (bytevector->u8-list [sig [(bytevector) -> (list)]] [flags alloc])
  (u8-list->bytevector [sig [(sub-list) -> (bytevector)]] [flags alloc])
  (bytevector-uint-ref [sig [(bytevector sub-index endianness sub-length) -> (uint)]] [flags true mifoldable discard])
  (bytevector-sint-ref [sig [(bytevector sub-index endianness sub-length) -> (sint)]] [flags true mifoldable discard])
  (bytevector-uint-set! [sig [(bytevector sub-index sub-uint endianness sub-length) -> (void)]] [flags true])
  (bytevector-sint-set! [sig [(bytevector sub-index sub-sint endianness sub-length) -> (void)]] [flags true])
  (bytevector->uint-list [sig [(bytevector endianness sub-index) -> (list)]] [flags alloc])
  (bytevector->sint-list [sig [(bytevector endianness sub-index) -> (list)]] [flags alloc])
  (uint-list->bytevector [sig [(sub-list endianness sub-index) -> (bytevector)]] [flags alloc])
  (sint-list->bytevector [sig [(sub-list endianness sub-index) -> (bytevector)]] [flags alloc])
  (bytevector-u16-ref [sig [(bytevector sub-index endianness) -> (u16)]] [flags true mifoldable discard])
  (bytevector-s16-ref [sig [(bytevector sub-index endianness) -> (s16)]] [flags true mifoldable discard])
  (bytevector-u16-native-ref [sig [(bytevector sub-index) -> (u16)]] [flags true cp02])
  (bytevector-s16-native-ref [sig [(bytevector sub-index) -> (s16)]] [flags true cp02])
  (bytevector-u16-set! [sig [(bytevector sub-index u16 endianness) -> (void)]] [flags true])
  (bytevector-s16-set! [sig [(bytevector sub-index s16 endianness) -> (void)]] [flags true])
  (bytevector-u16-native-set! [sig [(bytevector sub-index u16) -> (void)]] [flags true])
  (bytevector-s16-native-set! [sig [(bytevector sub-index s16) -> (void)]] [flags true])
  (bytevector-u32-ref [sig [(bytevector sub-index endianness) -> (u32)]] [flags true mifoldable discard])
  (bytevector-s32-ref [sig [(bytevector sub-index endianness) -> (s32)]] [flags true mifoldable discard])
  (bytevector-u32-native-ref [sig [(bytevector sub-index) -> (u32)]] [flags true cp02])
  (bytevector-s32-native-ref [sig [(bytevector sub-index) -> (s32)]] [flags true cp02])
  (bytevector-u32-set! [sig [(bytevector sub-index u32 endianness) -> (void)]] [flags true])
  (bytevector-s32-set! [sig [(bytevector sub-index s32 endianness) -> (void)]] [flags true])
  (bytevector-u32-native-set! [sig [(bytevector sub-index u32) -> (void)]] [flags true])
  (bytevector-s32-native-set! [sig [(bytevector sub-index s32) -> (void)]] [flags true])
  (bytevector-u64-ref [sig [(bytevector sub-index endianness) -> (u64)]] [flags true mifoldable discard])
  (bytevector-s64-ref [sig [(bytevector sub-index endianness) -> (s64)]] [flags true mifoldable discard])
  (bytevector-u64-native-ref [sig [(bytevector sub-index) -> (u64)]] [flags true cp02])
  (bytevector-s64-native-ref [sig [(bytevector sub-index) -> (s64)]] [flags true cp02])
  (bytevector-u64-set! [sig [(bytevector sub-index u64 endianness) -> (void)]] [flags true])
  (bytevector-s64-set! [sig [(bytevector sub-index s64 endianness) -> (void)]] [flags true])
  (bytevector-u64-native-set! [sig [(bytevector sub-index u64) -> (void)]] [flags true])
  (bytevector-s64-native-set! [sig [(bytevector sub-index s64) -> (void)]] [flags true])
  (bytevector-ieee-single-ref [sig [(bytevector sub-index endianness) -> (flonum)]] [flags true mifoldable discard])
  (bytevector-ieee-single-native-ref [sig [(bytevector sub-index) -> (flonum)]] [flags true mifoldable discard])
  (bytevector-ieee-double-ref [sig [(bytevector sub-index endianness) -> (flonum)]] [flags true mifoldable discard])
  (bytevector-ieee-double-native-ref [sig [(bytevector sub-index) -> (flonum)]] [flags true mifoldable discard])
  (bytevector-ieee-single-set! [sig [(bytevector sub-index real endianness) -> (void)]] [flags true])
  (bytevector-ieee-single-native-set! [sig [(bytevector sub-index real) -> (void)]] [flags true])
  (bytevector-ieee-double-set! [sig [(bytevector sub-index real endianness) -> (void)]] [flags true])
  (bytevector-ieee-double-native-set! [sig [(bytevector sub-index real) -> (void)]] [flags true])
  (string->utf8 [sig [(string) -> (bytevector)]] [flags alloc])
  (string->utf16 [sig [(string) (string endianness) -> (bytevector)]] [flags alloc])
  (string->utf32 [sig [(string) (string endianness) -> (bytevector)]] [flags alloc])
  (utf8->string [sig [(bytevector) -> (string)]] [flags alloc])
  (utf16->string [sig [(bytevector endianness) (bytevector endianness ptr) -> (string)]] [flags alloc])
  (utf32->string [sig [(bytevector endianness) (bytevector endianness ptr) -> (string)]] [flags alloc])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs control)] [flags keyword])
  (when [flags])
  (unless [flags])
  (do [flags ieee r5rs])
  (case-lambda [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs enums)] [flags keyword])
  (define-enumeration [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs enums)] [flags primitive proc])
  (make-enumeration [sig [(sub-list) -> (enum-set)]] [flags pure alloc])
  (enum-set-universe [sig [(enum-set) -> (enum-set)]] [flags pure alloc])
  (enum-set-indexer [sig [(enum-set) -> (procedure)]] [flags pure alloc])
  (enum-set-constructor [sig [(enum-set) -> (procedure)]] [flags pure alloc])
  (enum-set->list [sig [(enum-set) -> (list)]] [flags pure mifoldable discard alloc])
  (enum-set-member? [sig [(symbol enum-set) -> (boolean)]] [flags pure mifoldable discard])
  (enum-set-subset? [sig [(enum-set enum-set) -> (boolean)]] [flags pure mifoldable discard])
  (enum-set=? [sig [(enum-set enum-set) -> (boolean)]] [flags pure mifoldable discard cp03])
  (enum-set-union [sig [(enum-set enum-set) -> (enum-set)]] [flags pure alloc])
  (enum-set-intersection [sig [(enum-set enum-set) -> (enum-set)]] [flags pure alloc])
  (enum-set-difference [sig [(enum-set enum-set) -> (enum-set)]] [flags pure alloc])
  (enum-set-complement [sig [(enum-set) -> (enum-set)]] [flags pure alloc])
  (enum-set-projection [sig [(enum-set enum-set) -> (enum-set)]] [flags pure alloc])
)

(define-symbol-flags* ([libraries (rnrs eval)] [flags primitive proc])
  ((r6rs: eval) [sig [(ptr environment) -> (ptr ...)]] [flags ieee r5rs]) ; restricted to 2 arguments, first must be expression (not definition)
  (environment [sig [(import-spec ...) -> (environment)]] [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs exceptions)] [flags keyword])
  (guard [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs conditions)] [flags keyword])
  (define-condition-type [flags])
  (&condition [flags])
  (&message [flags])
  (&warning [flags])
  (&serious [flags])
  (&error [flags])
  (&violation [flags])
  (&assertion [flags])
  (&irritants [flags])
  (&who [flags])
  (&non-continuable [flags])
  (&implementation-restriction [flags])
  (&lexical [flags])
  (&syntax [flags])
  (&undefined [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs exceptions)] [flags primitive proc])
  (with-exception-handler [sig [(procedure procedure) -> (ptr ...)]] [flags])
  (raise [sig [(ptr) -> (bottom)]] [flags unrestricted abort-op])
  (raise-continuable [sig [(ptr) -> (ptr ...)]] [flags unrestricted])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs conditions)] [flags primitive proc])
  (condition [sig [(condition ...) -> (condition)]] [flags pure mifoldable discard alloc])
  (simple-conditions [sig [(condition) -> (list)]] [flags mifoldable discard true])
  (condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (condition-predicate [sig [(sub-rtd) -> (procedure)]] [flags pure alloc])
  (condition-accessor [sig [(sub-rtd procedure) -> (procedure)]] [flags pure alloc])
  (make-message-condition [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (message-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (condition-message [sig [(message-condition) -> (ptr)]] [flags pure mifoldable discard])
  (make-warning [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (warning? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-serious-condition [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (serious-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-error [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-violation [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-assertion-violation [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (assertion-violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-irritants-condition [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (irritants-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (condition-irritants [sig [(irritants-condition) -> (ptr)]] [flags pure mifoldable discard])
  (make-who-condition [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (who-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (condition-who [sig [(who-condition) -> (ptr)]] [flags pure mifoldable discard])
  (make-non-continuable-violation [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (non-continuable-violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-implementation-restriction-violation [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (implementation-restriction-violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-lexical-violation [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (lexical-violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-syntax-violation [sig [(ptr ptr) -> (condition)]] [flags pure unrestricted alloc])
  (syntax-violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (syntax-violation-form [sig [(syntax-violation) -> (ptr)]] [flags pure mifoldable discard])
  (syntax-violation-subform [sig [(syntax-violation) -> (ptr)]] [flags pure mifoldable discard])
  (make-undefined-violation [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (undefined-violation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs files)] [flags primitive proc])
  ((r6rs: file-exists?) [sig [(pathname) -> (boolean)]] [flags discard])  ; restricted to 1 argument
  ((r6rs: delete-file) [sig [(pathname) -> (void)]] [flags])           ; restricted to 1 argument
)

(define-symbol-flags* ([libraries (rnrs) (rnrs hashtables)] [flags primitive proc])
  (make-eq-hashtable [sig [() (uint) -> (eq-hashtable)]] [flags alloc])
  (make-eqv-hashtable [sig [() (uint) -> (hashtable)]] [flags alloc])
  (make-hashtable [sig [(procedure procedure) (procedure procedure uint) -> (hashtable)]] [flags alloc])
  (hashtable? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (hashtable-size [sig [(hashtable) -> (length)]] [flags discard true])
  (hashtable-ref [sig [(hashtable ptr ptr) -> (ptr)]] [flags discard])
  (hashtable-set! [sig [(hashtable ptr ptr) -> (void)]] [flags true])
  (hashtable-delete! [sig [(hashtable ptr) -> (void)]] [flags true])
  (hashtable-contains? [sig [(hashtable ptr) -> (boolean)]] [flags discard])
  (hashtable-update! [sig [(hashtable ptr procedure ptr) -> (void)]] [flags])
  (hashtable-copy [sig [(hashtable) (hashtable ptr) -> (hashtable)]] [flags alloc])
  (hashtable-clear! [sig [(hashtable) (hashtable sub-uint) -> (void)]] [flags true])
  ((r6rs: hashtable-keys) [sig [(hashtable) -> (vector)]] [flags alloc])           ; no size argument
  ((r6rs: hashtable-entries) [sig [(hashtable) -> (vector vector)]] [flags alloc]) ; no size argument
  (hashtable-equivalence-function [sig [(hashtable) -> (ptr)]] [flags])
  (hashtable-hash-function [sig [(hashtable) -> (ptr)]] [flags])
  (hashtable-mutable? [sig [(hashtable) -> (boolean)]] [flags mifoldable discard])
  (equal-hash [sig [(ptr) -> (length)]] [flags unrestricted true])
  (string-hash [sig [(string) -> (length)]] [flags true])
  (string-ci-hash [sig [(string) -> (length)]] [flags true])
  (symbol-hash [sig [(symbol) -> (length)]] [flags true])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs io ports)] [flags keyword])
  (file-options [flags])
  (buffer-mode [flags])
  (eol-style [flags])
  (&i/o-decoding [flags])
  (&i/o-encoding [flags])
  (error-handling-mode [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs io ports) (rnrs io simple)] [flags primitive proc])
  (eof-object [sig [() -> (eof-object)]] [flags pure unrestricted mifoldable discard true])
  (eof-object? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  (input-port? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  ((r6rs: current-input-port) [sig [() -> (textual-input-port)]] [flags ieee r5rs])
  (output-port? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard ieee r5rs])
  ((r6rs: current-output-port) [sig [() -> (textual-output-port)]] [flags ieee r5rs])
  ((r6rs: current-error-port) [sig [() -> (textual-output-port)]] [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs io ports)] [flags primitive proc])
  (buffer-mode? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (latin-1-codec [sig [() -> (codec)]] [flags pure unrestricted true])
  (utf-8-codec [sig [() -> (codec)]] [flags pure unrestricted true])
  ((r6rs: utf-16-codec) [sig [() -> (codec)]] [flags pure unrestricted true])
  (native-eol-style [sig [() -> (symbol)]] [flags pure unrestricted true])
  (make-i/o-decoding-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-decoding-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-encoding-error [sig [(ptr ptr) -> (condition)]] [flags pure unrestricted alloc]) ; restricted?
  (i/o-encoding-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (i/o-encoding-error-char [sig [(i/o-encoding-error) -> (ptr)]] [flags pure mifoldable discard])
  (make-transcoder [sig [(codec) (codec sub-symbol) (codec sub-symbol sub-symbol) -> (transcoder)]] [flags pure alloc])
  (native-transcoder [sig [() -> (transcoder)]] [flags pure unrestricted true])
  (transcoder-codec [sig [(transcoder) -> (codec)]] [flags pure mifoldable discard true])
  (transcoder-eol-style [sig [(transcoder) -> (symbol)]] [flags pure mifoldable discard true])
  (transcoder-error-handling-mode [sig [(transcoder) -> (symbol)]] [flags pure mifoldable discard true])
  (bytevector->string [sig [(bytevector transcoder) -> (string)]] [flags alloc])  ; leave off alloc if transcoders can be user-defined
  (string->bytevector [sig [(string transcoder) -> (bytevector)]] [flags alloc])  ; leave off alloc if transcoders can be user-defined
  (port? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (port-transcoder [sig [(port) -> (ptr)]] [flags pure mifoldable discard])
  (textual-port? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (binary-port? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (transcoded-port [sig [(binary-port transcoder) -> (textual-port)]] [flags alloc])
  (port-has-port-position? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (port-position [sig [(port) -> (ptr)]] [flags])
  (port-has-set-port-position!? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (set-port-position! [sig [(port sub-ptr) -> (void)]] [flags])
  (close-port [sig [(port) -> (void)]] [flags true])
  (call-with-port [sig [(port procedure) -> (ptr ...)]] [flags])
  (port-eof? [sig [(input-port) -> (boolean)]] [flags])
  (open-file-input-port [sig [(pathname) (pathname file-options) (pathname file-options sub-symbol) (pathname file-options sub-symbol maybe-transcoder) -> (input-port)]] [flags true])
  (open-bytevector-input-port [sig [(bytevector) (bytevector maybe-transcoder) -> (input-port)]] [flags alloc])
  (open-string-input-port [sig [(string) -> (textual-input-port)]] [flags alloc])
  ((r6rs: standard-input-port) [sig [() -> (binary-input-port)]] [flags true])
  (make-custom-binary-input-port [sig [(string procedure maybe-procedure maybe-procedure maybe-procedure) -> (binary-input-port)]] [flags alloc])
  (make-custom-textual-input-port [sig [(string procedure maybe-procedure maybe-procedure maybe-procedure) -> (textual-input-port)]] [flags alloc])
  (get-u8 [sig [(binary-input-port) -> (ptr)]] [flags])
  (lookahead-u8 [sig [(binary-input-port) -> (ptr)]] [flags])
  (get-bytevector-n [sig [(binary-input-port length) -> (ptr)]] [flags true])
  (get-bytevector-n! [sig [(binary-input-port bytevector length length) -> (ptr)]] [flags true])
  (get-bytevector-some [sig [(binary-input-port) -> (ptr)]] [flags true])
  (get-bytevector-all [sig [(binary-input-port) -> (ptr)]] [flags true])
  (get-char [sig [(textual-input-port) -> (ptr)]] [flags true])
  (lookahead-char [sig [(textual-input-port) -> (ptr)]] [flags true])
  (get-string-n [sig [(textual-input-port length) -> (ptr)]] [flags true])
  (get-string-n! [sig [(textual-input-port string length length) -> (ptr)]] [flags true])
  (get-string-all [sig [(textual-input-port) -> (ptr)]] [flags true])
  (get-line [sig [(textual-input-port) -> (ptr)]] [flags true])
  (get-datum [sig [(textual-input-port) -> (ptr)]] [flags])
  ((r6rs: flush-output-port) [sig [(output-port) -> (void)]] [flags])   ; restricted to 1 argument
  (output-port-buffer-mode [sig [(output-port) -> (symbol)]] [flags true])
  (open-file-output-port [sig [(pathname) (pathname file-options) (pathname file-options sub-symbol) (pathname file-options sub-symbol maybe-transcoder) -> (output-port)]] [flags true])
  (open-bytevector-output-port [sig [() (maybe-transcoder) -> (output-port procedure)]] [flags discard])
  (call-with-bytevector-output-port [sig [(procedure) (procedure maybe-transcoder) -> (bytevector)]] [flags])
  (open-string-output-port [sig [() -> (textual-output-port procedure)]] [flags alloc])
  (call-with-string-output-port [sig [(procedure) -> (string)]] [flags])
  ((r6rs: standard-output-port) [sig [() -> (binary-output-port)]] [flags true])
  ((r6rs: standard-error-port) [sig [() -> (binary-output-port)]] [flags true])
  (make-custom-binary-output-port [sig [(string procedure maybe-procedure maybe-procedure maybe-procedure) -> (binary-output-port)]] [flags alloc])
  (make-custom-textual-output-port [sig [(string procedure maybe-procedure maybe-procedure maybe-procedure) -> (textual-output-port)]] [flags alloc])
  (put-u8 [sig [(binary-output-port u8) -> (void)]] [flags])
  (put-bytevector [sig [(binary-output-port bytevector) (binary-output-port bytevector length) (binary-output-port bytevector length length) -> (void)]] [flags true])
  (put-char [sig [(textual-output-port char) -> (void)]] [flags true])
  (put-string [sig [(textual-output-port string) (textual-output-port string length) (textual-output-port string length length) -> (void)]] [flags true])
  (put-datum [sig [(textual-output-port ptr) -> (void)]] [flags true])
  (open-file-input/output-port [sig [(pathname) (pathname file-options) (pathname file-options sub-symbol) (pathname file-options sub-symbol maybe-transcoder) -> (input/output-port)]] [flags true])
  (make-custom-binary-input/output-port [sig [(string procedure procedure maybe-procedure maybe-procedure maybe-procedure) -> (binary-input/output-port)]] [flags alloc])
  (make-custom-textual-input/output-port [sig [(string procedure procedure maybe-procedure maybe-procedure maybe-procedure) -> (textual-input/output-port)]] [flags alloc])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs files) (rnrs io ports) (rnrs io simple)] [flags keyword])
  (&i/o [flags])
  (&i/o-read [flags])
  (&i/o-write [flags])
  (&i/o-invalid-position [flags])
  (&i/o-filename [flags])
  (&i/o-file-protection [flags])
  (&i/o-file-is-read-only [flags])
  (&i/o-file-already-exists [flags])
  (&i/o-file-does-not-exist [flags])
  (&i/o-port [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs files) (rnrs io ports) (rnrs io simple)] [flags primitive proc])
  (make-i/o-error [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (i/o-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-read-error [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (i/o-read-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-write-error [sig [() -> (condition)]] [flags pure unrestricted alloc])
  (i/o-write-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-invalid-position-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-invalid-position-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (i/o-error-position [sig [(i/o-invalid-position-error) -> (ptr)]] [flags pure mifoldable discard])
  (make-i/o-filename-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-filename-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (i/o-error-filename [sig [(i/o-filename-error) -> (ptr)]] [flags pure mifoldable discard])
  (make-i/o-file-protection-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-file-protection-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-file-is-read-only-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-file-is-read-only-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-file-already-exists-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-file-already-exists-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-file-does-not-exist-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-file-does-not-exist-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (make-i/o-port-error [sig [(ptr) -> (condition)]] [flags pure unrestricted alloc])
  (i/o-port-error? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (i/o-error-port [sig [(i/o-port-error) -> (ptr)]] [flags pure mifoldable discard])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs io simple)] [flags primitive proc])
  ((r6rs: call-with-input-file) [sig [(pathname procedure) -> (ptr ...)]] [flags ieee r5rs])   ; has no options argument
  ((r6rs: call-with-output-file) [sig [(pathname procedure) -> (ptr ...)]] [flags ieee r5rs])  ; has no options argument
  ((r6rs: with-input-from-file) [sig [(pathname procedure) -> (ptr ...)]] [flags ieee r5rs])   ; has no options argument
  ((r6rs: with-output-to-file) [sig [(pathname procedure) -> (ptr ...)]] [flags ieee r5rs])    ; has no options argument
  ((r6rs: open-input-file) [sig [(pathname) -> (textual-input-port)]] [flags true ieee r5rs])   ; has no options argument
  ((r6rs: open-output-file) [sig [(pathname) -> (textual-output-port)]] [flags true ieee r5rs])  ; has no options argument
  (close-input-port [sig [(input-port) -> (void)]] [flags true ieee r5rs])
  (close-output-port [sig [(output-port) -> (void)]] [flags true ieee r5rs])
  (read-char [sig [() (textual-input-port) -> (ptr)]] [flags true ieee r5rs])
  (peek-char [sig [() (textual-input-port) -> (ptr)]] [flags true ieee r5rs])
  (read [sig [() (textual-input-port) -> (ptr)]] [flags ieee r5rs])
  (write-char [sig [(char) (char textual-output-port) -> (void)]] [flags true ieee r5rs])
  (newline [sig [() (textual-output-port) -> (void)]] [flags true ieee r5rs])
  (display [sig [(ptr) (ptr textual-output-port) -> (void)]] [flags true ieee r5rs])
  (write [sig [(ptr) (ptr textual-output-port) -> (void)]] [flags true ieee r5rs])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs lists)] [flags primitive proc])
  (find [sig [(procedure sub-ptr) -> (ptr)]] [flags cp03])
  (for-all [sig [(procedure list list ...) -> (ptr ...)]] [flags cp03])
  (exists [sig [(procedure list list ...) -> (ptr ...)]] [flags cp03])
  (filter [sig [(procedure list) -> (list)]] [flags true cp03])
  (partition [sig [(procedure list) -> (list list)]] [flags])
  (fold-left [sig [(procedure ptr list list ...) -> (ptr ...)]] [flags cp03])
  (fold-right [sig [(procedure ptr list list ...) -> (ptr ...)]] [flags cp03])
  (remp [sig [(procedure list) -> (list)]] [flags true cp03])
  (remove [sig [(ptr list) -> (list)]] [flags true cp02]) ; mifoldable discard could break eq?
  (remv [sig [(ptr list) -> (list)]] [flags alloc cp02]) ; mifoldable discard could break eq?
  (remq [sig [(ptr list) -> (list)]] [flags alloc cp02]) ; mifoldable discard could break eq?
  (memp [sig [(procedure sub-ptr) -> (ptr)]] [flags cp03])
  (member [sig [(ptr sub-ptr) -> (ptr)]] [flags mifoldable cp02 ieee r5rs])
  (memv [sig [(ptr sub-ptr) -> (ptr)]] [flags mifoldable discard cp02 ieee r5rs])
  (memq [sig [(ptr sub-ptr) -> (ptr)]] [flags mifoldable discard cp02 ieee r5rs])
  (assp [sig [(procedure sub-ptr) -> (ptr)]] [flags cp03])
  (assoc [sig [(ptr sub-ptr) -> (ptr)]] [flags mifoldable cp02 ieee r5rs])
  (assv [sig [(ptr sub-ptr) -> (ptr)]] [flags mifoldable discard cp02 ieee r5rs])
  (assq [sig [(ptr sub-ptr) -> (ptr)]] [flags mifoldable discard cp02 ieee r5rs])
  (cons* [sig [(ptr) -> (ptr)] [(ptr ptr ptr ...) -> ((ptr . ptr))]] [flags unrestricted discard cp02])
)

(define-symbol-flags* ([libraries (rnrs mutable-pairs)] [flags primitive proc])
  (set-car! [sig [((ptr . ptr) ptr) -> (void)]] [flags true ieee r5rs])
  (set-cdr! [sig [((ptr . ptr) ptr) -> (void)]] [flags true ieee r5rs])
)

(define-symbol-flags* ([libraries (rnrs mutable-strings)] [flags primitive proc])
  (string-set! [sig [(string sub-index char) -> (void)]] [flags true ieee r5rs])
  (string-fill! [sig [(string char) -> (void)]] [flags true ieee r5rs])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs programs)] [flags primitive proc])
  ((r6rs: command-line) [sig [() -> (list)]] [flags])  ; restricted to 0 arguments
  ((r6rs: exit) [sig [() (ptr) -> (bottom)]] [flags abort-op]) ; restricted to 0 or 1 argument
)

(define-symbol-flags* ([libraries (rnrs r5rs)] [flags keyword])
  (delay [flags r5rs])
)

(define-symbol-flags* ([libraries (rnrs r5rs)] [flags primitive proc])
  (exact->inexact [sig [(number) -> (inexact-number)]] [flags arith-op mifoldable discard ieee r5rs])
  (inexact->exact [sig [(number) -> (exact-number)]] [flags arith-op mifoldable discard ieee r5rs])
  (quotient [sig [(integer integer) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (remainder [sig [(integer integer) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (modulo [sig [(integer integer) -> (number)]] [flags arith-op mifoldable discard ieee r5rs])
  (force [sig [(procedure) -> (ptr)]] [flags r5rs])
  (null-environment [sig [(sub-fixnum) -> (environment)]] [flags alloc ieee r5rs])
  (scheme-report-environment [sig [(sub-fixnum) -> (environment)]] [flags alloc ieee r5rs])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs records syntactic)] [flags keyword])
  (define-record-type [flags])
  (fields [flags])
  (mutable [flags])
  (immutable [flags])
  (parent [flags])
  (protocol [flags])
  (sealed [flags])
  (opaque [flags])
  (nongenerative [flags])
  (parent-rtd [flags])
  (record-type-descriptor [flags])
  (record-constructor-descriptor [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs records procedural)] [flags primitive proc])
  (make-record-type-descriptor [sig [(symbol maybe-rtd maybe-symbol ptr ptr vector) -> (rtd)]] [flags pure alloc cp02])
  (record-type-descriptor? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard cp02])
  (make-record-constructor-descriptor [sig [(rtd maybe-sub-rcd maybe-procedure) -> (rcd)]] [flags pure true cp02])
  ((r6rs: record-constructor) [sig [(rcd) -> (procedure)]] [flags cp02]) ; user-supplied protocol can do anything
  (record-predicate [sig [(rtd) -> (procedure)]] [flags pure alloc cp02])
  (record-accessor [sig [(rtd sub-index) -> (procedure)]] [flags pure alloc cp02])
  (record-mutator [sig [(rtd sub-index) -> (procedure)]] [flags pure alloc cp02])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs records inspection)] [flags primitive proc])
  ((r6rs: record?) [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard cp02])
  (record-rtd [sig [(record) -> (rtd)]] [flags pure mifoldable discard true cp02])
  (record-type-name [sig [(rtd) -> (symbol)]] [flags pure mifoldable discard true cp02])
  (record-type-parent [sig [(rtd) -> (ptr)]] [flags pure mifoldable discard cp02])
  (record-type-uid [sig [(rtd) -> (symbol)]] [flags pure mifoldable discard true cp02])
  (record-type-generative? [sig [(rtd) -> (boolean)]] [flags pure mifoldable discard])
  (record-type-sealed? [sig [(rtd) -> (boolean)]] [flags pure mifoldable discard cp02])
  (record-type-opaque? [sig [(rtd) -> (boolean)]] [flags pure mifoldable discard cp02])
  (record-type-field-names [sig [(rtd) -> (vector)]] [flags pure mifoldable discard true cp02])
  (record-field-mutable? [sig [(rtd sub-index) -> (boolean)]] [flags pure mifoldable discard cp02])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs sorting)] [flags primitive proc])
  (list-sort [sig [(procedure list) -> (list)]] [flags true])
  (vector-sort [sig [(procedure vector) -> (vector)]] [flags true])
  (vector-sort! [sig [(procedure vector) -> (void)]] [flags true])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs syntax-case)] [flags keyword])
  (syntax-case [flags])
  (syntax [flags])
  (with-syntax [flags])
  (quasisyntax [flags])
  (unsyntax [flags])
  (unsyntax-splicing [flags])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs syntax-case)] [flags primitive proc])
  (make-variable-transformer [sig [(procedure) -> (ptr)]] [flags pure mifoldable discard])
  (identifier? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (bound-identifier=? [sig [(identifier identifier) -> (boolean)]] [flags pure mifoldable discard cp03])
  (free-identifier=? [sig [(identifier identifier) -> (boolean)]] [flags pure mifoldable discard cp03])
  (syntax->datum [sig [(ptr) -> (ptr)]] [flags pure unrestricted mifoldable discard])
  (datum->syntax [sig [(identifier ptr) -> (ptr)]] [flags pure mifoldable discard])
  (generate-temporaries [sig [(ptr) -> (list)]] [flags alloc]) ; the argument can be a list, a syntax with a list or an annotation
  (syntax-violation [sig [(who string ptr) (who string ptr ptr) -> (bottom)]] [flags abort-op])
)

(define-symbol-flags* ([libraries (rnrs) (rnrs unicode)] [flags primitive proc]) ; unicode
  (char-upcase [sig [(char) -> (char)]] [flags pure mifoldable discard true ieee r5rs])
  (char-downcase [sig [(char) -> (char)]] [flags pure mifoldable discard true ieee r5rs])
  (char-titlecase [sig [(char) -> (char)]] [flags pure mifoldable discard])
  (char-foldcase [sig [(char) -> (char)]] [flags pure mifoldable discard])
  ((r6rs: char-ci<=?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: char-ci<?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  ((r6rs: char-ci=?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs cp03])   ; restricted to 2+ arguments
  ((r6rs: char-ci>=?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: char-ci>?) [sig [(char char char ...) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  (char-alphabetic? [sig [(char) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (char-numeric? [sig [(char) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (char-whitespace? [sig [(char) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (char-upper-case? [sig [(char) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (char-lower-case? [sig [(char) -> (boolean)]] [flags pure mifoldable discard ieee r5rs])
  (char-title-case? [sig [(char) -> (boolean)]] [flags pure mifoldable discard])
  (char-general-category [sig [(char) -> (symbol)]] [flags pure mifoldable discard])
  (string-upcase [sig [(string) -> (string)]] [flags mifoldable discard])
  (string-downcase [sig [(string) -> (string)]] [flags mifoldable discard])
  (string-titlecase [sig [(string) -> (string)]] [flags mifoldable discard])
  (string-foldcase [sig [(string) -> (string)]] [flags mifoldable discard])
  ((r6rs: string-ci<=?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: string-ci<?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  ((r6rs: string-ci=?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs cp03])   ; restricted to 2+ arguments
  ((r6rs: string-ci>=?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])  ; restricted to 2+ arguments
  ((r6rs: string-ci>?) [sig [(string string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])   ; restricted to 2+ arguments
  (string-normalize-nfd [sig [(string) -> (string)]] [flags mifoldable discard])
  (string-normalize-nfkd [sig [(string) -> (string)]] [flags mifoldable discard])
  (string-normalize-nfc [sig [(string) -> (string)]] [flags mifoldable discard])
  (string-normalize-nfkc [sig [(string) -> (string)]] [flags mifoldable discard])
)

;;; end of r6rs features

(define-symbol-flags* ([libraries (chezscheme csv7)] [flags primitive proc]) ; csv7 compatibility
  ((csv7: record-field-accessible?) [sig [(rtd sub-ptr) -> (boolean)]] [flags pure mifoldable discard cp02])
  ((csv7: record-field-accessor) [sig [(rtd sub-ptr) -> (procedure)]] [flags pure alloc cp02])
  ((csv7: record-field-mutable?) [sig [(rtd sub-ptr) -> (boolean)]] [flags pure mifoldable discard cp02])
  ((csv7: record-field-mutator) [sig [(rtd sub-ptr) -> (procedure)]] [flags pure alloc cp02])
  ((csv7: record-type-descriptor) [sig [(record) -> (rtd)]] [flags pure mifoldable discard true cp02])
  ((csv7: record-type-field-decls) [sig [(rtd) -> (list)]] [flags pure mifoldable discard true cp02])
  ((csv7: record-type-field-names) [sig [(rtd) -> (list)]] [flags pure mifoldable discard true cp02])
  ((csv7: record-type-name) [sig [(rtd) -> (string)]] [flags pure mifoldable discard true cp02])
  ((csv7: record-type-symbol) [sig [(rtd) -> (symbol)]] [flags pure mifoldable discard true cp02])
)

(define-symbol-flags* ([libraries] [flags primitive proc]) ; srfi 19
  (add-duration (sig [(time time) -> (time)]) [flags alloc])
  (add-duration! (sig [(time time) -> (time)]) [flags alloc])
  (current-date [sig [() (sub-fixnum) -> (date)]] [flags alloc])
  (current-time [sig [() (sub-fixnum) -> (time)]] [flags alloc])
  (date-day [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (date-hour [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-minute [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-month [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-nanosecond [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-second [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-week-day [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-year-day [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-dst? [sig [(date) -> (boolean)]] [flags pure mifoldable discard])
  (date-year [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-zone-offset [sig [(date) -> (fixnum)]] [flags pure mifoldable discard true])
  (date-zone-name [sig [(date) -> (ptr)]] [flags pure mifoldable discard])
  (date->time-utc [sig [(date) -> (time-utc)]] [flags alloc])
  (make-date [sig [(sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-fixnum) -> (date)]
                  [(sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum sub-ufixnum) -> (date)]]
             [flags alloc])
  (make-time [sig [(sub-symbol sub-ufixnum sub-fixnum) -> (time)]] [flags alloc])
  (set-time-nanosecond! [sig [(time sub-uint) -> (void)]] [flags true])
  (set-time-second! [sig [(time sub-fixnum) -> (void)]] [flags true])
  (set-time-type! [sig [(time sub-symbol) -> (void)]] [flags true])
  (subtract-duration (sig [(time time) -> (time)]) [flags alloc])
  (subtract-duration! (sig [(time time) -> (time)]) [flags alloc])
  (time? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (time=? [sig [(time time) -> (boolean)]] [flags mifoldable discard cp03])
  (time<? [sig [(time time) -> (boolean)]] [flags mifoldable discard])
  (time<=? [sig [(time time) -> (boolean)]] [flags mifoldable discard])
  (time>=? [sig [(time time) -> (boolean)]] [flags mifoldable discard])
  (time>? [sig [(time time) -> (boolean)]] [flags mifoldable discard])
  (time-difference (sig [(time time) -> (time)]) [flags alloc])
  (time-difference! (sig [(time time) -> (time)]) [flags alloc])
  (time-nanosecond [sig [(time) -> (uint)]] [flags mifoldable discard true])
  (time-second [sig [(time) -> (fixnum)]] [flags mifoldable discard true])
  (time-type [sig [(time) -> (symbol)]] [flags mifoldable discard true])
  (time-utc->date [sig [(time-utc) (time-utc sub-fixnum) -> (date)]] [flags alloc])
)

(define-symbol-flags* ([libraries] [flags primitive proc]) ; constant parameters
  (directory-separator [sig [() -> (char)]] [flags pure unrestricted true cp02])
  (get-process-id [sig [() -> (uint)]] [flags pure unrestricted])
  (get-thread-id [sig [() -> (uint)]] [flags discard unrestricted])
  (machine-type [sig [() -> (symbol)]] [flags pure unrestricted true cp02])
  (most-negative-fixnum [sig [() -> (fixnum)]] [flags pure unrestricted true cp02])
  (most-positive-fixnum [sig [() -> (ufixnum)]] [flags pure unrestricted true cp02])
  (petite? [sig [() -> (boolean)]] [flags pure unrestricted])
  (scheme-version [sig [() -> (string)]] [flags pure unrestricted true])
  (scheme-version-number [sig [() -> (uint uint uint)]] [flags pure unrestricted true])
  (threaded? [sig [() -> (boolean)]] [flags pure unrestricted cp02])
)

(define-symbol-flags* ([libraries] [flags primitive proc]) ; variable parameters
  (abort-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (base-exception-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (break-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (case-sensitive [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (cd [sig [() -> (pathname)] [(pathname) -> (void)]] [flags])
  (collect-generation-radix [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (collect-maximum-generation [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (collect-notify [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (collect-request-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (collect-trip-bytes [sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  (command-line [sig [() -> (list)] [(sub-list) -> (void)]] [flags])  ; not restricted to 1 argument
  (command-line-arguments [sig [() -> (list)] [(sub-list) -> (void)]] [flags])
  (commonization-level [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (compile-file-message [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (compile-interpret-simple [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (compile-imported-libraries [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (compile-library-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (compile-profile [sig [() -> (ptr)] [(ptr) -> (void)]] [flags unrestricted])
  (compile-program-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (compress-format [sig [() -> (symbol)] [(sub-symbol) -> (void)]] [flags])
  (compress-level [sig [() -> (symbol)] [(sub-symbol) -> (void)]] [flags])
  (console-error-port [sig [() -> (textual-output-port)] [(textual-output-port) -> (void)]] [flags])
  (console-input-port [sig [() -> (textual-input-port)] [(textual-input-port) -> (void)]] [flags])
  (console-output-port [sig [() -> (textual-output-port)] [(textual-output-port) -> (void)]] [flags])
  (cp0-effort-limit [sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  (cp0-outer-unroll-limit [sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  (cp0-score-limit [sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  (current-directory [sig [() -> (pathname)] [(pathname) -> (void)]] [flags])
  (current-error-port [sig [() -> (textual-output-port)] [(textual-output-port) -> (void)]] [flags])  ; not restricted to 1 argument
  (current-eval [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (current-exception-state [sig [() -> (exception-state)] [(exception-state) -> (void)]] [flags])
  (current-expand [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (current-input-port [sig [() -> (textual-input-port)] [(textual-input-port) -> (void)]] [flags])   ; not restricted to 1 argument
  (current-locate-source-object-source [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (current-make-source-object [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (current-output-port [sig [() -> (textual-output-port)] [(textual-output-port) -> (void)]] [flags])  ; not restricted to 1 argument
  (current-transcoder [sig [() -> (transcoder)] [(transcoder) -> (void)]] [flags])
  (custom-port-buffer-size [sig [() -> (ufixnum)] [(sub-fixnum) -> (void)]] [flags])
  (debug-level [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (debug-on-exception [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (default-library-search-handler [sig [(symbol library-path list-of-string-pairs list-of-string-pairs) -> (maybe-string maybe-string boolean)]] [flags])
  (default-record-equal-procedure [sig [() -> (maybe-procedure)] [(maybe-procedure) -> (void)]] [flags])
  (default-record-hash-procedure [sig [() -> (maybe-procedure)] [(maybe-procedure) -> (void)]] [flags])
  (enable-cross-library-optimization [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (enable-object-counts [sig [() -> (boolean)] [(ptr) -> (void)]] [flags])
  (eval-syntax-expanders-when [sig [() -> (list)] [(sub-list) -> (void)]] [flags])
  (expand-output [sig [() -> (maybe-textual-output-port)] [(maybe-textual-output-port) -> (void)]] [flags])
  (expand/optimize-output [sig [() -> (maybe-textual-output-port)] [(maybe-textual-output-port) -> (void)]] [flags])
  (exit-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (fasl-compressed [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (file-buffer-size [sig [() -> (ufixnum)] [(sub-fixnum) -> (void)]] [flags])
  (generate-allocation-counts [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-covin-files [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-inspector-information [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-instruction-counts [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-interrupt-trap [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-procedure-source-information [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-profile-forms [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (generate-wpo-files [sig [() -> (boolean)] [(ptr) -> (void)]] [flags])
  (gensym-count [sig [() -> (uint)] [(uint) -> (void)]] [flags])
  (gensym-prefix [sig [() -> (ptr)] [(ptr) -> (void)]] [flags unrestricted])
  (heap-reserve-ratio [sig [() -> (number)] [(sub-number) -> (void)]] [flags])
  (import-notify [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (interaction-environment [sig [() -> (environment)] [(environment) -> (void)]] [flags ieee r5rs])
  (internal-defines-as-letrec* [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (invoke-library [sig [(ptr) -> (void)]] [flags true])
  (keyboard-interrupt-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (library-directories [sig [() -> (list)] [(sub-ptr) -> (void)]] [flags])
  (library-exports [sig [(sub-list) -> (list)]] [flags])
  (library-extensions [sig [() -> (list)] [(sub-ptr) -> (void)]] [flags])
  (library-object-filename [sig [(sub-list) -> (maybe-string)]] [flags])
  (library-list [sig [() -> (list)]] [flags])
  (library-requirements [sig [(sub-list) -> (list)] [(sub-list library-requirements-options) -> (list)]] [flags])
  (library-search-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (library-version [sig [(sub-list) -> (list)]] [flags])
  (make-codec-buffer [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (optimize-level [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (pretty-initial-indent [sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  (pretty-line-length [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (pretty-maximum-lines [sig [() -> (maybe-ufixnum)] [(maybe-ufixnum) -> (void)]] [flags])
  (pretty-one-line-limit [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (pretty-standard-indent [sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  (print-brackets [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (print-char-name [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (print-extended-identifiers [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (print-gensym [sig [() -> (ptr)] [(ptr) -> (void)]] [flags unrestricted])
  (print-graph [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (print-length [sig [() -> (maybe-ufixnum)] [(maybe-ufixnum) -> (void)]] [flags])
  (print-level [sig [() -> (maybe-ufixnum)] [(maybe-ufixnum) -> (void)]] [flags])
  (print-precision [sig [() -> (maybe-uint)] [(maybe-uint) -> (void)]] [flags])
  (print-radix [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (print-record [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (print-unicode [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (print-vector-length [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (profile-palette [sig [() -> (vector)] [(sub-vector) -> (void)]] [flags])
  (profile-line-number-color [sig [() -> (maybe-string)] [(maybe-string) -> (void)]] [flags])
  (random-seed [sig [() -> (u32)] [(u32) -> (void)]] [flags])
  (release-minimum-generation [sig [() -> (ufixnum)] [(sub-ufixnum) -> (void)]] [flags])
  (require-nongenerative-clause [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (reset-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (run-cp0 [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (scheme-start [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (scheme-program [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (scheme-script [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (self-evaluating-vectors [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (source-directories [sig [() -> (list)] [(sub-list) -> (void)]] [flags])
  (subset-mode [sig [() -> (maybe-symbol)] [(maybe-sub-symbol) -> (void)]] [flags])
  (suppress-greeting [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (timer-interrupt-handler [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (trace-output-port [sig [() -> (maybe-textual-output-port)] [(maybe-textual-output-port) -> (void)]] [flags])
  (trace-print [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (transcoded-port-buffer-size [sig [() -> (ufixnum)] [(sub-fixnum) -> (void)]] [flags])
  (undefined-variable-warnings [sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  (waiter-prompt-string [sig [() -> (string)] [(string) -> (void)]] [flags])
  (waiter-prompt-and-read [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
  (waiter-write [sig [() -> (procedure)] [(procedure) -> (void)]] [flags])
)

(define-symbol-flags* ([libraries] [flags ieee r5rs keyword])
  ($primitive [flags])
)

(define-symbol-flags* ([libraries] [flags keyword]) ; condition types
  (&continuation [flags])
  (&format [flags])
  (&source [flags])
)

(define-symbol-flags* ([libraries] [flags keyword])
  ($system [flags library-uid])
  (add-prefix [flags])
  (alias [flags])
  (annotation-options [flags])
  (case [flags])
  (constructor [flags])
  (critical-section [flags])
  (datum [flags])
  (define-ftype [flags])
  (define-property [flags])
  (define-record [flags])
  (define-structure [flags])
  (define-values [flags])
  (drop-prefix [flags])
  (eval-when [flags])
  (except [flags])
  (exclusive-cond [flags])
  (export [flags])
  (expression-editor [feature expeditor] [flags])
  (extend-syntax [flags])
  (fasl-strip-options [flags])
  (fluid-let [flags])
  (fluid-let-syntax [flags])
  (foreign-callable [flags])
  (foreign-procedure [flags])
  (ftype-guardian [flags])
  (ftype-init-lock! [flags])
  (ftype-lock! [flags])
  (ftype-locked-decr! [flags])
  (ftype-locked-incr! [flags])
  (ftype-pointer? [flags])
  (ftype-sizeof [flags])
  (ftype-&ref [flags])
  (ftype-ref [flags])
  (ftype-set! [flags])
  (ftype-spin-lock! [flags])
  (ftype-unlock! [flags])
  (ieee [flags library-uid])
  (implicit-exports [flags])
  (import [flags])
  (import-only [flags])
  (include [flags])
  (indirect-export [flags])
  (library [flags])
  (library-requirements-options [flags])
  (make-ftype-pointer [flags])
  (meta [flags])
  (meta-cond [flags])
  (module [flags])
  (only [flags])
  (parameterize [flags])
  (pariah [flags])
  (predicate [flags])
  (prefix [flags])
  (profile [flags])
  (rec [flags])
  (rename [flags])
  (record-case [flags])
  (r5rs [flags library-uid])
  (r5rs-syntax [flags library-uid])
  (scheme [flags library-uid])
  (syntax-rules [flags])
  (time [flags])
  (top-level-program [flags])
  (trace [flags])
  (trace-case-lambda [flags])
  (trace-define [flags])
  (trace-define-syntax [flags])
  (trace-do [flags])
  (trace-lambda [flags])
  (trace-let [flags])
  (type-descriptor [flags])
  (untrace [flags])
  (with-implicit [flags])
  (with-interrupts-disabled [flags])
  (with-mutex [feature pthreads] [flags])
)

(define-symbol-flags* ([libraries] [flags primitive proc])
  (< [sig [(real real ...) -> (boolean)]] [flags pure mifoldable discard])           ; not restricted to 2+ arguments
  (<= [sig [(real real ...) -> (boolean)]] [flags pure mifoldable discard])          ; not restricted to 2+ arguments
  (= [sig [(number number ...) -> (boolean)]] [flags pure mifoldable discard])           ; not restricted to 2+ arguments
  (> [sig [(real real ...) -> (boolean)]] [flags pure mifoldable discard])           ; not restricted to 2+ arguments
  (>= [sig [(real real ...) -> (boolean)]] [flags pure mifoldable discard])          ; not restricted to 2+ arguments
  (-1+ [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (1+ [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (1- [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (abort [sig [() (ptr) -> (bottom)]] [flags abort-op])
  (acosh [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (add1 [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (andmap [sig [(procedure list list ...) -> (ptr ...)]] [flags cp03])
  (annotation? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (annotation-expression [sig [(annotation) -> (ptr)]] [flags pure mifoldable discard true])
  (annotation-option-set [sig [(annotation) -> (annotation-options)]] [flags pure mifoldable discard true])
  (annotation-source [sig [(annotation) -> (source-object)]] [flags pure mifoldable discard true])
  (annotation-stripped [sig [(annotation) -> (ptr)]] [flags pure mifoldable discard true])
  (append! [sig [() -> (null)] [(list ... ptr) -> (ptr)]] [flags cp02])
  (apropos [sig [(sub-ptr) (sub-ptr environment) -> (void)]] [flags true])
  (apropos-list [sig [(sub-ptr) (sub-ptr environment) -> (list)]] [flags alloc])
  (ash [sig [(sint sint) -> (sint)]] [flags arith-op mifoldable discard cp03])
  (assertion-violationf [sig [(who string sub-ptr ...) -> (bottom)]] [flags abort-op]) ; 2nd arg is format string
  (asinh [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (atanh [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (atom? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (bignum? [sig [(ptr) -> (boolean)]] [flags pure unrestricted cp02])
  (binary-port-input-buffer [sig [(binary-input-port) -> (bytevector)]] [flags discard])
  (binary-port-input-count [sig [(binary-input-port) -> (length)]] [flags discard true])
  (binary-port-input-index [sig [(binary-input-port) -> (index)]] [flags discard])
  (binary-port-input-size [sig [(binary-input-port) -> (length)]] [flags discard])
  (binary-port-output-buffer [sig [(binary-output-port) -> (bytevector)]] [flags discard])
  (binary-port-output-count [sig [(binary-output-port) -> (length)]] [flags discard true])
  (binary-port-output-index [sig [(binary-output-port) -> (index)]] [flags discard])
  (binary-port-output-size [sig [(binary-output-port) -> (length)]] [flags discard])
  (block-read [sig [(textual-input-port string) (textual-input-port string length) -> (ptr)]] [flags true])
  (block-write [sig [(textual-output-port string) (textual-output-port string length) -> (void)]] [flags true])
  (box [sig [(ptr) -> (box)]] [flags unrestricted alloc])
  (box? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (box-cas! [sig [(box ptr ptr) -> (boolean)]] [flags])
  (box-immutable [sig [(ptr) -> (box)]] [flags unrestricted alloc])
  (break [sig [(ptr ...) -> (ptr ...)]] [flags])
  (bwp-object? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (bytes-allocated [sig [() -> (uint)] [(ptr) -> (uint)] [(ptr maybe-sub-symbol) -> (uint)]] [flags alloc])
  (bytes-deallocated [sig [() -> (uint)]] [flags unrestricted alloc])
  (bytevector [sig [(u8/s8 ...) -> (bytevector)]] [flags alloc cp02])
  (bytevector->s8-list [sig [(bytevector) -> (list)]] [flags alloc])
  (bytevector-truncate! [sig [(bytevector length) -> (bytevector)]] [flags true])
  (bytevector->immutable-bytevector [sig [(bytevector) -> (bytevector)]] [flags alloc])
  (bytevector-s24-ref [sig [(bytevector sub-index symbol) -> (s24)]] [flags true mifoldable discard])
  (bytevector-s24-set! [sig [(bytevector sub-index s24 symbol) -> (void)]] [flags true])
  (bytevector-s40-ref [sig [(bytevector sub-index symbol) -> (s40)]] [flags true mifoldable discard])
  (bytevector-s40-set! [sig [(bytevector sub-index s40 symbol) -> (void)]] [flags true])
  (bytevector-s48-ref [sig [(bytevector sub-index symbol) -> (s48)]] [flags true mifoldable discard])
  (bytevector-s48-set! [sig [(bytevector sub-index s48 symbol) -> (void)]] [flags true])
  (bytevector-s56-ref [sig [(bytevector sub-index symbol) -> (s56)]] [flags true mifoldable discard])
  (bytevector-s56-set! [sig [(bytevector sub-index s56 symbol) -> (void)]] [flags true])
  (bytevector-u24-ref [sig [(bytevector sub-index symbol) -> (u24)]] [flags true mifoldable discard])
  (bytevector-u24-set! [sig [(bytevector sub-index u24 symbol) -> (void)]] [flags true])
  (bytevector-u40-ref [sig [(bytevector sub-index symbol) -> (u40)]] [flags true mifoldable discard])
  (bytevector-u40-set! [sig [(bytevector sub-index u40 symbol) -> (void)]] [flags true])
  (bytevector-u48-ref [sig [(bytevector sub-index symbol) -> (u48)]] [flags true mifoldable discard])
  (bytevector-u48-set! [sig [(bytevector sub-index u48 symbol) -> (void)]] [flags true])
  (bytevector-u56-ref [sig [(bytevector sub-index symbol) -> (u56)]] [flags true mifoldable discard])
  (bytevector-u56-set! [sig [(bytevector sub-index u56 symbol) -> (void)]] [flags true])
  (bytevector-compress [sig [(ptr) -> (ptr)]] [flags])
  (bytevector-uncompress [sig [(ptr) -> (ptr)]] [flags])
  (call/1cc [sig [(procedure) -> (ptr ...)]] [flags])
  (call-with-input-file [sig [(pathname procedure) (pathname procedure sub-ptr) -> (ptr ...)]] [flags ieee r5rs])      ; has options argument
  (call-with-output-file [sig [(pathname procedure) (pathname procedure sub-ptr) -> (ptr ...)]] [flags ieee r5rs])     ; has options argument
  (cfl* [sig [(cflonum ...) -> (cflonum)]] [flags arith-op partial-folder])
  (cfl+ [sig [(cflonum ...) -> (cflonum)]] [flags arith-op partial-folder])
  (cfl- [sig [(cflonum cflonum ...) -> (cflonum)]] [flags arith-op partial-folder])
  (cfl/ [sig [(cflonum cflonum ...) -> (cflonum)]] [flags arith-op partial-folder])
  (cfl= [sig [(cflonum cflonum ...) -> (boolean)]] [flags pure mifoldable discard])
  (cfl-conjugate [sig [(cflonum) -> (cflonum)]] [flags arith-op mifoldable discard])
  (cfl-imag-part [sig [(cflonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (cfl-magnitude-squared [sig [(cflonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (cfl-real-part [sig [(cflonum) -> (flonum)]] [flags arith-op mifoldable discard])
  (cflonum? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (char<=? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])     ; not restricted to 2+ arguments
  (char<? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])      ; not restricted to 2+ arguments
  (char=? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard cp03])      ; not restricted to 2+ arguments
  (char>=? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])     ; not restricted to 2+ arguments
  (char>? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])      ; not restricted to 2+ arguments
  (char- [sig [(char char) -> (fixnum)]] [flags pure mifoldable discard true])
  (char-ci<=? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])  ; not restricted to 2+ arguments
  (char-ci<? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])   ; not restricted to 2+ arguments
  (char-ci=? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard cp03])   ; not restricted to 2+ arguments
  (char-ci>=? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])  ; not restricted to 2+ arguments
  (char-ci>? [sig [(char char ...) -> (boolean)]] [flags pure mifoldable discard])   ; not restricted to 2+ arguments
  (char-name [sig [(sub-ptr) (sub-symbol maybe-char) -> (ptr)]] [flags])
  (char-ready? [sig [() (textual-input-port) -> (boolean)]] [flags ieee r5rs])
  (chmod [sig [(pathname sub-ufixnum) -> (void)]] [flags])
  (clear-input-port [sig [() (input-port) -> (void)]] [flags true])
  (clear-output-port [sig [() (output-port) -> (void)]] [flags true])
  (collect [sig [() (sub-ufixnum) (sub-ufixnum ptr) (sub-ufixnum ptr ptr) -> (void)]] [flags true])
  (collect-rendezvous [sig [() -> (void)]] [flags])
  (collections [sig [() -> (uint)]] [flags unrestricted alloc])
  (compile [sig [(sub-ptr) (sub-ptr environment) -> (ptr ...)]] [flags])
  (compile-file [sig [(pathname) (pathname pathname) (pathname pathname sub-symbol) -> (void)]] [flags true])
  (compile-library [sig [(pathname) (pathname pathname) (pathname pathname sub-symbol) -> (void)]] [flags true])
  (compile-port [sig [(textual-input-port binary-output-port) (textual-input-port binary-output-port maybe-sfd) (textual-input-port binary-output-port maybe-sfd maybe-binary-output-port) (textual-input-port binary-output-port maybe-sfd maybe-binary-output-port maybe-textual-output-port) (textual-input-port binary-output-port maybe-sfd maybe-binary-output-port maybe-textual-output-port sub-symbol) (textual-input-port binary-output-port maybe-sfd maybe-binary-output-port maybe-textual-output-port sub-symbol maybe-binary-output-port) -> (void)]] [flags true])
  (compile-program [sig [(pathname) (pathname pathname) (pathname pathname sub-symbol) -> (list)]] [flags true])
  (compile-script [sig [(pathname) (pathname pathname) (pathname pathname sub-symbol) -> (void)]] [flags true])
  (compile-time-value? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (compile-time-value-value [sig [(compile-time-value) -> (ptr)]] [flags pure mifoldable discard])
  (compile-to-file [sig [(list pathname) (list pathname maybe-sfd) -> (ptr)]] [flags true])
  (compile-to-port [sig [(list binary-output-port) (list binary-output-port maybe-sfd) (list binary-output-port maybe-sfd maybe-binary-output-port) (list binary-output-port maybe-sfd maybe-binary-output-port maybe-textual-output-port) (list binary-output-port maybe-sfd maybe-binary-output-port maybe-textual-output-port sub-symbol) (list binary-output-port maybe-sfd maybe-binary-output-port maybe-textual-output-port sub-symbol maybe-binary-output-port) -> (ptr)]] [flags true])
  (compile-whole-program [sig [(string string) (string string ptr) -> (list)]] [flags])
  (compile-whole-library [sig [(string string) -> (list)]] [flags])
  (compute-composition [sig [(ptr) -> (list)] [(ptr sub-ufixnum) -> (list)]] [flags alloc])
  (compute-size [sig [(ptr) -> (uint)] [(ptr sub-ufixnum) -> (uint)]] [flags alloc])
  (concatenate-object-files [sig [(pathname pathname pathname ...) -> (void)]] [flags true])
  (condition-broadcast [feature pthreads] [sig [(condition-object) -> (void)]] [flags true])
  (condition-continuation [sig [(continuation-condition) -> (ptr)]] [flags pure mifoldable discard])
  (condition-name [feature pthreads] [sig [(condition-object) -> (maybe-symbol)]] [flags pure])
  (condition-signal [feature pthreads] [sig [(condition-object) -> (void)]] [flags true])
  (condition-wait [feature pthreads] [sig [(condition-object mutex) (condition-object mutex maybe-timeout) -> (boolean)]] [flags])
  (conjugate [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (continuation-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (copy-environment [sig [(environment) (environment ptr) (environment ptr list-of-symbols) -> (environment)]] [flags alloc])
  (copy-time [sig [(time) -> (time)]] [flags alloc])
  (cosh [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (cost-center? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (cost-center-allocation-count [sig [(cost-center) -> (number)]] [flags mifoldable discard true])
  (cost-center-instruction-count [sig [(cost-center) -> (number)]] [flags mifoldable discard true])
  (cost-center-time [sig [(cost-center) -> (time)]] [flags mifoldable discard true])
  (cpu-time [sig [() -> (uint)]] [flags unrestricted alloc])
  (create-exception-state [sig [() (procedure) -> (void)]] [flags alloc])
  (current-memory-bytes [sig [() -> (uint)]] [flags alloc])
  (date-and-time [sig [() (date) -> (string)]] [flags unrestricted alloc])
  (datum->syntax-object [sig [(identifier ptr) -> (ptr)]] [flags pure mifoldable discard true])
  (debug [sig [() -> (void)]] [flags])
  (debug-condition [sig [() -> (ptr)] [(ptr) -> (void)]] [flags unrestricted])
  (decode-float [sig [(flonum) -> (vector)]] [flags pure mifoldable discard true])
  (default-exception-handler [sig [(ptr) -> (void)]] [flags unrestricted])
  (default-prompt-and-read [sig [(sub-integer) -> (ptr)]] [flags])
  (define-top-level-syntax [sig [(symbol ptr) (symbol ptr environment) -> (void)]] [flags true])
  (define-top-level-value [sig [(symbol ptr) (symbol ptr environment) -> (void)]] [flags true])
  (delete-directory [sig [(pathname) (pathname ptr) -> (ptr)]] [flags])
  (delete-file [sig [(pathname) (pathname ptr) -> (ptr)]] [flags])
  (directory-list [sig [(pathname) -> (list)]] [flags alloc])
  (directory-separator? [sig [(char) -> (boolean)]] [flags discard cp02])
  (disable-interrupts [sig [() -> (uint)]] [flags true])
  (display-condition [sig [(ptr) (ptr textual-output-port) -> (void)]] [flags])
  (display-statistics [sig [() (textual-output-port) -> (void)]] [flags true])
  (display-string [sig [(string) (string textual-output-port) -> (void)]] [flags true])
  (dynamic-wind [sig [(procedure procedure procedure) (ptr procedure procedure procedure) -> (ptr ...)]] [flags ieee r5rs])
  (enable-interrupts [sig [() -> (uint)]] [flags true])
  (engine-block [sig [() -> (ptr)]] [flags])
  (engine-return [sig [(ptr ...) -> (bottom)]] [flags abort-op])
  (enumerate [sig [(list) -> (list)]] [flags alloc])
  (enum-set? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (environment? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (environment-mutable? [sig [(environment) -> (boolean)]] [flags pure mifoldable discard])
  (environment-symbols [sig [(environment) -> (list)]] [flags true])
  (ephemeron-cons [sig [(ptr ptr) -> (ptr)]] [flags unrestricted alloc])
  (ephemeron-pair? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (errorf [sig [(who string sub-ptr ...) -> (bottom)]] [flags abort-op]) ; second arg is format string
  (eq-hashtable? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (eq-hashtable-cell [sig [(eq-hashtable ptr ptr) -> ((ptr . ptr))]] [flags true])
  (eq-hashtable-contains? [sig [(eq-hashtable ptr) -> (boolean)]] [flags discard])
  (eq-hashtable-delete! [sig [(eq-hashtable ptr) -> (void)]] [flags true])
  (eq-hashtable-ephemeron? [sig [(eq-hashtable) -> (boolean)]] [flags pure mifoldable discard])
  (eq-hashtable-ref [sig [(eq-hashtable ptr ptr) -> (ptr)]] [flags discard])
  (eq-hashtable-set! [sig [(eq-hashtable ptr ptr) -> (void)]] [flags true])
  (eq-hashtable-update! [sig [(eq-hashtable ptr procedure ptr) -> (void)]] [flags])
  (eq-hashtable-weak? [sig [(eq-hashtable) -> (boolean)]] [flags pure mifoldable discard])
  (eval [sig [(ptr) (ptr environment) -> (ptr ...)]] [flags])  ; not restricted to two arguments
  (exit [sig [(ptr ...) -> (bottom)]] [flags abort-op]) ; not restricted to 0 or 1 argument
  (expand [sig [(ptr) (ptr environment) (ptr environment ptr) (ptr environment ptr ptr) (ptr environment ptr ptr maybe-string) -> (ptr)]] [flags])
  (expand/optimize [sig [(ptr) (ptr environment) -> (ptr)]] [flags])
  (expt-mod [sig [(integer integer integer) -> (integer)]] [flags arith-op mifoldable discard])
  (fasl-file [sig [(pathname pathname) -> (void)]] [flags true])
  (fasl-read [sig [(binary-input-port) (binary-input-port sub-symbol) -> (ptr)]] [flags])
  (fasl-write [sig [(sub-ptr binary-output-port) -> (void)]] [flags true])
  (file-access-time [sig [(pathname) (pathname ptr) -> (time)]] [flags discard])
  (file-change-time [sig [(pathname) (pathname ptr) -> (time)]] [flags discard])
  (file-directory? [sig [(pathname) (pathname ptr) -> (boolean)]] [flags discard])
  (file-exists? [sig [(pathname) (pathname ptr) -> (boolean)]] [flags discard])
  (file-length [sig [(sub-port) -> (uint)]] [flags])
  (file-modification-time [sig [(pathname) (pathname ptr) -> (time)]] [flags discard])
  (file-position [sig [(sub-port) -> (sub-ptr)] [(sub-port sub-ptr) -> (void)]] [flags])
  (file-port? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (port-file-compressed! [sig [(port) -> (void)]] [flags])
  (file-regular? [sig [(pathname) (pathname ptr) -> (boolean)]] [flags discard])
  (file-symbolic-link? [sig [(pathname) -> (boolean)]] [flags discard])
  (fllp [sig [(flonum) -> (ufixnum)]] [flags arith-op mifoldable discard])
  (fl-make-rectangular [sig [(flonum flonum) -> (inexactnum)]] [flags arith-op mifoldable discard])
  (flonum->fixnum [sig [(flonum) -> (fixnum)]] [flags arith-op cp02])
  (flnonpositive? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (flnonnegative? [sig [(flonum) -> (boolean)]] [flags pure mifoldable discard])
  (fl= [sig [(flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])   ; not restricted to 2+ arguments
  (fl< [sig [(flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])   ; not restricted to 2+ arguments
  (fl<= [sig [(flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])  ; not restricted to 2+ arguments
  (fl> [sig [(flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])   ; not restricted to 2+ arguments
  (fl>= [sig [(flonum flonum ...) -> (boolean)]] [flags pure mifoldable discard])  ; not restricted to 2+ arguments
  (flush-output-port [sig [() (output-port) -> (void)]] [flags true])   ; not restricted to 1 argument
  (foreign-entry? [sig [(string) -> (boolean)]] [flags discard])
  (foreign-entry [sig [(string) -> (uptr)]] [flags discard true])
  (foreign-address-name [sig [(uptr/iptr) -> (maybe-string)]] [flags discard])
  (foreign-callable-entry-point [sig [(code) -> (uint)]] [flags discard])
  (foreign-callable-code-object [sig [(sint) -> (code)]] [flags discard])
  (foreign-alloc [sig [(pfixnum) -> (uint)]] [flags discard true])
  (foreign-free [sig [(sub-uint) -> (void)]] [flags true])
  (foreign-ref [sig [(sub-symbol uptr/iptr uptr/iptr) -> (ptr)]] [flags])
  (foreign-set! [sig [(sub-symbol uptr/iptr uptr/iptr sub-ptr) -> (void)]] [flags true])
  (foreign-sizeof [sig [(sub-symbol) -> (fixnum)]] [flags pure true cp02])
  (fork-thread [feature pthreads] [sig [(procedure) -> (thread)]] [flags true])
  (format [sig [(sub-ptr sub-ptr ...) -> (string)]] [flags])
  (format-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (fprintf [sig [(textual-output-port string sub-ptr ...) -> (void)]] [flags true])
  (fresh-line [sig [() (textual-output-port) -> (void)]] [flags true])
  (ftype-pointer=? [sig [(ftype-pointer ftype-pointer) -> (boolean)]] [flags pure mifoldable discard cp03])
  (ftype-pointer-address [sig [(ftype-pointer) -> (exact-integer)]] [flags mifoldable discard true])
  (ftype-pointer-ftype [sig [(ftype-pointer) -> (ptr)]] [flags mifoldable discard true])
  (ftype-pointer-null? [sig [(ftype-pointer) -> (boolean)]] [flags pure mifoldable discard])
  (ftype-pointer->sexpr [sig [(ftype-pointer) -> (ptr)]] [flags true])
  (fx* [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])  ; not restricted to 2 arguments
  (fx+ [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])  ; not restricted to 2 arguments
  (fx- [sig [(fixnum fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])  ; not restricted to 1 or 2 arguments
  (fx/ [sig [(fixnum fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])  ; not restricted to 1 or 2 arguments
  (fx1+ [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fx1- [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fx< [sig [(fixnum fixnum ...) -> (boolean)]] [flags pure cp02])   ; not restricted to 2+ arguments
  (fx<= [sig [(fixnum fixnum ...) -> (boolean)]] [flags pure cp02])  ; not restricted to 2+ arguments
  (fx= [sig [(fixnum fixnum ...) -> (boolean)]] [flags pure cp02])   ; not restricted to 2+ arguments
  (fx> [sig [(fixnum fixnum ...) -> (boolean)]] [flags pure cp02])   ; not restricted to 2+ arguments
  (fx>= [sig [(fixnum fixnum ...) -> (boolean)]] [flags pure cp02])  ; not restricted to 2+ arguments
  (fxabs [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxlogand [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxlogbit? [sig [(ufixnum fixnum) -> (boolean)]] [flags pure cp02])
  (fxlogbit0 [sig [(sub-ufixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxlogbit1 [sig [(sub-ufixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxlogior [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxlognot [sig [(fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxlogor [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxlogtest [sig [(fixnum fixnum) -> (boolean)]] [flags pure cp02])
  (fxlogxor [sig [(fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxmodulo [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxnonnegative? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxnonpositive? [sig [(fixnum) -> (boolean)]] [flags pure cp02])
  (fxquotient [sig [(fixnum fixnum ...) -> (fixnum)]] [flags arith-op partial-folder])
  (fxremainder [sig [(fixnum fixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxsll [sig [(fixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxsra [sig [(fixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxsrl [sig [(fixnum sub-ufixnum) -> (fixnum)]] [flags arith-op cp02])
  (fxvector [sig [(fixnum ...) -> (fxvector)]] [flags alloc cp02])
  (fxvector->list [sig [(fxvector) -> (list)]] [flags alloc])
  (fxvector-copy [sig [(fxvector) -> (fxvector)]] [flags alloc])
  (fxvector-fill! [sig [(fxvector fixnum) -> (void)]] [flags true])
  (fxvector->immutable-fxvector [sig [(fxvector) -> (fxvector)]] [flags alloc])
  (fxvector-length [sig [(fxvector) -> (length)]] [flags pure mifoldable discard true])
  (fxvector-ref [sig [(fxvector sub-index) -> (fixnum)]] [flags mifoldable discard cp02])
  (fxvector-set! [sig [(fxvector sub-index fixnum) -> (void)]] [flags true])
  (fxvector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (gensym [sig [() (string) (string string) -> (gensym)]] [flags alloc])
  (gensym? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (gensym->unique-string [sig [(gensym) -> (string)]] [flags true mifoldable]) ; can't discard ... if we have our hands on it, it must be in the oblist after this
  (get-bytevector-some! [sig [(binary-input-port bytevector length length) -> (ptr)]] [flags true])
  (get-datum/annotations [sig [(textual-input-port sfd uint) -> (ptr uint)]] [flags])
  (get-hash-table [sig [(old-hash-table ptr ptr) -> (ptr)]] [flags discard])
  (get-mode [sig [(pathname) (pathname ptr) -> (fixnum)]] [flags])
  (get-output-string [sig [(sub-textual-output-port) -> (string)]] [flags true])
  (get-registry [feature windows] [sig [(string) -> (maybe-string)]] [flags  discard])
  (get-source-table! [sig [(textual-input-port source-table) (textual-input-port source-table maybe-procedure) -> (void)]] [flags true])
  (get-string-some [sig [(textual-input-port) -> (ptr)]] [flags true])
  (get-string-some! [sig [(textual-input-port string length length) -> (ptr)]] [flags true])
  (getenv [sig [(string) -> (maybe-string)]] [flags discard])
  (getprop [sig [(symbol ptr) (symbol ptr ptr) -> (ptr)]] [flags discard])
  (guardian? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (hash-table? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (hashtable-ephemeron? [sig [(hashtable) -> (boolean)]] [flags pure mifoldable discard])
  (hash-table-for-each [sig [(old-hash-table procedure) -> (void)]] [flags])
  (hash-table-map [sig [(old-hash-table procedure) -> (list)]] [flags true])
  (hashtable-cell [sig [(old-hash-table ptr ptr) -> ((ptr . ptr))]] [flags true])
  (hashtable-cells [sig [(hashtable) -> (vector)] [(hashtable uint) -> (vector)]] [flags alloc])
  (hashtable-entries [sig [(hashtable) -> (vector vector)] [(hashtable uint) -> (vector vector)]] [flags alloc]) ; has size argument
  (hashtable-keys [sig [(hashtable) -> (vector)] [(hashtable uint) -> (vector)]] [flags alloc])                  ; has size argument
  (hashtable-values [sig [(hashtable) -> (vector)] [(hashtable uint) -> (vector)]] [flags alloc])
  (hashtable-weak? [sig [(hashtable) -> (boolean)]] [flags pure mifoldable discard])
  (iconv-codec [feature iconv] [sig [(sub-string) -> (codec)]] [flags pure true])
  (ieee-environment [sig [() -> (environment)]] [flags unrestricted alloc])
  (immutable-string? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (immutable-box? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (immutable-vector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (immutable-fxvector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (immutable-bytevector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (initial-bytes-allocated [sig [() -> (uint)]] [flags unrestricted alloc])
  (input-port-ready? [sig [(input-port) -> (boolean)]] [flags])
  (inspect [sig [(ptr) -> (void)]] [flags unrestricted])
  (inspect/object [sig [(ptr) -> (procedure)]] [flags unrestricted])
  (integer-length [sig [(sint) -> (uint)]] [flags arith-op mifoldable discard])
  (interactive? [sig [() -> (boolean)]] [flags unrestricted])
  (interpret [sig [(ptr) (ptr environment) -> (ptr ...)]] [flags])
  (iota [sig [(ufixnum) -> (list)]] [flags alloc])
  (isqrt [sig [(uinteger) -> (integer)]] [flags arith-op mifoldable discard])
  (last-pair [sig [(pair) -> ((ptr . ptr))]] [flags mifoldable discard])
  (list* [sig [(ptr) -> (ptr)] [(ptr ptr ptr ...) -> ((ptr . ptr))]] [flags unrestricted discard cp02])
  (list->fxvector [sig [(sub-list) -> (fxvector)]] [flags alloc])
  (list-copy [sig [(list) -> (list)]] [flags alloc])
  (list-head [sig [(sub-ptr sub-index) -> (ptr)]] [flags alloc])
  (literal-identifier=? [sig [(identifier identifier) -> (boolean)]] [flags pure mifoldable discard cp03])
  (load [sig [(pathname) (pathname procedure) -> (void)]] [flags true ieee r5rs])
  (load-compiled-from-port [sig [(ptr) -> (ptr ...)]] [flags])
  (load-library [sig [(pathname) (pathname procedure) -> (void)]] [flags true])
  (load-program [sig [(pathname) (pathname procedure) -> (void)]] [flags true])
  (load-shared-object [sig [(maybe-pathname) -> (void)]] [flags true])
  (locate-source [sig [(sfd uint) (sfd uint ptr) -> ()] [(sfd uint) (sfd uint ptr) -> (string uint uint)]] [flags])
  (locate-source-object-source [sig [(source-object ptr ptr) -> ()] [(source-object ptr ptr) -> (string uint uint)]] [flags])
  (lock-object [sig [(ptr) -> (void)]] [flags unrestricted true])
  (locked-object? [sig [(ptr) -> (boolean)]] [flags unrestricted discard])
  (logand [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (logbit? [sig [(uint sint) -> (boolean)]] [flags pure mifoldable discard])
  (logbit0 [sig [(uint sint) -> (sint)]] [flags arith-op mifoldable discard])
  (logbit1 [sig [(uint sint) -> (sint)]] [flags arith-op mifoldable discard])
  (logior [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (lognot [sig [(sint) -> (sint)]] [flags arith-op mifoldable discard])
  (logor [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (logtest [sig [(sint sint) -> (boolean)]] [flags pure mifoldable discard])
  (logxor [sig [(sint ...) -> (sint)]] [flags arith-op partial-folder])
  (magnitude-squared [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (make-annotation [sig [(ptr source-object ptr) (ptr source-object ptr annotation-options) -> (annotation)]] [flags pure true mifoldable discard])
  (make-boot-file [sig [(pathname sub-list pathname ...) -> (void)]] [flags true])
  (make-boot-header [sig [(pathname pathname pathname ...) -> (void)]] [flags true])
  (make-compile-time-value [sig [(ptr) -> (compile-time-value)]] [flags pure unrestricted alloc])
  (make-condition [feature pthreads] [sig [() (maybe-symbol) -> (condition-object)]] [flags pure unrestricted alloc])
  (make-continuation-condition [sig [(ptr) -> (condition)]] [flags pure unrestricted mifoldable discard])
  (make-cost-center [sig [() -> (cost-center)]] [flags unrestricted alloc])
  (make-source-table [sig [() -> (source-table)]] [flags unrestricted alloc])
  (make-ephemeron-eq-hashtable [sig [() (uint) -> (eq-hashtable)]] [flags alloc])
  (make-ephemeron-eqv-hashtable [sig [() (uint) -> (hashtable)]] [flags alloc])
  (make-engine [sig [(procedure) -> (engine)]] [flags pure alloc])
  (make-format-condition [sig [() -> (condition)]] [flags pure unrestricted mifoldable discard])
  (make-fxvector [sig [(length) (length fixnum) -> (fxvector)]] [flags alloc])
  (make-guardian [sig [() -> (procedure)]] [flags unrestricted alloc cp02])
  (make-hash-table [sig [() (ptr) -> (old-hash-table)]] [flags unrestricted alloc])
  (make-input-port [sig [(procedure string) -> (textual-input-port)]] [flags alloc])
  (make-input/output-port [sig [(procedure string string) -> (textual-input/output-port)]] [flags alloc])
  (make-list [sig [(length) (length ptr) -> (list)]] [flags alloc])
  (make-mutex [feature pthreads] [sig [() (maybe-symbol) -> (mutex)]] [flags unrestricted alloc])
  (make-object-finder [sig [(procedure) (procedure ptr) (procedure ptr sub-ufixnum) -> (procedure)]] [flags alloc])
  (make-output-port [sig [(procedure string) -> (textual-output-port)]] [flags alloc])
  (make-parameter [sig [(ptr) (ptr procedure) -> (procedure)]] [flags true cp02 cp03])
  (make-record-type [sig [(sub-ptr sub-list) (maybe-rtd sub-ptr sub-list) -> (rtd)]] [flags pure alloc cp02])
  (make-source-condition [sig [(ptr) -> (condition)]] [flags pure unrestricted mifoldable discard])
  (make-source-file-descriptor [sig [(string binary-input-port) (string binary-input-port ptr) -> (sfd)]] [flags true])
  (make-source-object [sig [(sfd uint uint) (sfd uint uint nzuint nzuint) -> (source-object)]] [flags pure true mifoldable discard])
  (make-sstats [sig [(time time exact-integer exact-integer time time exact-integer) -> (sstats)]] [flags alloc])
  (make-thread-parameter [feature pthreads] [sig [(ptr) (ptr procedure) -> (ptr)]] [flags true cp02 cp03])
  (make-weak-eq-hashtable [sig [() (uint) -> (eq-hashtable)]] [flags alloc])
  (make-weak-eqv-hashtable [sig [() (uint) -> (hashtable)]] [flags alloc])
  (mark-port-closed! [sig [(port) -> (void)]] [flags true])
  (maximum-memory-bytes [sig [() -> (uint)]] [flags alloc])
  (maybe-compile-file [sig [(pathname) (pathname pathname) -> (void)]] [flags true])
  (maybe-compile-library [sig [(pathname) (pathname pathname) -> (void)]] [flags true])
  (maybe-compile-program [sig [(pathname) (pathname pathname) -> (void)]] [flags true])
  (merge [sig [(procedure list list) -> (list)]] [flags true])
  (merge! [sig [(procedure list list) -> (list)]] [flags true])
  (mkdir [sig [(pathname) (pathname sub-uint) -> (void)]] [flags])
  (multibyte->string [feature windows] [sig [(sub-ptr bytevector) -> (string)]] [flags true discard])
  (mutable-box? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (mutable-string? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (mutable-fxvector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (mutable-bytevector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (mutable-vector? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (mutex-acquire [feature pthreads] [sig [(mutex) (mutex ptr) -> (ptr)]] [flags]) ; can return #f if optional block? arg is #f
  (mutex-name [feature pthreads] [sig [(mutex) -> (maybe-symbol)]] [flags pure])
  (mutex-release [feature pthreads] [sig [(mutex) -> (void)]] [flags true])
  (mutex? [feature pthreads] [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (new-cafe [sig [() (procedure) -> (ptr ...)]] [flags])
  (nonnegative? [sig [(real) -> (boolean)]] [flags pure mifoldable discard])
  (nonpositive? [sig [(real) -> (boolean)]] [flags pure mifoldable discard])
  (number->string [sig [(number) (number sub-ufixnum) (number sub-ufixnum sub-ufixnum) -> (string)]] [flags alloc])  ; radix not restricted to 2, 4, 8, 16
  (object-counts [sig [() -> (ptr)]] [flags alloc])
  (oblist [sig [() -> (list)]] [flags alloc])
  (open-fd-input-port [sig [(sub-ufixnum) (sub-ufixnum sub-symbol) (sub-ufixnum sub-symbol maybe-transcoder) -> (input-port)]] [flags true])
  (open-fd-input/output-port [sig [(sub-ufixnum) (sub-ufixnum sub-symbol) (sub-ufixnum sub-symbol maybe-transcoder) -> (input/output-port)]] [flags true])
  (open-fd-output-port [sig [(sub-ufixnum) (sub-ufixnum sub-symbol) (sub-ufixnum sub-symbol maybe-transcoder) -> (output-port)]] [flags true])
  (open-input-file [sig [(pathname) (pathname sub-ptr) -> (textual-input-port)]] [flags true])    ; has options argument
  (open-input-output-file [sig [(pathname) (pathname sub-ptr) -> (textual-input/output-port)]] [flags true])
  (open-input-string [sig [(string) -> (textual-input-port)]] [flags alloc])
  (open-output-file [sig [(pathname) (pathname sub-ptr) -> (textual-output-port)]] [flags true])   ; has options argument
  (open-output-string [sig [() -> (textual-output-port)]] [flags unrestricted alloc])
  (open-process-ports [sig [(string) (string sub-symbol) (string sub-symbol maybe-transcoder) -> (input-port output-port output-port ufixnum)]] [flags])
  (open-source-file [sig [(sfd) -> (ptr)]] [flags true])
  (ormap [sig [(procedure list list ...) -> (ptr ...)]] [flags cp03])
  (path-absolute? [sig [(pathname) -> (boolean)]] [flags #;cp02])         ; need cp0 handlers to fold path operators machine-independently
  (path-extension [sig [(pathname) -> (pathname)]] [flags true #;cp02])   ; it's probably not worth the effort
  (path-first [sig [(pathname) -> (pathname)]] [flags true #;cp02])
  (path-last [sig [(pathname) -> (pathname)]] [flags true #;cp02])
  (path-parent [sig [(pathname) -> (pathname)]] [flags true #;cp02])
  (path-rest [sig [(pathname) -> (pathname)]] [flags true #;cp02])
  (path-root [sig [(pathname) -> (pathname)]] [flags true #;cp02])
  (port-bol? [sig [(textual-output-port) -> (boolean)]] [flags discard])
  (port-closed? [sig [(port) -> (boolean)]] [flags discard])
  (port-file-descriptor [sig [(port) -> (ufixnum)]] [flags discard])
  (port-handler [sig [(port) -> (procedure)]] [flags discard])
  (port-has-port-length? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (port-has-port-nonblocking?? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (port-has-set-port-length!? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (port-has-set-port-nonblocking!? [sig [(port) -> (boolean)]] [flags pure mifoldable discard])
  (port-input-buffer [sig [(port) -> (ptr)]] [flags discard true])
  (port-input-count [sig [(port) -> (ufixnum)]] [flags discard true])
  (port-input-empty? [sig [(input-port) -> (boolean)]] [flags discard])
  (port-input-index [sig [(port) -> (ufixnum)]] [flags discard true])
  (port-input-size [sig [(port) -> (ufixnum)]] [flags discard true])
  (port-length [sig [(port) -> (uint)]] [flags])
  (port-name [sig [(port) -> (ptr)]] [flags mifoldable discard])
  (port-nonblocking? [sig [(port) -> (boolean)]] [flags discard])
  (port-output-buffer [sig [(port) -> (ptr)]] [flags discard true])
  (port-output-count [sig [(port) -> (ufixnum)]] [flags discard true])
  (port-output-full? [sig [(output-port) -> (boolean)]] [flags discard])
  (port-output-index [sig [(port) -> (ufixnum)]] [flags discard true])
  (port-output-size [sig [(port) -> (ufixnum)]] [flags discard true])
  (pretty-file [sig [(pathname pathname) -> (void)]] [flags true])
  (pretty-format [sig [(symbol) -> (ptr)] [(symbol sub-ptr) -> (void)]] [flags])
  (pretty-print [sig [(ptr) (ptr textual-output-port) -> (void)]] [flags true])
  (printf [sig [(string sub-ptr ...) -> (void)]] [flags true])
  (procedure-arity-mask [sig [(procedure) -> (sint)]] [flags mifoldable discard true])
  (process [sig [(string) -> (list)]] [flags])
  (profile-clear [sig [() -> (void)]] [flags true])
  (profile-clear-database [sig [() -> (void)]] [flags true])
  (profile-dump [sig [() -> (list)]] [flags discard true])
  (profile-dump-data [sig [(pathname) (pathname sub-list) -> (void)]] [flags true])
  (profile-dump-html [sig [() (pathname) (pathname sub-list) -> (void)]] [flags true])
  (profile-dump-list [sig [() (ptr) (ptr sub-list) -> (list)]] [flags discard true])
  (profile-load-data [sig [(pathname ...) -> (void)]] [flags true])
  (profile-release-counters [sig [() -> (void)]] [flags true])
  (property-list [sig [(symbol) -> (list)]] [flags discard true])
  (put-bytevector-some [sig [(binary-output-port bytevector) (binary-output-port bytevector length) (binary-output-port bytevector length length) -> (uint)]] [flags true])
  (put-hash-table! [sig [(old-hash-table ptr ptr) -> (void)]] [flags true])
  (put-source-table [sig [(textual-output-port source-table) -> (void)]] [flags true])
  (put-registry! [feature windows] [sig [(string string) -> (void)]] [flags true])
  (put-string-some [sig [(textual-output-port string) (textual-output-port string length) (textual-output-port string length length) -> (uint)]] [flags true])
  (putprop [sig [(symbol ptr ptr) -> (void)]] [flags true])
  (putenv [sig [(string string) -> (void)]] [flags true])
  (profile-query-weight [sig [(ptr) -> (maybe-flonum)]] [flags unrestricted discard])
  (random [sig [(sub-number) -> (number)]] [flags alloc])
  (ratnum? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (read-token [sig [() (textual-input-port) (textual-input-port sfd uint) -> (symbol ptr maybe-uint maybe-uint)]] [flags])
  (real-time [sig [() -> (uint)]] [flags unrestricted alloc])
  (record? [sig [(ptr) (ptr rtd) -> (boolean)]] [flags pure mifoldable discard cp02])
  (record-constructor [sig [(sub-ptr) -> (procedure)]] [flags cp02]) ; accepts rtd or rcd
  (record-constructor-descriptor? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard cp02])
  (record-equal-procedure [sig [(record record) -> (maybe-procedure)]] [flags discard])
  (record-hash-procedure [sig [(record) -> (maybe-procedure)]] [flags discard])
  (record-reader [sig [(sub-ptr) -> (ptr)] [(sub-ptr sub-ptr) -> (void)]] [flags])
  (record-type-equal-procedure [sig [(rtd) -> (maybe-procedure)] [(rtd maybe-procedure) -> (void)]] [flags])
  (record-type-hash-procedure [sig [(rtd) -> (maybe-procedure)] [(rtd maybe-procedure) -> (void)]] [flags])
  (record-writer [sig [(rtd) -> (maybe-procedure)] [(rtd maybe-procedure) -> (void)]] [flags])
  (register-signal-handler [sig [(sint procedure) -> (void)]] [flags])
  (remove-foreign-entry [sig [(string) -> (void)]] [flags true])
  (remove-hash-table! [sig [(old-hash-table ptr) -> (void)]] [flags true])
  (remove-registry! [feature windows] [sig [(string) -> (void)]] [flags true])
  (remove! [sig [(ptr list) -> (list)]] [flags true])
  (remprop [sig [(symbol ptr) -> (void)]] [flags])
  (remq! [sig [(ptr list) -> (list)]] [flags true])
  (remv! [sig [(ptr list) -> (list)]] [flags true])
  (rename-file [sig [(pathname ptr) -> (void)]] [flags])
  (reset [sig [() -> (bottom)]] [flags abort-op])
  (reset-cost-center! [sig [(cost-center) -> (void)]] [flags true])
  (reset-maximum-memory-bytes! [sig [() -> (void)]] [flags true])
  (reverse! [sig [(list) -> (list)]] [flags true])
  (revisit [sig [(pathname) -> (void)]] [flags true])
  (revisit-compiled-from-port [sig [(ptr) -> (ptr ...)]] [flags])
  (s8-list->bytevector [sig [(sub-list) -> (bytevector)]] [flags alloc])
  (sc-expand [sig [(ptr) (ptr environment) (ptr environment ptr) (ptr environment ptr ptr) (ptr environment ptr ptr maybe-string) -> (ptr)]] [flags])
  (scheme-environment [sig [() -> (environment)]] [flags unrestricted alloc])
  (set-binary-port-input-buffer! [sig [(binary-input-port bytevector) -> (void)]] [flags true])
  (set-binary-port-input-index! [sig [(binary-input-port sub-index) -> (void)]] [flags true])
  (set-binary-port-input-size! [sig [(binary-input-port sub-length) -> (void)]] [flags true])
  (set-binary-port-output-buffer! [sig [(binary-output-port bytevector) -> (void)]] [flags true])
  (set-binary-port-output-index! [sig [(binary-output-port sub-index) -> (void)]] [flags true])
  (set-binary-port-output-size! [sig [(binary-output-port sub-length) -> (void)]] [flags true])
  (set-box! [sig [(box ptr) -> (void)]] [flags true])
  (set-port-bol! [sig [(textual-output-port ptr) -> (void)]] [flags true])
  (set-port-eof! [sig [(input-port ptr) -> (void)]] [flags true])
  (set-port-input-buffer! [sig [(input-port sub-ptr) -> (void)]] [flags true])
  (set-port-input-index! [sig [(input-port sub-index) -> (void)]] [flags true])
  (set-port-input-size! [sig [(input-port sub-length) -> (void)]] [flags true])
  (set-port-length! [sig [(sub-port uint) -> (void)]] [flags])
  (set-port-name! [sig [(port ptr) -> (void)]] [flags true])
  (set-port-nonblocking! [sig [(port ptr) -> (void)]] [flags])
  (set-port-output-buffer! [sig [(output-port sub-ptr) -> (void)]] [flags true])
  (set-port-output-index! [sig [(output-port sub-index) -> (void)]] [flags true])
  (set-port-output-size! [sig [(output-port sub-length) -> (void)]] [flags true])
  (set-sstats-bytes! [sig [(sstats exact-integer) -> (void)]] [flags true])
  (set-sstats-cpu! [sig [(sstats time) -> (void)]] [flags true])
  (set-sstats-gc-bytes! [sig [(sstats exact-integer) -> (void)]] [flags true])
  (set-sstats-gc-count! [sig [(sstats exact-integer) -> (void)]] [flags true])
  (set-sstats-gc-cpu! [sig [(sstats time) -> (void)]] [flags true])
  (set-sstats-gc-real! [sig [(sstats time) -> (void)]] [flags true])
  (set-sstats-real! [sig [(sstats time) -> (void)]] [flags true])
  (set-textual-port-input-buffer! [sig [(textual-input-port string) -> (void)]] [flags true])
  (set-textual-port-input-index! [sig [(textual-input-port sub-index) -> (void)]] [flags true])
  (set-textual-port-input-size! [sig [(textual-input-port sub-length) -> (void)]] [flags true])
  (set-textual-port-output-buffer! [sig [(textual-output-port string) -> (void)]] [flags true])
  (set-textual-port-output-index! [sig [(textual-output-port sub-index) -> (void)]] [flags true])
  (set-textual-port-output-size! [sig [(textual-output-port sub-length) -> (void)]] [flags true])
  (set-timer [sig [(ufixnum) -> (ufixnum)]] [flags true])
  (set-top-level-value! [sig [(symbol ptr) (symbol ptr environment) -> (void)]] [flags true])
  (set-virtual-register! [sig [(sub-index ptr) -> (void)]] [flags true])
  (sinh [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (sleep [sig [(time) -> (void)]] [flags true])
  (sort [sig [(procedure list) -> (list)]] [flags true])
  (sort! [sig [(procedure list) -> (list)]] [flags true])
  (source-condition? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (source-condition-form [sig [(source-condition) -> (ptr)]] [flags pure mifoldable discard])
  (source-file-descriptor [sig [(string uint) -> (sfd)]] [flags alloc])
  (source-file-descriptor? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (source-file-descriptor-checksum [sig [(sfd) -> (ptr)]] [flags pure mifoldable discard true])
  (source-file-descriptor-path [sig [(sfd) -> (ptr)]] [flags pure mifoldable discard true])
  (source-object? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (source-object-bfp [sig [(source-object) -> (uint)]] [flags pure mifoldable discard])
  (source-object-column [sig [(source-object) -> (ptr)]] [flags pure mifoldable discard])
  (source-object-efp [sig [(source-object) -> (uint)]] [flags pure mifoldable discard])
  (source-object-line [sig [(source-object) -> (ptr)]] [flags pure mifoldable discard])
  (source-object-sfd [sig [(source-object) -> (sfd)]] [flags pure mifoldable discard])
  (source-table? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (source-table-contains? [sig [(source-table source-object) -> (boolean)]] [flags discard])
  (source-table-cell [sig [(source-table source-object ptr) -> ((ptr . ptr))]] [flags true])
  (source-table-delete! [sig [(source-table source-object) -> (void)]] [flags true])
  (source-table-dump [sig [(source-table) -> (list)]] [flags alloc])
  (source-table-ref [sig [(source-table source-object ptr) -> (ptr)]] [flags discard])
  (source-table-set! [sig [(source-table source-object ptr) -> (void)]] [flags true])
  (source-table-size [sig [(source-table) -> (length)]] [flags discard true])
  (sstats-bytes [sig [(sstats) -> (exact-integer)]] [flags mifoldable discard])
  (sstats-cpu [sig [(sstats) -> (time)]] [flags mifoldable discard])
  (sstats-difference [sig [(sstats sstats) -> (sstats)]] [flags mifoldable discard true])
  (sstats-gc-bytes [sig [(sstats) -> (exact-integer)]] [flags mifoldable discard])
  (sstats-gc-count [sig [(sstats) -> (exact-integer)]] [flags mifoldable discard])
  (sstats-gc-cpu [sig [(sstats) -> (time)]] [flags mifoldable discard])
  (sstats-gc-real [sig [(sstats) -> (time)]] [flags mifoldable discard])
  (sstats-print [sig [(sstats) (sstats textual-output-port) -> (void)]] [flags true])
  (sstats-real [sig [(sstats) -> (time)]] [flags mifoldable discard])
  (sstats? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (standard-input-port [sig [() (sub-symbol) (sub-symbol maybe-transcoder) -> (input-port)]] [flags true])
  (standard-output-port [sig [() (sub-symbol) (sub-symbol maybe-transcoder) -> (output-port)]] [flags true])
  (standard-error-port [sig [() (sub-symbol) (sub-symbol maybe-transcoder) -> (output-port)]] [flags true])
  (statistics [sig [() -> (sstats)]] [flags unrestricted alloc])
  (string->multibyte [feature windows] [sig [(sub-ptr string) -> (bytevector)]] [flags true discard])
  (string->number [sig [(string) (string sub-ufixnum) -> (maybe-number)]] [flags discard]) ; radix not restricted to 2, 4, 8, 16
  (string<=? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard])        ; not restricted to 2+ arguments
  (string<? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard])         ; not restricted to 2+ arguments
  (string=? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard cp03])         ; not restricted to 2+ arguments
  (string>=? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard])        ; not restricted to 2+ arguments
  (string>? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard])         ; not restricted to 2+ arguments
  (string-ci<=? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])  ; not restricted to 2+ arguments
  (string-ci<? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])   ; not restricted to 2+ arguments
  (string-ci=? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs cp03])   ; not restricted to 2+ arguments
  (string-ci>=? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])  ; not restricted to 2+ arguments
  (string-ci>? [sig [(string string ...) -> (boolean)]] [flags mifoldable discard ieee r5rs])   ; not restricted to 2+ arguments
  (string-copy! [sig [(string sub-length string sub-length sub-length) -> (void)]] [flags true])
  (string->immutable-string [sig [(string) -> (string)]] [flags alloc])
  (string-truncate! [sig [(string length) -> (string)]] [flags true])
  (strip-fasl-file [sig [(pathname pathname fasl-strip-options) -> (void)]] [flags true])
  (sub1 [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (subst [sig [(ptr ptr ptr) -> (ptr)]] [flags alloc])
  (subst! [sig [(ptr ptr ptr) -> (ptr)]] [flags])
  (substq [sig [(ptr ptr ptr) -> (ptr)]] [flags alloc])
  (substq! [sig [(ptr ptr ptr) -> (ptr)]] [flags])
  (substring-fill! [sig [(string sub-length sub-length char) -> (void)]] [flags true])
  (substv [sig [(ptr ptr ptr) -> (ptr)]] [flags alloc])
  (substv! [sig [(ptr ptr ptr) -> (ptr)]] [flags])
  (symbol-hashtable? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (symbol-hashtable-cell [sig [(symbol-hashtable ptr ptr) -> ((ptr . ptr))]] [flags true])
  (symbol-hashtable-contains? [sig [(symbol-hashtable ptr) -> (boolean)]] [flags discard])
  (symbol-hashtable-delete! [sig [(symbol-hashtable ptr) -> (void)]] [flags true])
  (symbol-hashtable-ref [sig [(symbol-hashtable symbol ptr) -> (ptr)]] [flags discard])
  (symbol-hashtable-set! [sig [(symbol-hashtable symbol ptr) -> (void)]] [flags true])
  (symbol-hashtable-update! [sig [(symbol-hashtable symbol procedure ptr) -> (void)]] [flags])
  (syntax->annotation [sig [(ptr) -> (ptr)]] [flags pure unrestricted mifoldable discard])
  (syntax->list [sig [(ptr) -> (list)]] [flags alloc])
  (syntax->vector [sig [(ptr) -> (vector)]] [flags alloc])
  (syntax-error [sig [(ptr string ...) -> (bottom)]] [flags abort-op])
  (syntax-object->datum [sig [(ptr) -> (ptr)]] [flags pure unrestricted mifoldable discard])
  (system [sig [(string) -> (ptr)]] [flags])
  (tanh [sig [(number) -> (number)]] [flags arith-op mifoldable discard])
  (textual-port-input-buffer [sig [(textual-input-port) -> (string)]] [flags discard])
  (textual-port-input-count [sig [(textual-input-port) -> (length)]] [flags discard true])
  (textual-port-input-index [sig [(textual-input-port) -> (index)]] [flags discard])
  (textual-port-input-size [sig [(textual-input-port) -> (length)]] [flags discard])
  (textual-port-output-buffer [sig [(textual-output-port) -> (string)]] [flags discard])
  (textual-port-output-count [sig [(textual-output-port) -> (length)]] [flags discard true])
  (textual-port-output-index [sig [(textual-output-port) -> (index)]] [flags discard])
  (textual-port-output-size [sig [(textual-output-port) -> (length)]] [flags discard])
  (thread? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (thread-condition? [feature pthreads] [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (top-level-bound? [sig [(symbol) (symbol environment) -> (boolean)]] [flags discard])
  (top-level-mutable? [sig [(symbol) (symbol environment) -> (boolean)]] [flags discard])
  (top-level-syntax [sig [(symbol) (symbol environment) -> (ptr)]] [flags discard])
  (top-level-syntax? [sig [(symbol) (symbol environment) -> (boolean)]] [flags discard])
  (top-level-value [sig [(symbol) (symbol environment) -> (ptr)]] [flags discard])
  (transcoder? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (transcript-cafe [sig [(pathname) -> (ptr ...)]] [flags])
  (transcript-off [sig [() -> (void)]] [flags true ieee r5rs])
  (transcript-on [sig [(pathname) -> (void)]] [flags true ieee r5rs])
  (truncate-file [sig [(output-port) (output-port sub-ptr) -> (void)]] [flags])
  (truncate-port [sig [(output-port) (output-port sub-ptr) -> (void)]] [flags])
  (unbox [sig [(box) -> (ptr)]] [flags mifoldable discard])
  (unget-u8 [sig [(binary-input-port ptr) -> (void)]] [flags true])
  (unget-char [sig [(textual-input-port ptr) -> (void)]] [flags true])
  (unlock-object [sig [(ptr) -> (void)]] [flags unrestricted true])
  (unread-char [sig [(char) (char textual-input-port) -> (void)]] [flags true])
  (unregister-guardian [sig [(guardian) -> (list)]] [flags true])
  (utf-16-codec [sig [() -> (codec)] [(sub-symbol) -> (codec)]] [flags pure true]) ; has optional eness argument
  (utf-16le-codec [sig [() -> (codec)]] [flags pure unrestricted true])
  (utf-16be-codec [sig [() -> (codec)]] [flags pure unrestricted true])
  (vector-cas! [sig [(vector sub-index ptr ptr) -> (boolean)]] [flags])
  (vector-copy [sig [(vector) -> (vector)]] [flags alloc])
  (vector->immutable-vector [sig [(vector) -> (vector)]] [flags alloc])
  (vector-set-fixnum! [sig [(vector sub-index fixnum) -> (void)]] [flags true])
  (verify-loadability [sig [(sub-symbol sub-ptr ...) -> (void)]] [flags true])
  (virtual-register [sig [(sub-index) -> (ptr)]] [flags discard])
  (virtual-register-count [sig [() -> (length)]] [flags pure unrestricted true cp02])
  (visit [sig [(pathname) -> (void)]] [flags true])
  (visit-compiled-from-port [sig [(ptr) -> (ptr ...)]] [flags])
  (void [sig [() -> (void)]] [flags pure unrestricted mifoldable discard true])
  (warning [sig [(who string sub-ptr ...) -> (ptr ...)]] [flags])
  (warningf [sig [(who string sub-ptr ...) -> (ptr ...)]] [flags])
  (weak-cons [sig [(ptr ptr) -> (ptr)]] [flags unrestricted alloc])
  (weak-pair? [sig [(ptr) -> (boolean)]] [flags pure unrestricted mifoldable discard])
  (with-cost-center [sig [(cost-center procedure) (ptr cost-center procedure) -> (ptr ...)]] [flags])
  (with-input-from-file [sig [(pathname procedure) (pathname procedure sub-ptr) -> (ptr ...)]] [flags])   ; has options argument
  (with-input-from-string [sig [(string procedure) -> (ptr ...)]] [flags])
  (with-output-to-file [sig [(pathname procedure) (pathname procedure sub-ptr) -> (ptr ...)]] [flags])    ; has options argument
  (with-output-to-string [sig [(procedure) -> (string)]] [flags])
  (with-profile-tracker [sig [(procedure) (ptr procedure) -> (ptr ptr ...)]] [flags])
  (with-source-path [sig [(who pathname procedure) -> (ptr ...)]] [flags])
)

(define-symbol-flags* ([libraries] [flags system proc]) ; system procedures
  ($address-in-heap? [flags])
  ($address->object [flags])
  ($allocate-thread-parameter [feature pthreads] [flags alloc])
  ($apply [flags])
  ($assembly-output [flags])
  ($as-time-goes-by [flags])
  ($bignum-length [flags pure true])
  ($bigpositive? [flags])
  ($breakhere [flags])
  ($build-install-library/ct-code [flags])
  ($build-install-library/rt-code [flags])
  ($build-invoke-program [flags])
  ($byte-copy! [flags])
  ($bytevector-compress [flags])
  ($bytevector-ref-check? [flags])
  ($bytevector-set!-check? [flags])
  ($bytevector-set! [flags])
  ($bytevector-set-immutable! #;[sig [(bytevector) -> (ptr)]] [flags true])
  ($bytevector-uncompress [flags])
  ($capture-fasl-target [flags])
  ($c-error [flags])
  ($check-heap-errors [flags])
  ($clear-dynamic-closure-counts [flags])  ; added for closure instrumentation
  ($clear-pass-stats [flags])
  ($clear-source-lines-cache [flags])
  ($close-files [flags])
  ($close-resurrected-files [flags])
  ($close-resurrected-mutexes&conditions [feature pthreads] [flags])
  ($closure-code [flags])
  ($closure-length [flags])
  ($closure-ref [flags])
  ($c-make-closure [flags])
  ($c-make-code [flags])
  ($code? [flags])
  ($code-free-count [flags])
  ($code-info [flags])
  ($code-arity-mask [flags])
  ($code-name [flags])
  ($code-pinfo* [flags])
  ($collect-rendezvous [flags])
  ($compile-backend [flags])
  ($compiled-file-header? [flags])
  ($compile-host-library [flags])
  ($compound-condition-components [flags discard true])
  ($compound-condition? [flags pure unrestricted mifoldable discard])
  ($compressed-warning [flags])
  ($compute-composition [flags])
  ($compute-size [flags])
  ($constituent? [flags])
  ($constituent-ports [flags])
  ($continuation? [flags])
  ($continuation-link [flags])
  ($continuation-return-code [flags])
  ($continuation-return-livemask [flags])
  ($continuation-return-offset [flags])
  ($continuation-stack-clength [flags])
  ($continuation-stack-length [flags])
  ($continuation-stack-ref [flags])
  ($continuation-winders [flags])
  ($cp0 [flags])
  ($cpcheck [flags])
  ($cpcheck-prelex-flags [flags])
  ($cpcommonize [flags])
  ($cpletrec [flags])
  ($cpvalid [flags])
  ($c-stlv! [flags])
  ($cte-optimization-info [flags])
  ($c-tlv [flags])
  ($current-stack-link [flags])
  ($current-winders [flags])
  ($dequeue-scheme-signals [flags])
  ($distinct-bound-ids? [flags])
  ($dofmt [flags])
  ($do-wind [flags])
  ($dynamic-closure-counts [flags alloc])  ; added for closure instrumentation
  ($enum-set-members [flags])
  ($eol-style? [flags])
  ($eq-hashtable-cells [flags discard])
  ($eq-hashtable-clear! [flags true])
  ($eq-hashtable-copy [flags true discard])
  ($eq-hashtable-entries [flags discard])
  ($eq-hashtable-keys [flags true discard])
  ($eq-hashtable-values [flags true discard])
  ($errno [flags])
  ($errno->string [flags])
  ($error-handling-mode? [flags])
  ($event [flags])
  ($exactnum? [flags])
  ($exactnum-imag-part [flags])
  ($exactnum-real-part [flags])
  ($expand/cte/optimize #;[sig [(ptr) (ptr environment) -> (ptr)]] [flags])
  ($expand/cte #;[sig [(ptr) (ptr environment) -> (ptr)]] [flags])
  ($expand-fp-ftype [flags])
  ($expeditor [feature expeditor] [flags])
  ($fasl-base-rtd [flags])
  ($fasl-bld-graph [flags])
  ($fasl-enter [flags])
  ($fasl-file-equal? #;[sig [(pathname pathname) (pathname pathname ptr) -> (boolean)]] [flags])
  ($fasl-out [flags])
  ($fasl-start [flags])
  ($fasl-table [flags])
  ($fasl-wrf-graph [flags])
  ($filter-conv [flags])
  ($filter-foreign-type [flags])
  ($fixed-path? [flags])
  ($<= [flags])
  ($< [flags])
  ($= [flags])
  ($- [flags])
  ($/ [flags])
  ($* [flags])
  ($+ [flags])
  ($fleqv? [flags])
  ($flhash [flags])
  ($flonum->digits [flags])
  ($flonum-exponent [flags])
  ($flonum->fixnum [flags])
  ($flonum-sign [flags])
  ($flush-instruction-cache [flags])
  ($foreign-char? [flags pure unrestricted mifoldable discard])
  ($foreign-entries [flags])
  ($foreign-entry [flags discard])
  ($foreign-wchar? [flags pure unrestricted cp02])
  ($format-scheme-version [flags alloc])
  ($fp-filter-type [flags])
  ($fp-string->utf16 [flags])
  ($fp-string->utf32 [flags])
  ($fp-string->utf8 [flags])
  ($fptr-fptr-ref [flags discard])
  ($fptr-fptr-set! [flags])
  ($fptr-init-lock! [flags])
  ($fptr-locked-decr! [flags])
  ($fptr-locked-incr! [flags])
  ($fptr-lock! [flags])
  ($fptr-offset-addr [flags])
  ($fptr-ref-bits [flags discard])
  ($fptr-ref-boolean [flags discard])
  ($fptr-ref-char [flags discard])
  ($fptr-ref-double-float [flags discard])
  ($fptr-ref-fixnum [flags discard])
  ($fptr-&ref [flags discard])
  ($fptr-ref [flags discard])
  ($fptr-ref-ibits-swap-unsigned-16 [flags discard])
  ($fptr-ref-ibits-swap-unsigned-24 [flags discard])
  ($fptr-ref-ibits-swap-unsigned-32 [flags discard])
  ($fptr-ref-ibits-swap-unsigned-40 [flags discard])
  ($fptr-ref-ibits-swap-unsigned-48 [flags discard])
  ($fptr-ref-ibits-swap-unsigned-56 [flags discard])
  ($fptr-ref-ibits-swap-unsigned-64 [flags discard])
  ($fptr-ref-ibits-unsigned-16 [flags discard])
  ($fptr-ref-ibits-unsigned-24 [flags discard])
  ($fptr-ref-ibits-unsigned-32 [flags discard])
  ($fptr-ref-ibits-unsigned-40 [flags discard])
  ($fptr-ref-ibits-unsigned-48 [flags discard])
  ($fptr-ref-ibits-unsigned-56 [flags discard])
  ($fptr-ref-ibits-unsigned-64 [flags discard])
  ($fptr-ref-ibits-unsigned-8 [flags discard])
  ($fptr-ref-integer-16 [flags discard])
  ($fptr-ref-integer-24 [flags discard])
  ($fptr-ref-integer-32 [flags discard])
  ($fptr-ref-integer-40 [flags discard])
  ($fptr-ref-integer-48 [flags discard])
  ($fptr-ref-integer-56 [flags discard])
  ($fptr-ref-integer-64 [flags discard])
  ($fptr-ref-integer-8 [flags discard])
  ($fptr-ref-single-float [flags discard])
  ($fptr-ref-swap-boolean [flags discard])
  ($fptr-ref-swap-double-float [flags discard])
  ($fptr-ref-swap-fixnum [flags discard])
  ($fptr-ref-swap-integer-16 [flags discard])
  ($fptr-ref-swap-integer-24 [flags discard])
  ($fptr-ref-swap-integer-32 [flags discard])
  ($fptr-ref-swap-integer-40 [flags discard])
  ($fptr-ref-swap-integer-48 [flags discard])
  ($fptr-ref-swap-integer-56 [flags discard])
  ($fptr-ref-swap-integer-64 [flags discard])
  ($fptr-ref-swap-single-float [flags discard])
  ($fptr-ref-swap-unsigned-16 [flags discard])
  ($fptr-ref-swap-unsigned-24 [flags discard])
  ($fptr-ref-swap-unsigned-32 [flags discard])
  ($fptr-ref-swap-unsigned-40 [flags discard])
  ($fptr-ref-swap-unsigned-48 [flags discard])
  ($fptr-ref-swap-unsigned-56 [flags discard])
  ($fptr-ref-swap-unsigned-64 [flags discard])
  ($fptr-ref-swap-wchar [flags discard])
  ($fptr-ref-ubits-swap-unsigned-16 [flags discard])
  ($fptr-ref-ubits-swap-unsigned-24 [flags discard])
  ($fptr-ref-ubits-swap-unsigned-32 [flags discard])
  ($fptr-ref-ubits-swap-unsigned-40 [flags discard])
  ($fptr-ref-ubits-swap-unsigned-48 [flags discard])
  ($fptr-ref-ubits-swap-unsigned-56 [flags discard])
  ($fptr-ref-ubits-swap-unsigned-64 [flags discard])
  ($fptr-ref-ubits-unsigned-16 [flags discard])
  ($fptr-ref-ubits-unsigned-24 [flags discard])
  ($fptr-ref-ubits-unsigned-32 [flags discard])
  ($fptr-ref-ubits-unsigned-40 [flags discard])
  ($fptr-ref-ubits-unsigned-48 [flags discard])
  ($fptr-ref-ubits-unsigned-56 [flags discard])
  ($fptr-ref-ubits-unsigned-64 [flags discard])
  ($fptr-ref-ubits-unsigned-8 [flags discard])
  ($fptr-ref-unsigned-16 [flags discard])
  ($fptr-ref-unsigned-24 [flags discard])
  ($fptr-ref-unsigned-32 [flags discard])
  ($fptr-ref-unsigned-40 [flags discard])
  ($fptr-ref-unsigned-48 [flags discard])
  ($fptr-ref-unsigned-56 [flags discard])
  ($fptr-ref-unsigned-64 [flags discard])
  ($fptr-ref-unsigned-8 [flags discard])
  ($fptr-ref-wchar [flags discard])
  ($fptr-set-bits! [flags])
  ($fptr-set-bits-swap-unsigned-16! [flags])
  ($fptr-set-bits-swap-unsigned-24! [flags])
  ($fptr-set-bits-swap-unsigned-32! [flags])
  ($fptr-set-bits-swap-unsigned-40! [flags])
  ($fptr-set-bits-swap-unsigned-48! [flags])
  ($fptr-set-bits-swap-unsigned-56! [flags])
  ($fptr-set-bits-swap-unsigned-64! [flags])
  ($fptr-set-bits-unsigned-16! [flags])
  ($fptr-set-bits-unsigned-24! [flags])
  ($fptr-set-bits-unsigned-32! [flags])
  ($fptr-set-bits-unsigned-40! [flags])
  ($fptr-set-bits-unsigned-48! [flags])
  ($fptr-set-bits-unsigned-56! [flags])
  ($fptr-set-bits-unsigned-64! [flags])
  ($fptr-set-bits-unsigned-8! [flags])
  ($fptr-set-boolean! [flags])
  ($fptr-set-char! [flags])
  ($fptr-set-double-float! [flags])
  ($fptr-set-fixnum! [flags])
  ($fptr-set! [flags])
  ($fptr-set-integer-16! [flags])
  ($fptr-set-integer-24! [flags])
  ($fptr-set-integer-32! [flags])
  ($fptr-set-integer-40! [flags])
  ($fptr-set-integer-48! [flags])
  ($fptr-set-integer-56! [flags])
  ($fptr-set-integer-64! [flags])
  ($fptr-set-integer-8! [flags])
  ($fptr-set-single-float! [flags])
  ($fptr-set-swap-boolean! [flags])
  ($fptr-set-swap-double-float! [flags])
  ($fptr-set-swap-fixnum! [flags])
  ($fptr-set-swap-integer-16! [flags])
  ($fptr-set-swap-integer-24! [flags])
  ($fptr-set-swap-integer-32! [flags])
  ($fptr-set-swap-integer-40! [flags])
  ($fptr-set-swap-integer-48! [flags])
  ($fptr-set-swap-integer-56! [flags])
  ($fptr-set-swap-integer-64! [flags])
  ($fptr-set-swap-single-float! [flags])
  ($fptr-set-swap-unsigned-16! [flags])
  ($fptr-set-swap-unsigned-24! [flags])
  ($fptr-set-swap-unsigned-32! [flags])
  ($fptr-set-swap-unsigned-40! [flags])
  ($fptr-set-swap-unsigned-48! [flags])
  ($fptr-set-swap-unsigned-56! [flags])
  ($fptr-set-swap-unsigned-64! [flags])
  ($fptr-set-swap-wchar! [flags])
  ($fptr-set-unsigned-16! [flags])
  ($fptr-set-unsigned-24! [flags])
  ($fptr-set-unsigned-32! [flags])
  ($fptr-set-unsigned-40! [flags])
  ($fptr-set-unsigned-48! [flags])
  ($fptr-set-unsigned-56! [flags])
  ($fptr-set-unsigned-64! [flags])
  ($fptr-set-unsigned-8! [flags])
  ($fptr-set-wchar! [flags])
  ($fptr-spin-lock! [flags])
  ($fptr-unlock! [flags])
  ($fp-type->pred [flags])
  ($ftd? [flags])
  ($ftd-alignment [flags])
  ($ftd-as-box? [flags])
  ($ftd-atomic-category [flags])
  ($ftd-compound? [flags])
  ($ftd-size [flags])
  ($ftd-unsigned? [flags])
  ($ftd->members [flags])
  ($ftype-guardian-oops [flags])
  ($ftype-pointer? [flags])
  ($fxaddress [flags unrestricted alloc])
  ($fx-? [flags])
  ($fx/ [flags])
  ($fx* [flags])
  ($fx+? [flags])
  ($fxu< [flags pure cp02])
  ($fxvector-ref-check? [flags])
  ($fxvector-set!-check? [flags])
  ($fxvector-set-immutable! #;[sig [(fxvector) -> (ptr)]] [flags true])
  ($gc-cpu-time [flags true])
  ($gc-real-time [flags true])
  ($gensym->pretty-name [flags])
  ($guard [flags])
  ($hand-coded [flags])
  ($hashtable-report [flags true])
  ($hashtable-size->minlen [flags])
  ($hashtable-veclen [flags discard])
  ($ht-minlen [flags discard])
  ($ht-veclen [flags discard])
  ($immediate? [flags])
  ($impoops [flags abort-op])
  ($import-library [flags])
  ($inexactnum? [flags])
  ($inexactnum-imag-part [flags])
  ($inexactnum-real-part [flags])
  ($insert-profile-src! [flags])
  ($install-ftype-guardian [flags])
  ($install-guardian [flags])
  ($install-library-clo-info [flags])
  ($install-library/ct-code [flags])
  ($install-library/ct-desc [flags])
  ($install-library-entry [flags])
  ($install-library/rt-code [flags])
  ($install-library/rt-desc [flags])
  ($install-program-desc [flags])
  ($instantiate-code-object [flags])
  ($integer-16? [flags pure unrestricted mifoldable discard])
  ($integer-24? [flags pure unrestricted mifoldable discard])
  ($integer-32? [flags pure unrestricted mifoldable discard])
  ($integer-40? [flags pure unrestricted mifoldable discard])
  ($integer-48? [flags pure unrestricted mifoldable discard])
  ($integer-56? [flags pure unrestricted mifoldable discard])
  ($integer-64? [flags pure unrestricted mifoldable discard])
  ($integer-8? [flags pure unrestricted mifoldable discard])
  ($intern2 [flags])
  ($intern3 [flags])
  ($intern-gensym [flags])
  ($interpret-backend [flags])
  ($invalid-ftype-index [flags])
  ($invoke-library [flags])
  ($invoke-program [flags])
  ($io-init [flags])
  ($keep-live [flags])
  ($last-new-vector-element [flags])
  ($lexical-error [flags])
  ($library-search [flags])
  ($list-length [flags])
  ($load-library [flags])
  ($locate-source [flags])
  ($logand [flags])
  ($logbit0 [flags])
  ($logbit1 [flags])
  ($logbit? [flags])
  ($lognot [flags])
  ($logor [flags])
  ($logtest [flags])
  ($logxor [flags])
  ($lookup-library-entry [flags])
  ($loop-unroll-limit [flags])
  ($make-annotation-options [flags pure discard true])
  ($make-base-modules [flags])
  ($make-binary-input/output-port #;[sig [(string port-handler bytevector bytevector) (string port-handler bytevector bytevector ptr) -> (binary-input/output-port)]] [flags alloc])
  ($make-binary-input-port #;[sig [(string port-handler bytevector) (string port-handler bytevector ptr) -> (binary-input-port)]] [flags alloc])
  ($make-binary-output-port #;[sig [(string port-handler bytevector) (string port-handler bytevector ptr) -> (binary-output-port)]] [flags alloc])
  ($make-boot-file [flags])
  ($make-boot-header [flags])
  ($make-cinst [flags])
  ($make-closure [flags])
  ($make-code-object [flags])
  ($make-environment [flags])
  ($make-eq-hashtable [flags alloc])
  ($make-eqhash-vector [flags alloc])
  ($make-exactnum [flags])
  ($make-fasl-strip-options [flags pure discard true])
  ($make-file-options [flags pure discard true])
  ($make-fmt->expr [flags])
  ($make-foreign-callable [flags])
  ($make-foreign-procedure [flags])
  ($make-fptr [flags pure mifoldable discard true])
  ($make-ftype-guardian [flags alloc cp02])
  ($make-graph-env [flags])
  ($make-library-requirements-options [flags pure discard true])
  ($make-load-binary [flags])
  ($make-object-finder [flags])
  ($make-promise [flags alloc])
  ($make-read [flags])
  ($make-recompile-condition [flags])
  ($make-record-constructor-descriptor [flags pure true cp02])
  ($make-record-type-descriptor [flags pure alloc cp02])
  ($make-record-type #;[sig [(rtd maybe-rtd sub-ptr sub-list ptr ptr ptr ...) -> (rtd)]] [flags pure alloc cp02])
  ($make-relocation-table! [flags])
  ($make-rnrs-libraries [flags])
  ($make-source-oops [flags])
  ($make-src-condition [flags])
  ($make-textual-input/output-port #;[sig [(string port-handler string string) (string port-handler string string ptr) -> (textual-input/output-port)]] [flags alloc])
  ($make-textual-input-port #;[sig [(string port-handler string) (string port-handler string ptr) -> (textual-input-port)]] [flags alloc])
  ($make-textual-output-port #;[sig [(string port-handler string) (string port-handler string ptr) -> (textual-output-port)]] [flags alloc])
  ($make-tlc [flags alloc])
  ($make-vtable [flags])
  ($map [flags])
  ($mark-invoked! [flags])
  ($mark-pending! [flags])
  ($maybe-compile-file [flags])
  ($noexpand? [flags])
  ($np-boot-code [flags])
  ($np-compile [flags])
  ($np-get-timers [flags])
  ($np-last-pass [flags])
  ($np-reset-timers! [flags])
  ($np-tracer [flags])
  ($null-continuation [flags])
  ($object-address [flags])
  ($object-in-heap? [flags])
  ($object-ref [flags]) ; can't fold since optimize-level 2 version does no checks
  ($object-set! [flags])
  ($oops/c [flags abort-op])
  ($oops [flags abort-op])
  ($open-bytevector-list-output-port [flags])
  ($open-file-input/output-port [flags])
  ($open-file-input-port [flags])
  ($open-file-output-port [flags])
  ($open-source-file [flags])
  ($parse-format-string [flags])
  ($pass-stats-fields [flags])
  ($pass-stats [flags])
  ($pass-time [flags])
  ($port-flags-set? [flags])
  ($port-handler [flags])
  ($port-info #;[sig [(port) -> (ptr)]] [flags discard])
  ($print-pass-stats [flags])
  ($procedure-name [flags])
  ($profile-block-data? [flags])
  ($profile-show-database [flags])
  ($profile-source-data? [flags])
  ($ptr-copy! [flags])
  ($quotient-remainder [flags])
  ($ratio-denominator [flags])
  ($ratio-numerator [flags])
  ($raw-collect-cond [feature pthreads] [flags])
  ($raw-tc-mutex [feature pthreads] [flags])
  ($read-performance-monitoring-counter [flags])
  ($read-time-stamp-counter [flags])
  ($real->flonum [flags arith-op mifoldable discard])
  ($real-sym-name [flags])
  ($recompile-condition? [flags])
  ($recompile-importer-path [flags])
  ($record [flags cp02 unrestricted alloc]) ; first arg should be an rtd, but we don't check
  ($record? [flags pure mifoldable discard])
  ($record-equal-procedure [flags discard])
  ($record-hash-procedure [flags discard])
  ($record-oops #;[sig [(who sub-ptr rtd) -> (bottom)]] [flags abort-op])
  ($record-type-descriptor [flags pure mifoldable discard true])
  ($record-type-field-offsets [flags pure mifoldable discard true])
  ($reloc [flags])
  ($remake-rtd [flags])
  ($report-string [flags])
  ($require-include [flags])
  ($require-libraries [flags])
  ($reset-port-flags! [flags true])
  ($reset-protect [flags])
  ($revisit [flags])
  ($rtd-counts? [flags])
  ($scheme [flags])
  ($scheme-greeting [flags])
  ($scheme-init [flags])
  ($sc-put-cte [flags])
  ($sc-put-property! [flags])
  ($script [flags])
  ($sealed-record? [flags pure mifoldable discard])
  ($set-code-byte! [flags])
  ($set-code-long! [flags])
  ($set-code-quad! [flags])
  ($set-code-word! [flags])
  ($set-collect-trip-bytes [flags])
  ($set-port-flags! [flags true])
  ($set-port-info! #;[sig [(port ptr) -> (void)]] [flags true])
  ($set-symbol-hash! [flags])
  ($set-symbol-name! [flags])
  ($set-symbol-property-list! [flags])
  ($set-system-property-list! [flags])
  ($set-thread-parameter! [feature pthreads] [flags])
  ($set-timer [flags])
  ($set-tlc-next! [flags true])
  ($set-top-level-value! [flags true cp02])
  ($sgetprop [flags])
  ($show-allocation [flags])
  ($signal-interrupt-handler [flags])
  ($source-file-descriptor [flags])
  ($source-violation [flags])
  ($source-warning [flags])
  ($spaces [flags])
  ($split-continuation [flags])
  ($sputprop [flags])
  ($src-condition? [flags])
  ($src-condition-src [flags])
  ($src-condition-start [flags])
  ($sremprop [flags])
  ($string-char-foldcase [flags])
  ($string-ref-check? [flags])
  ($string-set!-check? [flags])
  ($string-set-immutable! #;[sig [(string) -> (ptr)]] [flags true])
  ($str->num [flags])
  ($subsequent? [flags])
  ($swap-object-ref [flags]) ; can't fold since optimize-level 2 version does no checks
  ($symbol-hash [flags])
  ($symbol-name [flags])
  ($symbol-property-list [flags])
  ($symbol-type [flags])
  ($syntax-dispatch [flags])
  ($syntax-match? [flags])
  ($syntax->src [flags])
  ($syntax-top-level? [flags])
  ($system-code? [flags])
  ($system-environment [flags])
  ($system-library? [flags])
  ($system-procedure? [flags])
  ($system-property-list [flags])
  ($tc-field [flags])
  ($tc [flags])
  ($thread-list [flags])
  ($thread-tc [flags])
  ($tlc? [flags pure unrestricted mifoldable discard])
  ($tlc-ht [flags mifoldable discard])
  ($tlc-keyval [flags pure mifoldable discard])
  ($tlc-next [flags mifoldable discard])
  ($top-level-bound? [flags discard])
  ($top-level-value [flags discard cp02])
  ($trace-closure [flags pure alloc])
  ($trace [flags])
  ($track-dynamic-closure-counts [flags])      ; added for closure instrumentation
  ($track-static-closure-counts [flags alloc]) ; added for closure instrumentation
  ($trans-define-ftype [flags])
  ($transformer->binding [flags])
  ($trans-ftype-guardian [flags])
  ($trans-ftype-locked-op! [flags])
  ($trans-ftype-pointer? [flags])
  ($trans-ftype-&ref [flags])
  ($trans-ftype-ref [flags])
  ($trans-ftype-set! [flags])
  ($trans-ftype-sizeof [flags])
  ($trans-make-ftype-pointer [flags])
  ($unbound-object? [flags pure unrestricted mifoldable discard])
  ($unbound-object [flags pure unrestricted mifoldable discard true])
  ($uncprep [flags]) ; side-effects preinfo-sexpr, at least
  ($undefined-violation [flags abort-op])
  ($untrace [flags])
  ($unwrap-ftype-pointer [flags])
  ($vector-ref-check? [flags])
  ($vector-set!-check? [flags])
  ($vector-set-immutable! #;[sig [(vector) -> (ptr)]] [flags true])
  ($verify-ftype-address [flags cp02])
  ($verify-ftype-pointer [flags])
  ($visit [flags])
  ($visit-library [flags])
  ($with-fasl-target [flags])
  ($write-pretty-quick [flags])
  ($xscript-port? [flags])
)

(define-symbol-flags* ([libraries] [flags system]) ; system options sets
  ($annotation-options [flags])
  ($fasl-strip-options [flags])
  ($file-options [flags])
  ($library-requirements-options [flags])
)

(define-symbol-flags* ([libraries] [flags system proc]) ; system parameters
  ($block-counter [flags])
  ($cafe [flags])
  ($compile-profile [flags])
  ($cp0-inner-unroll-limit #;[sig [() -> (ufixnum)] [(ufixnum) -> (void)]] [flags])
  ($cp0-polyvariant #;[sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  ($current-mso [flags])
  ($enable-check-heap [flags])
  ($enable-check-prelex-flags [flags])
  ($enable-expeditor [feature expeditor] [flags])
  ($enable-pass-timing [flags])
  ($expeditor-history-file [feature expeditor] [flags])
  ($fasl-target [flags])
  ($optimize-closures #;[sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  ($suppress-primitive-inlining #;[sig [() -> (boolean)] [(ptr) -> (void)]] [flags unrestricted])
  ($sfd [flags])
  ($target-machine [flags])
)

(define-symbol-flags* ([libraries] [flags system]) ; system state variables
  ($active-threads [flags])
  ($c-bufsiz [flags])
  ($collect-cond [feature pthreads] [flags])
  ($collect-request-pending [flags])
  ($compiler-is-loaded? [flags])
  ($console-error-port [flags])
  ($console-input-port [flags])
  ($console-output-port [flags])
  ($eq-ht-rtd [flags])
  ($heap-reserve-ratio [flags])
  ($interrupt [flags])
  ($nuate [flags])
  ($scheme-version [flags])
  ($session-key [flags])
  ($symbol-ht-rtd [flags])
  ($tc-mutex [feature pthreads] [flags])
)

(define-symbol-flags* ([libraries] [flags system-keyword]) ; condition types
  ($&src [flags])
  ($&recompile [flags])
)

(define-symbol-flags* ([libraries] [flags system-keyword])
  ($case [flags])
  ($chezscheme-csv7 [flags library-uid])
  ($cost-center [flags])
  ($foreign-callable [flags])
  ($foreign-procedure [flags])
  ($import [flags])
  ($library [flags])
  ($module [flags])
  ($moi [flags])
  ($program [flags])
  ($rnrs [flags library-uid])
  ($rnrs-arithmetic-bitwise [flags library-uid])
  ($rnrs-arithmetic-fixnums [flags library-uid])
  ($rnrs-arithmetic-flonums [flags library-uid])
  ($rnrs-base [flags library-uid])
  ($rnrs-bytevectors [flags library-uid])
  ($rnrs-conditions [flags library-uid])
  ($rnrs-control [flags library-uid])
  ($rnrs-enums [flags library-uid])
  ($rnrs-eval [flags library-uid])
  ($rnrs-exceptions [flags library-uid])
  ($rnrs-files [flags library-uid])
  ($rnrs-hashtables [flags library-uid])
  ($rnrs-io-ports [flags library-uid])
  ($rnrs-io-simple [flags library-uid])
  ($rnrs-lists [flags library-uid])
  ($rnrs-mutable-pairs [flags library-uid])
  ($rnrs-mutable-strings [flags library-uid])
  ($rnrs-programs [flags library-uid])
  ($rnrs-r5rs [flags library-uid])
  ($rnrs-records-procedural [flags library-uid])
  ($rnrs-records-syntactic [flags library-uid])
  ($rnrs-records-inspection [flags library-uid])
  ($rnrs-sorting [flags library-uid])
  ($rnrs-syntax-case [flags library-uid])
  ($rnrs-unicode [flags library-uid])
)
