#ifndef COLOR_H
#define COLOR_H

#include <cstdio>
#include <vector>

struct LUT
{
  double z_low, z_high, i_dz;
  int rgb_low[3], rgb_high[3], rgb_diff[3];
  int annot;
  int skip;
};

struct BFN_COLOR
{ /* For back-, fore-, and nan-colors */
  int rgb[3];
  int skip;
};

struct CPT
{
  int ncolors;
  std::vector<LUT> lut;
  BFN_COLOR bfn[3];
};

int cpt_read(FILE *fp, CPT *cpt);
int cpt_write(FILE *fp, CPT cpt);
int cpt_write_c(FILE *fp, CPT cpt, const char *name);

#endif /* COLOR_H */
