/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

class HTTPMethodSpec {
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
    private static final int[] HTTP_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64};
    private static final int NA = 0;
    private static final int INTEGRAL = 1;
    private static final int CONFIDENTIAL = 2;
    private int mask = 0;
    private int transport = 0;
    private String actions;

    public HTTPMethodSpec(String name) {
        this(name, false);
    }

    public HTTPMethodSpec(String[] HTTPMethods) {
        this(HTTPMethods, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPMethodSpec(String name, boolean parseTransportType) {
        if (name == null || name.length() == 0) {
            this.mask = 127;
            this.transport = parseTransportType ? 3 : 0;
            return;
        } else {
            String[] tokens = name.split(":", 2);
            if (tokens[0].length() == 0) {
                this.mask = 127;
            } else {
                String[] methods = tokens[0].split(",", -1);
                for (int i = 0; i < methods.length; ++i) {
                    boolean found = false;
                    for (int j = 0; j < HTTP_METHODS.length; ++j) {
                        if (!methods[i].equals(HTTP_METHODS[j])) continue;
                        this.mask |= HTTP_MASKS[j];
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IllegalArgumentException("Invalid HTTPMethodSpec");
                }
            }
            if (tokens.length == 2) {
                if (!parseTransportType) {
                    throw new IllegalArgumentException("Invalid HTTPMethodSpec");
                }
                if (tokens[1].length() == 0) {
                    throw new IllegalArgumentException("Missing transport type");
                }
                if (tokens[1].equals("INTEGRAL")) {
                    this.transport = 1;
                    return;
                } else {
                    if (!tokens[1].equals("CONFIDENTIAL")) throw new IllegalArgumentException("Invalid transportType");
                    this.transport = 2;
                }
                return;
            } else {
                this.transport = parseTransportType ? 3 : 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPMethodSpec(String[] HTTPMethods, String transportType) {
        boolean parseTransportType;
        boolean bl = parseTransportType = transportType != null;
        if (HTTPMethods == null || HTTPMethods.length == 0) {
            this.mask = 127;
        } else {
            for (int i = 0; i < HTTPMethods.length; ++i) {
                boolean found = false;
                for (int j = 0; j < HTTP_METHODS.length; ++j) {
                    if (!HTTPMethods[i].equals(HTTP_METHODS[j])) continue;
                    this.mask |= HTTP_MASKS[j];
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Invalid HTTPMethodSpec");
            }
        }
        if (parseTransportType) {
            if (transportType.length() == 0) {
                this.transport = 3;
                return;
            } else if (transportType.equals("INTEGRAL")) {
                this.transport = 1;
                return;
            } else {
                if (!transportType.equals("CONFIDENTIAL")) throw new IllegalArgumentException("Invalid transportType");
                this.transport = 2;
            }
            return;
        } else {
            this.transport = 0;
        }
    }

    public boolean equals(HTTPMethodSpec o) {
        return this.mask == o.mask && this.transport == o.transport;
    }

    public String getActions() {
        if (this.actions == null) {
            boolean first = true;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < HTTP_MASKS.length; ++i) {
                if ((this.mask & HTTP_MASKS[i]) <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(HTTP_METHODS[i]);
            }
            if (this.transport != 0) {
                buffer.append(":");
                if (this.transport != 3) {
                    if (this.transport == 1) {
                        buffer.append("INTEGRAL");
                    } else {
                        buffer.append("CONFIDENTIAL");
                    }
                }
            }
            this.actions = buffer.toString();
        }
        return this.actions;
    }

    public int hashCode() {
        return this.mask ^ this.transport;
    }

    public boolean implies(HTTPMethodSpec p) {
        return (this.mask & p.mask) == p.mask && (this.transport & p.transport) == p.transport;
    }
}

